/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.nativecore.ext.manifest.Privilege;
import org.tizen.nativecore.misc.core.PrivilegeLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrivilegeManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DIR_PRIVILEGES = String.valueOf(File.separator) + "privileges" + File.separator + "native";
    private static final String E_ENTRY = "entry";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_LEVEL = "level";
    private static final String ATTR_DESC = "desc";
    public static final String LICENSE_FOLDER_PATH = "/res/.appdefined-license/";
    private static TreeMap<String, Privilege> fPrivileges;
    private IProject project;

    public PrivilegeManager(IProject project) {
        fPrivileges = new TreeMap();
        this.project = project;
        this.init();
    }

    public void init() {
        if (this.project == null) {
            return;
        }
        TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)this.project);
        if (!ProjectUtil.isSupportedPlatform((TizenProjectDescription)tizenDesc)) {
            return;
        }
        String privilegeFilePath = String.valueOf(tizenDesc.getPlatformInfo().getPlatformPath(tizenDesc.getVersion())) + DIR_PRIVILEGES;
        File dir = new File(privilegeFilePath);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("privilege.*\\.properties");
            }
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.loadPrivilege(file);
                ++n2;
            }
        } else {
            this.logger.error("There is no .properties file to import privileges");
        }
    }

    private void loadPrivilegeFromInputStream(InputStream is) {
        try {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(is);
                NodeList nodes = dom.getElementsByTagName(E_ENTRY);
                int i = 0;
                while (i < nodes.getLength()) {
                    Node node = nodes.item(i);
                    if (node instanceof Element) {
                        Privilege priv = null;
                        Element e = (Element)node;
                        String key = e.getAttribute(ATTR_KEY);
                        if (key.length() > 0) {
                            String desc;
                            PrivilegeLevel l;
                            priv = new Privilege(key);
                            String v = e.getAttribute(ATTR_LEVEL);
                            if (v.length() > 0 && (l = PrivilegeLevel.getEnumByName(v)) != null) {
                                priv.setLevel(l);
                            }
                            if ((desc = e.getAttribute(ATTR_DESC)) != null) {
                                priv.setDescription(desc);
                            }
                        }
                        if (priv != null) {
                            fPrivileges.put(key, priv);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.logger.error("Exception occurred while loading xml file.", (Throwable)e);
                IOUtil.tryClose((Object[])new Object[]{is});
                return;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
    }

    private void loadPrivilege(File file) {
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                this.loadPrivilegeFromInputStream(fis);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public PrivilegeLevel getPrivilegeLevel(String key) {
        Privilege p = fPrivileges.get(key);
        if (p != null) {
            return p.getLevel();
        }
        return PrivilegeLevel.PUBLIC;
    }

    public String[] getAvailablePrivileges() {
        Set<String> keys = fPrivileges.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public boolean isValidPrivilege(String key) {
        return fPrivileges.containsKey(key);
    }

    public String getDescription(String privilege) {
        String desc = null;
        for (String key : fPrivileges.keySet()) {
            if (!key.contains(privilege)) continue;
            desc = fPrivileges.get(key).getDescription();
        }
        return desc;
    }

    public void copyLicenseFile(String licensePath) {
        String projLicensePath = this.project.getLocation().append(LICENSE_FOLDER_PATH).toString();
        File licenseDir = new File(projLicensePath);
        if (!licenseDir.exists()) {
            licenseDir.mkdirs();
        }
        File license = new File(licensePath);
        File desLicense = new File(String.valueOf(projLicensePath) + license.getName());
        try {
            Files.copy(license.toPath(), desLicense.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {}
    }

    public static List<Privilege> getPlatformPrivileges() {
        ArrayList<Privilege> list = new ArrayList<Privilege>();
        for (Privilege prv : fPrivileges.values()) {
            if (!prv.getLevel().equals((Object)PrivilegeLevel.PLATFORM)) continue;
            list.add(prv);
        }
        return list;
    }
}

