/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.apichecker.quickfix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.util.ProjectUtil;
import org.tizen.nativecore.apichecker.utility.CommonUtility;
import org.tizen.nativecore.apichecker.utility.Messages;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.xmlstore.CoreXMLStore;
import org.tizen.nativecore.misc.editor.ManifestEditor;

public class QuickFixForUndefinedPrivilege
extends WorkbenchMarkerResolution {
    private String label;
    private String privilege;
    private List<ManifestEditor> editorList = new ArrayList<ManifestEditor>();
    private List<CoreXMLStore> xmlStoreList = new ArrayList<CoreXMLStore>();
    private HashMap<IProject, HashMap<String, Integer>> projectMap = new HashMap();

    public QuickFixForUndefinedPrivilege(String privilege) {
        if (privilege == null) {
            return;
        }
        this.privilege = privilege;
        this.label = NLS.bind((String)Messages.QuickFixer_labelMessage, (Object)privilege);
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        IProject project = null;
        if (marker.getResource() instanceof IFile) {
            IFile file = (IFile)marker.getResource();
            project = file.getProject();
        } else if (marker.getResource() instanceof IProject) {
            project = (IProject)marker.getResource();
        } else {
            MessageDialog.openError(null, (String)Messages.QuickFixer_DialogMessage, (String)Messages.QuickFixer_errorMessage);
            return;
        }
        try {
            int n;
            int n2;
            IEditorReference[] iEditorReferenceArray;
            IWorkbenchPage page;
            String privilege = this.getPrivilegeString((String)marker.getAttribute("message"));
            if (project == null || privilege == null) {
                return;
            }
            HashMap<Object, Object> unusedPrivilegeMap = new HashMap();
            unusedPrivilegeMap = CommonUtility.populateUnusedPrivileges(project);
            TizenProjectType projectType = ProjectUtil.getTizenProjectType((IProject)project);
            if (projectType == null) {
                return;
            }
            switch (projectType) {
                case TIZEN_C_UI_APPLICATION: 
                case TIZEN_C_SERVICE_APPLICATION: 
                case TIZEN_CPP_UI_APPLICATION: 
                case TIZEN_CPP_SERVICE_APPLICATION: {
                    break;
                }
            }
            boolean isManifestEditorOpened = false;
            ArrayList<String> privileges = new ArrayList<String>();
            if (privilege.contains("and")) {
                StringTokenizer tokenizer = new StringTokenizer(privilege, ", ");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken().trim();
                    if (!token.startsWith("http:")) continue;
                    privileges.add(token);
                }
            } else {
                privileges.add(privilege);
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = page = window != null ? window.getActivePage() : null;
            if (page != null) {
                IEditorReference[] editorRefs;
                iEditorReferenceArray = editorRefs = page.getEditorReferences();
                n2 = editorRefs.length;
                n = 0;
                while (n < n2) {
                    IEditorPart editorPart;
                    IEditorReference editorRef = iEditorReferenceArray[n];
                    String editorId = editorRef.getId();
                    if (editorId.equals("org.tizen.nativecore.misc.ManifestEditor") && (editorPart = editorRef.getEditor(true)) != null) {
                        ManifestEditor manifestEditor = (ManifestEditor)editorPart;
                        Manifest manifest = manifestEditor.getCoreManifest();
                        IProject eProject = manifestEditor.getProject();
                        if (eProject == null || project.getName().equals(eProject.getName())) {
                            int i = 0;
                            while (i < privileges.size()) {
                                manifest.addPrivilege((String)privileges.get(i));
                                manifestEditor.getPrivilegePage().firePrivilegeAdded((String)privileges.get(i));
                                ++i;
                            }
                            manifestEditor.getPrivilegePage().update(manifest);
                            manifestEditor.getPrivilegePage().setDirty(true);
                            manifestEditor.updateXmlFromUI();
                            isManifestEditorOpened = true;
                            if (this.editorList.contains(manifestEditor)) break;
                            this.editorList.add(manifestEditor);
                            break;
                        }
                    }
                    ++n;
                }
            }
            if (!isManifestEditorOpened) {
                CoreXMLStore coreXMLStore = new CoreXMLStore(project);
                coreXMLStore.loadXml();
                int i = 0;
                while (i < privileges.size()) {
                    coreXMLStore.getCoreManifest().addPrivilege((String)privileges.get(i));
                    ++i;
                }
                if (!this.xmlStoreList.contains(coreXMLStore)) {
                    this.xmlStoreList.add(coreXMLStore);
                }
            }
            marker.delete();
            this.projectMap.put(project, unusedPrivilegeMap);
            IMarker[] markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (markers == null) {
                return;
            }
            iEditorReferenceArray = markers;
            n2 = markers.length;
            n = 0;
            while (n < n2) {
                String message;
                IEditorReference testMarker = iEditorReferenceArray[n];
                if (testMarker != null && (message = (String)testMarker.getAttribute("message")).contains("needs additional privilege")) {
                    this.handleMarker((IMarker)testMarker, privileges);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            LoggerFactory.getLogger(QuickFixForUndefinedPrivilege.class).error("Problem in accessing marker");
        }
    }

    private void handleMarker(IMarker marker, List<String> privileges) {
        HashMap<Object, Boolean> unresolvedPrivMap = new HashMap<Object, Boolean>();
        ArrayList<String> unresolvedPrivList = new ArrayList<String>();
        try {
            String message = (String)marker.getAttribute("message");
            String[] words = message.split(" ");
            int i = 0;
            while (i < words.length) {
                if (words[i].startsWith("http:")) {
                    unresolvedPrivMap.put(words[i], true);
                }
                ++i;
            }
            i = 0;
            while (i < privileges.size()) {
                String priv = privileges.get(i);
                if (unresolvedPrivMap.get(priv) != null) {
                    unresolvedPrivMap.put(priv, false);
                }
                ++i;
            }
            for (String key : unresolvedPrivMap.keySet()) {
                if (!((Boolean)unresolvedPrivMap.get(key)).booleanValue()) continue;
                unresolvedPrivList.add(key);
            }
            if (unresolvedPrivList.size() == 0) {
                marker.delete();
                return;
            }
            String errorMsg = message.substring(0, message.indexOf("http:"));
            if (unresolvedPrivList.size() == 1) {
                errorMsg = String.valueOf(errorMsg) + (String)unresolvedPrivList.get(0) + " .";
            } else {
                int size = unresolvedPrivList.size();
                int i2 = 0;
                while (i2 < size) {
                    errorMsg = String.valueOf(errorMsg) + (String)unresolvedPrivList.get(i2) + " ";
                    errorMsg = ++i2 == size - 1 ? String.valueOf(errorMsg) + " and " : (i2 != size ? String.valueOf(errorMsg) + " , " : String.valueOf(errorMsg) + " .");
                }
            }
            marker.setAttribute("message", (Object)errorMsg);
        }
        catch (CoreException coreException) {
            LoggerFactory.getLogger(QuickFixForUndefinedPrivilege.class).error("Problem in accessing marker");
        }
    }

    private String getPrivilegeString(String message) {
        String[] words = message.split(" ");
        int privilegeCount = 0;
        int Count = 0;
        ArrayList<String> privileges = new ArrayList<String>();
        int i = 0;
        while (i < words.length) {
            if (words[i].startsWith("http:")) {
                ++privilegeCount;
                privileges.add(words[i]);
            }
            ++i;
        }
        String multiplePrivilege = "";
        while (privilegeCount != Count) {
            multiplePrivilege = String.valueOf(multiplePrivilege) + (String)privileges.get(Count);
            if (++Count == privilegeCount - 1) {
                multiplePrivilege = String.valueOf(multiplePrivilege) + " and ";
                continue;
            }
            if (Count == privilegeCount) continue;
            multiplePrivilege = String.valueOf(multiplePrivilege) + " , ";
        }
        return multiplePrivilege;
    }

    public String getDescription() {
        return this.privilege;
    }

    public Image getImage() {
        return null;
    }

    public IMarker[] findOtherMarkers(IMarker[] all) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                String message = (String)marker.getAttribute("message");
                if (!this.getDescription().equals(message) && message.contains("needs additional privilege")) {
                    markers.add(marker);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return markers.toArray(new IMarker[markers.size()]);
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.exists()) {
                this.run(marker);
            }
            ++n2;
        }
        for (ManifestEditor manifestEditor : this.editorList) {
            manifestEditor.doSave(null);
        }
        for (CoreXMLStore coreXMLStore : this.xmlStoreList) {
            coreXMLStore.storeXml();
        }
        for (IProject project : this.projectMap.keySet()) {
            CommonUtility.creatUnusedPrivilegeMarkers(project, this.projectMap.get(project));
        }
        this.projectMap.clear();
    }
}

