/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.utils;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.tizen.nativecore.misc.utils.Constants;
import org.tizen.nativecore.misc.utils.OSChecker;

public class WorkspaceUtils {
    private WorkspaceUtils() {
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String getActiveId() {
        IWorkbenchPart part;
        IWorkbenchPage page;
        String id = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null) {
            IWorkbenchPartSite site = part.getSite();
            id = site.getId();
        }
        return id;
    }

    public static void showView(String viewId) {
        final String id = viewId;
        WorkspaceUtils.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    try {
                        IViewPart viewPart = page.findView(id);
                        if (viewPart != null) {
                            page.showView(id);
                        } else {
                            page.showView("org.eclipse.ui.navigator.ProjectExplorer");
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static String getXmlsPath(String version, String profileName) {
        String path = WorkspaceUtils.getParentPathOfIDE();
        if (version != null && profileName != null) {
            if (version.equals("2.3")) {
                path = String.valueOf(path) + Constants.PATH_2_3_XMLS;
            } else if (version.equals("2.3.1")) {
                if (profileName.equals("mobile")) {
                    path = String.valueOf(path) + Constants.PATH_2_3_1_MOBILE_XMLS;
                }
                if (profileName.equals("wearable")) {
                    path = String.valueOf(path) + Constants.PATH_2_3_1_WEARABLE_XMLS;
                }
            } else {
                if (profileName.equals("mobile")) {
                    path = String.valueOf(path) + Constants.PATH_2_4_MOBILE_XMLS;
                }
                if (profileName.equals("wearable")) {
                    path = String.valueOf(path) + Constants.PATH_2_4_WEARABLE_XMLS;
                }
            }
        }
        return WorkspaceUtils.convertPlatformSpecific(path);
    }

    public static String getVersionBasedXmlsPath() {
        String path = WorkspaceUtils.getParentPathOfIDE();
        return WorkspaceUtils.convertPlatformSpecific(path);
    }

    public static String getPathOfIDE() {
        if (Platform.getInstallLocation() != null) {
            String idePath = Platform.getInstallLocation().getURL().getPath();
            return idePath;
        }
        return "";
    }

    public static String getParentPathOfIDE() {
        if (Platform.getInstallLocation() != null) {
            String sdkRoot = new Path(Platform.getInstallLocation().getURL().getPath()).removeLastSegments(1).toOSString();
            if (OSChecker.isWindows()) {
                if (sdkRoot.endsWith("\\")) {
                    sdkRoot = sdkRoot.substring(0, sdkRoot.length() - 1);
                }
                if (sdkRoot.toLowerCase().endsWith("ospdsdk")) {
                    sdkRoot = sdkRoot.substring(0, sdkRoot.length() - 8);
                }
            } else {
                if (sdkRoot.endsWith("/")) {
                    sdkRoot = sdkRoot.substring(0, sdkRoot.length() - 1);
                }
                if (sdkRoot.toLowerCase().endsWith("ospdsdk")) {
                    sdkRoot = sdkRoot.substring(0, sdkRoot.length() - 8);
                }
            }
            return sdkRoot;
        }
        return "";
    }

    public static String convertPlatformSpecific(String strAndSlashes) {
        if (OSChecker.isWindows()) {
            return strAndSlashes.replaceAll("/", "\\\\");
        }
        return strAndSlashes.replaceAll("\\\\", "/");
    }
}

