/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ProjectUtil;
import org.tizen.nativecore.ext.manifest.Feature;
import org.tizen.nativecore.ext.manifest.Manifest;

public class FeatureManager {
    public static final String FKEY_PREFIX = "http://tizen.org/feature/";
    public static final String FKEY_SSIZE_ALL = "http://tizen.org/feature/screen.size.all";
    public static final String FKEY_SSIZE_NORMAL = "http://tizen.org/feature/screen.size.normal";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String DIR_FEATURES = String.valueOf(File.separator) + "features" + File.separator + "native";
    private IProject project;
    public static final String ELEMENT_FEATURE = "Feature";
    List<Feature> fFeatures;

    public FeatureManager(IProject project) {
        this.project = project;
        this.initTables();
    }

    /*
     * Exception decompiling
     */
    private void loadFeature(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initTables() {
        if (this.project == null) {
            return;
        }
        this.fFeatures = new ArrayList<Feature>();
        TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)this.project);
        if (!ProjectUtil.isSupportedPlatform((TizenProjectDescription)tizenDesc)) {
            return;
        }
        String featureFilePath = String.valueOf(tizenDesc.getPlatformInfo().getPlatformPath(tizenDesc.getVersion())) + DIR_FEATURES;
        File dir = new File(featureFilePath);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("feature.*\\.xml");
            }
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.loadFeature(file);
                ++n2;
            }
        } else {
            this.logger.error("There is no xml file to import features");
        }
    }

    public Feature[] getUnusedFeatures(Manifest model) {
        ArrayList<Feature> possibleFeatures = new ArrayList<Feature>();
        Map<String, Feature> usedFeatures = model.getFeature_map();
        for (Feature f : this.fFeatures) {
            if (usedFeatures.containsKey(f.getKey()) || f.isHidden()) continue;
            possibleFeatures.add(f);
        }
        return possibleFeatures.toArray(new Feature[possibleFeatures.size()]);
    }

    public Feature getFeature(String key) {
        Feature f2;
        for (Feature f2 : this.fFeatures) {
            if (!key.equals(f2.getKey())) continue;
            return f2;
        }
        f2 = new Feature(key, Feature.FEATURE_TYPE.FT_UNKNOWN);
        return f2;
    }
}

