/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.core.LanguageData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LanguageListXmlStore {
    private static LanguageListXmlStore thisInstance = null;
    public static final String FILE_NAME = "templates/resource/lang_country_list.xml";
    public static final String ELEMENT_NAME = "languages";
    public static final String TAG_LANG = "lang";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String LANG_VALUE_ENGLISH = "English";
    private String filePath = "";
    private ArrayList<LanguageData> languageList = new ArrayList();

    public static LanguageListXmlStore getInstance() {
        if (thisInstance == null) {
            thisInstance = new LanguageListXmlStore();
        }
        return thisInstance;
    }

    public LanguageListXmlStore() {
        if (IdePlugin.getDefault().getResourceLocationURL(FILE_NAME) != null) {
            this.filePath = IdePlugin.getDefault().getResourceLocationURL(FILE_NAME).getFile();
            this.loadXML(this.filePath);
        }
    }

    public ArrayList<LanguageData> getLanguageList() {
        return this.languageList;
    }

    public ArrayList<LanguageData> getDefaultLanguages() {
        ArrayList<LanguageData> list = new ArrayList<LanguageData>();
        list.add(new LanguageData("en-gb", "English (UK)"));
        return list;
    }

    private boolean loadXML(String path) {
        block32: {
            this.clear();
            if (path == null || path.length() == 0) {
                return false;
            }
            FileInputStream stream = null;
            try {
                File file = new File(path);
                if (!file.exists()) {
                    return false;
                }
                stream = new FileInputStream(file);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(stream);
                Element root = dom.getDocumentElement();
                String rootName = root.getNodeName();
                if (rootName.equals(ELEMENT_NAME)) {
                    String id = "";
                    String name = "";
                    Node text = root.getFirstChild();
                    while (text != null) {
                        if (text != null && text.getNodeName() != null && text.getNodeName().equals(TAG_LANG)) {
                            Node nId = text.getAttributes().getNamedItem(ATTR_ID);
                            Node nName = text.getAttributes().getNamedItem(ATTR_NAME);
                            if (nId != null && nName != null) {
                                id = nId.getNodeValue();
                                name = nName.getNodeValue();
                                if (id != null && !id.isEmpty()) {
                                    LanguageData data = new LanguageData(id, name);
                                    this.languageList.add(data);
                                }
                            }
                        }
                        text = text.getNextSibling();
                    }
                    break block32;
                }
                return false;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                return false;
            }
            catch (SAXException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public void clear() {
        if (this.languageList != null) {
            this.languageList.clear();
        }
    }

    public String findId(String name) {
        for (LanguageData item : this.languageList) {
            if (!item.getName().equals(name)) continue;
            return item.getId();
        }
        return "";
    }

    public LanguageData getLanguageData(String id) {
        for (LanguageData l : this.languageList) {
            if (!l.getId().equals(id)) continue;
            return l;
        }
        return null;
    }

    public String findName(String id) {
        for (LanguageData item : this.languageList) {
            if (!item.getId().equals(id)) continue;
            return item.getName();
        }
        return "";
    }
}

