/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.tizen.nativecore.ext.manifest.AppControl;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.misc.editor.AppControlDetail;
import org.tizen.nativecore.misc.editor.ManifestEditor;
import org.tizen.nativecore.misc.editor.Messages;
import org.tizen.nativecore.misc.editor.TizenFormPage;

public class AppControlPage
extends TizenFormPage {
    private FeaturesBlock fBlock = new FeaturesBlock(this);
    private ManifestEditor fEditor = this.getEditor();

    public AppControlPage(FormEditor editor) {
        super(editor, "ApplicationControl", Messages.AppControlPage_label);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(Messages.AppControlPage_label);
        toolkit.decorateFormHeading(form.getForm());
        this.fBlock.createContent(managedForm);
        this.update(this.getEditor().getCoreManifest());
        this.setDirty(false);
    }

    public void update(Manifest coreManifest) {
        if (this.fBlock.fViewer != null) {
            this.fBlock.fViewer.setInput((Object)coreManifest);
        }
    }

    public class FeaturesBlock
    extends MasterDetailsBlock {
        private AppControlPage fPage;
        private TableViewer fViewer;

        public FeaturesBlock(AppControlPage page) {
            this.fPage = page;
        }

        protected void registerPages(DetailsPart detailsPart) {
            detailsPart.setPageLimit(10);
            detailsPart.registerPage(AppControl.class, (IDetailsPage)new AppControlDetail(this.fPage));
        }

        protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
            FormToolkit toolkit = managedForm.getToolkit();
            Section section = toolkit.createSection(parent, 384);
            section.setText(Messages.AppControlPage_label);
            section.setDescription(Messages.AppControlPage_SectionDesc);
            toolkit.createCompositeSeparator((Composite)section);
            section.marginWidth = 10;
            section.marginHeight = 5;
            Composite client = toolkit.createComposite((Composite)section, 64);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 2;
            layout.marginHeight = 2;
            client.setLayout((Layout)layout);
            Table t = toolkit.createTable(client, 65536);
            GridData gd = new GridData(1808);
            gd.heightHint = 20;
            gd.widthHint = 100;
            t.setLayoutData((Object)gd);
            toolkit.paintBordersFor(client);
            Composite compositeButton = new Composite(client, 0);
            layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            compositeButton.setLayout((Layout)layout);
            compositeButton.setLayoutData((Object)new GridData(2));
            final Button btnAdd = toolkit.createButton(compositeButton, Messages.FeaturesPage_add, 8);
            final Button btnRemove = toolkit.createButton(compositeButton, Messages.FeaturesPage_remove, 8);
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection sel;
                    AppControl ac;
                    if (e.widget == btnAdd) {
                        AppControl ac2 = new AppControl();
                        AppControlPage.this.fEditor.getCoreManifest().getDefaultApp().getAppServiceList().add(ac2);
                        FeaturesBlock.this.fViewer.add((Object)ac2);
                        FeaturesBlock.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)ac2), true);
                        FeaturesBlock.this.fPage.setDirty(true);
                    }
                    if (e.widget == btnRemove && (ac = (AppControl)(sel = (IStructuredSelection)FeaturesBlock.this.fViewer.getSelection()).getFirstElement()) != null) {
                        AppControlPage.this.fEditor.getCoreManifest().getDefaultApp().getAppServiceList().remove(ac);
                        FeaturesBlock.this.fViewer.remove((Object)ac);
                        FeaturesBlock.this.fPage.setDirty(true);
                        btnRemove.setEnabled(false);
                    }
                }
            };
            btnAdd.addSelectionListener((SelectionListener)listener);
            btnAdd.setLayoutData((Object)new GridData(768));
            btnRemove.addSelectionListener((SelectionListener)listener);
            btnRemove.setLayoutData((Object)new GridData(768));
            btnRemove.setEnabled(false);
            section.setClient((Control)client);
            final SectionPart spart = new SectionPart(section);
            managedForm.addPart((IFormPart)spart);
            this.fViewer = new TableViewer(t);
            this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    if (sel != null) {
                        btnRemove.setEnabled(true);
                    } else {
                        btnRemove.setEnabled(false);
                    }
                }
            });
            this.fViewer.setContentProvider((IContentProvider)new MasterContentProvider());
            this.fViewer.setLabelProvider((IBaseLabelProvider)new MasterLabelProvider());
            this.fViewer.setSorter((ViewerSorter)new SimpleSorter());
            this.fViewer.setInput((Object)AppControlPage.this.getEditor().getCoreManifest());
        }

        protected void createToolBarActions(IManagedForm managedForm) {
        }

        class MasterContentProvider
        implements IStructuredContentProvider {
            MasterContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Manifest) {
                    Manifest manifest = (Manifest)inputElement;
                    return manifest.getDefaultApp().getAppServiceList().toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        class MasterLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            MasterLabelProvider() {
            }

            public String getColumnText(Object obj, int index) {
                if (obj instanceof AppControl) {
                    return "ApplicationControl";
                }
                return obj.toString();
            }

            public Image getColumnImage(Object obj, int index) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
        }
    }

    private static class SimpleSorter
    extends ViewerSorter {
        private SimpleSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return e1.toString().compareTo(e2.toString());
        }
    }
}

