/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.nativecore.ext.manifest.AppControl;

public class TextEditingSupport
extends EditingSupport {
    private final TableViewer viewer;
    private final CellEditor editor;

    public TextEditingSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.editor = new TextCellEditor((Composite)viewer.getTable());
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        AppControl appControl = (AppControl)element;
        if (appControl.getAppServiceItems().size() <= 0) {
            return "";
        }
        int k = 0;
        while (k < appControl.getAppServiceItems().size()) {
            if (appControl.getAppServiceItems().get(k).getCategory().equals((Object)AppControl.CATEGORIES.uri) && appControl.getAppServiceItems().get(k).getValue() != null) {
                return appControl.getAppServiceItems().get(k).getValue();
            }
            ++k;
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        boolean updated = false;
        AppControl appControl = (AppControl)element;
        if (appControl.getAppServiceItems().size() <= 0) {
            AppControl.AppControlItem item = new AppControl().new AppControl.AppControlItem();
            item.setValue(String.valueOf(value));
            item.setCategory(AppControl.CATEGORIES.uri);
            appControl.addAppServiceItems(item);
        } else {
            int k = 0;
            while (k < appControl.getAppServiceItems().size()) {
                if (appControl.getAppServiceItems().get(k).getCategory().equals((Object)AppControl.CATEGORIES.uri) && appControl.getAppServiceItems().get(k).getValue() != null) {
                    appControl.getAppServiceItems().get(k).setValue(String.valueOf(value));
                    updated = true;
                }
                ++k;
            }
            if (!updated) {
                AppControl.AppControlItem item = new AppControl().new AppControl.AppControlItem();
                item.setValue(String.valueOf(value));
                item.setCategory(AppControl.CATEGORIES.uri);
                appControl.addAppServiceItems(item);
            }
        }
        this.viewer.update(element, null);
    }
}

