/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.manifest.Privilege;
import org.tizen.nativecore.ext.manifest.ProviderPrivilege;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.core.IPrivilegeListChangeListener;
import org.tizen.nativecore.misc.core.PrivilegeLevel;
import org.tizen.nativecore.misc.core.PrivilegeManager;
import org.tizen.nativecore.misc.editor.Messages;
import org.tizen.nativecore.misc.editor.SectionHelper;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrivilegePage
extends TizenFormPage
implements SelectionListener {
    private TableViewer fViewer;
    private String imagePath;
    private FormToolkit toolkit;
    private PrivilegeManager privilegeManager;
    private ArrayList<IPrivilegeListChangeListener> fPrivilegeListeners = new ArrayList();
    private Button fBtnAdd;
    private Button fBtnRemove;
    private Table privilegeListTable;
    private String privTypeText = new String("Provider");
    private Boolean isLicenseSelected = new Boolean(false);
    private String licensePath = new String("");
    private String privilegeText = new String("");
    private String fBtnAddEnabled;
    private String fBtnRemoveEnabled;
    private static final String E_ENTRY = "entry";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_LEVEL = "level";
    private static final String ATTR_DESC = "desc";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{"*.xml"};

    public PrivilegePage(FormEditor editor) {
        super(editor, Messages.PrivilegePage_title, Messages.PrivilegePage_title);
        IProject project = null;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            project = file.getProject();
        }
        this.privilegeManager = new PrivilegeManager(project);
    }

    public void resetAppDefPrivilVars() {
        this.privTypeText = "Provider";
        this.isLicenseSelected = false;
        this.licensePath = "";
        this.privilegeText = "";
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit tk;
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        ScrolledForm scrolledForm = managedForm.getForm();
        this.toolkit = tk = managedForm.getToolkit();
        Composite body = scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout());
        this.imagePath = IdePlugin.getDefault().getResourceLocationURL("icons/editor/title_privileges.png").getFile();
        Composite client = SectionHelper.createHeaderSection(tk, body, Messages.PrivilegePage_title, this.imagePath, Messages.PrivilegePage_title, Messages.PrivilegePage_sdesc);
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalAlignment = 3;
        buttonGridData.grabExcessHorizontalSpace = true;
        Composite buttonsComposite = tk.createComposite(client);
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        buttonsComposite.setLayoutData((Object)buttonGridData);
        this.fBtnAdd = new Button(buttonsComposite, 0x2000000);
        this.fBtnAddEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_add_over.png").getFile();
        this.fBtnAdd.setBackgroundImage(new Image(null, new ImageData(this.fBtnAddEnabled)));
        this.fBtnAdd.addSelectionListener((SelectionListener)this);
        this.fBtnRemove = new Button(buttonsComposite, 0x2000000);
        this.fBtnRemoveEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_delete_over.png").getFile();
        this.fBtnRemove.setBackgroundImage(new Image(null, new ImageData(this.fBtnRemoveEnabled)));
        this.fBtnRemove.addSelectionListener((SelectionListener)this);
        this.fBtnRemove.setEnabled(false);
        this.fViewer = new TableViewer(client, 68354);
        Table table = this.fViewer.getTable();
        table.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        table.setLayoutData((Object)gd);
        TableViewerColumn nameColumn = new TableViewerColumn(this.fViewer, 0);
        nameColumn.getColumn().setText("Name");
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        this.fViewer.getTable().setLayout((Layout)tableLayout);
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Manifest) {
                    Manifest model = (Manifest)inputElement;
                    ArrayList<String> elements = new ArrayList<String>();
                    elements.addAll(model.getPrivilege_map().keySet());
                    for (Privilege privilege : model.getConsumerPrivilege_map().values()) {
                        elements.add(privilege.getDescription());
                    }
                    for (ProviderPrivilege providerPrivilege : model.getProviderPrivilege_map().values()) {
                        elements.add(providerPrivilege.getDescription());
                    }
                    return elements.toArray();
                }
                return null;
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.fViewer.setInput((Object)this.getEditor().getCoreManifest());
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel != null) {
                    PrivilegePage.this.fBtnRemove.setEnabled(true);
                } else {
                    PrivilegePage.this.fBtnRemove.setEnabled(false);
                }
            }
        });
        this.update(this.getEditor().getCoreManifest());
        this.setDirty(false);
    }

    public void update(Manifest model) {
        if (this.fViewer != null) {
            this.fViewer.setInput((Object)model);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fBtnAdd) {
            AddCustomPrivilegeDialog dialog = new AddCustomPrivilegeDialog(this.toolkit, this);
            if (dialog.open() == 0) {
                RESPONSE_KIND kind = dialog.getResultKind();
                switch (kind) {
                    case PRIVILEGE_INTERNAL: {
                        ArrayList<String> prevs = dialog.getSelectedPrivileges();
                        if (prevs.isEmpty()) break;
                        for (String privilege : prevs) {
                            this.getEditor().getCoreManifest().addPrivilege(privilege);
                            this.fViewer.add((Object)privilege);
                            this.setDirty(true);
                        }
                        break;
                    }
                    case PRIVILEGE_NAME: {
                        String privilegeName = dialog.getPrivilegeName();
                        this.getEditor().getCoreManifest().addPrivilege(privilegeName, PrivilegeLevel.PUBLIC, "");
                        this.fViewer.add((Object)privilegeName);
                        this.setDirty(true);
                        break;
                    }
                    case PRIVILEGE_FILE: {
                        File privilegeFile = dialog.getPrivilegeFile();
                        try {
                            this.importExternalFile(privilegeFile);
                            this.setDirty(true);
                        }
                        catch (CoreException ex) {
                            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)Messages.AddPrivilege_file_error, (IStatus)ex.getStatus());
                        }
                        catch (Exception exception) {
                            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)Messages.AddPrivilege_file_error, (IStatus)new Status(4, "org.tizen.nativecommon", Messages.AddPrivilege_invalid_file));
                        }
                        break;
                    }
                    case PRIVILEGE_APPDEFINED: {
                        String privilegeName = "[App-defined-";
                        this.privilegeText = this.privilegeText.trim();
                        if (this.isLicenseSelected.booleanValue()) {
                            if (this.licensePath == null) {
                                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)Messages.AddAppPrivilege_license_error, (IStatus)new Status(4, "org.tizen.nativecommon", Messages.AddPrivilege_invalid_file));
                                return;
                            }
                            this.licensePath = this.licensePath.trim();
                        }
                        if (this.isLicenseSelected.booleanValue() && this.licensePath.isEmpty()) {
                            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)Messages.AddAppPrivilege_license_error, (IStatus)new Status(4, "org.tizen.nativecommon", Messages.AddPrivilege_invalid_file));
                            return;
                        }
                        if (!this.isValidAppDefinedPrivilege()) {
                            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)Messages.AddAppPrivilege_format_error, (IStatus)new Status(4, "org.tizen.nativecommon", Messages.AddPrivilege_invalid_format));
                            this.resetAppDefPrivilVars();
                            return;
                        }
                        if (this.isLicenseSelected.booleanValue()) {
                            this.privilegeManager.copyLicenseFile(this.licensePath);
                        }
                        String type = this.privTypeText;
                        privilegeName = String.valueOf(privilegeName) + type.toLowerCase() + "]";
                        privilegeName = String.valueOf(privilegeName) + this.privilegeText;
                        String licenseFile = this.licensePath;
                        if (this.licensePath.lastIndexOf(File.separator) != -1) {
                            licenseFile = this.licensePath.substring(this.licensePath.lastIndexOf(File.separator) + 1);
                        }
                        if (type.equals("Consumer")) {
                            this.getEditor().getCoreManifest().addConsumerPrivilege(this.privilegeText, licenseFile);
                        } else {
                            this.getEditor().getCoreManifest().addProviderPrivilege(this.privilegeText, licenseFile);
                        }
                        this.fViewer.add((Object)privilegeName);
                        this.setDirty(true);
                        this.resetAppDefPrivilVars();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            return;
        }
        if (e.widget == this.fBtnRemove) {
            Object[] selected;
            IStructuredSelection sel = (IStructuredSelection)this.fViewer.getSelection();
            Object[] objectArray = selected = sel.toArray();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                String selPriv = (String)object;
                Manifest mF = this.getEditor().getCoreManifest();
                if (mF.hasPrivilege(selPriv)) {
                    mF.removePrivilege(selPriv);
                } else {
                    String rmPriv;
                    String consumer_prefix = new String("[App-defined-consumer]");
                    String provider_prefix = new String("[App-defined-provider]");
                    if (selPriv.startsWith(consumer_prefix)) {
                        rmPriv = selPriv.substring(consumer_prefix.length()).trim();
                        if (mF.hasConsumerPrivilege(rmPriv)) {
                            mF.removeConsumerPrivilege(rmPriv);
                        }
                    } else if (selPriv.startsWith(provider_prefix) && mF.hasProviderPrivilege(rmPriv = selPriv.substring(provider_prefix.length()).trim())) {
                        mF.removeProviderPrivilege(rmPriv);
                    }
                }
                this.fViewer.remove((Object)selPriv);
                this.fBtnRemove.setEnabled(false);
                this.setDirty(true);
                ++n2;
            }
        }
    }

    private boolean isValidAppDefinedPrivilege() {
        String pkgId = this.getEditor().getCoreManifest().getPackageId();
        String templateStr = "http://" + pkgId + "/appdefined/";
        return this.privilegeText.startsWith(templateStr);
    }

    private void importExternalFile(File privilegeFile) throws CoreException, Exception {
        FileInputStream fileInputStream = null;
        ArrayList<String> privileges = new ArrayList<String>();
        try {
            try {
                fileInputStream = new FileInputStream(privilegeFile);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(fileInputStream);
                NodeList nodes = dom.getElementsByTagName(E_ENTRY);
                int i = 0;
                while (i < nodes.getLength()) {
                    Node node = nodes.item(i);
                    if (node instanceof Element) {
                        Element e = (Element)node;
                        Privilege priv = null;
                        String key = e.getAttribute(ATTR_KEY);
                        if (!StringUtil.isEmpty((CharSequence)key)) {
                            String desc;
                            PrivilegeLevel l;
                            priv = new Privilege(key);
                            String v = e.getAttribute(ATTR_LEVEL);
                            if (v.length() > 0 && (l = PrivilegeLevel.getEnumByName(v)) != null) {
                                priv.setLevel(l);
                            }
                            if ((desc = e.getAttribute(ATTR_DESC)) != null) {
                                priv.setDescription(desc);
                            }
                            if (ValidationUtil.checkForIRI((String)key)) {
                                if (!this.getEditor().getCoreManifest().hasPrivilege(key)) {
                                    privileges.add(key);
                                }
                            } else {
                                throw new CoreException((IStatus)new Status(4, "org.tizen.nativecommon", Messages.AddPrivilege_invalid_file));
                            }
                        }
                    }
                    ++i;
                }
                for (String priv : privileges) {
                    this.getEditor().getCoreManifest().addPrivilege(priv);
                    this.fViewer.add((Object)priv);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public PrivilegeManager getPrivilegeManager() {
        return this.privilegeManager;
    }

    public void addPrivilegeListChangeListener(IPrivilegeListChangeListener l) {
        this.fPrivilegeListeners.add(l);
    }

    public void firePrivilegeAdded(String privilegeName) {
        for (IPrivilegeListChangeListener listener : this.fPrivilegeListeners) {
            listener.privilegeAdded(privilegeName);
        }
    }

    public void removePrivilegeListChangeListener(IPrivilegeListChangeListener l) {
        this.fPrivilegeListeners.remove(l);
    }

    public void firePrivilegeRemoved(String privilegeName) {
        for (IPrivilegeListChangeListener listener : this.fPrivilegeListeners) {
            listener.privilegeRemoved(privilegeName);
        }
    }

    public class AddCustomPrivilegeDialog
    extends SelectionStatusDialog {
        protected FormToolkit toolkit;
        protected TizenFormPage fpage;
        protected String privilegeName;
        protected String privilegeFilePath;
        protected ArrayList<String> selectedPrivileges;
        private RESPONSE_KIND selection;
        private String[] availablePrivileges;
        private Button internalRadioButton;
        private Text filterText;
        private Text DescriptionText;
        private Button privilegeNameRadio;
        private Text privilegeNameText;
        private Button fileRadioButton;
        private Button appDefRadioButton;
        private Text filePathText;
        private Button fileBrowseButton;
        private Combo privTypeCombo;
        private Button licenseCheckBox;
        private Combo licenseCombo;
        private Text appDefPrivilegeText;
        private String[] privilegeProvider;
        private int majorVersion;

        public AddCustomPrivilegeDialog(FormToolkit tk, TizenFormPage page) {
            super(Display.getDefault().getActiveShell());
            this.privilegeProvider = new String[]{"Provider", "Consumer"};
            this.toolkit = tk;
            this.fpage = page;
            this.setTitle(Messages.AddPrivilege_title);
        }

        public ArrayList<String> getSelectedPrivileges() {
            return this.selectedPrivileges;
        }

        public void setSelectedPrivileges(ArrayList<String> selectedPrivileges) {
            this.selectedPrivileges = selectedPrivileges;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginTop = 20;
            layout.marginBottom = 9;
            layout.marginLeft = 20;
            layout.marginRight = 20;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            composite.setBackground(new Color(null, 255, 255, 255));
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 800;
            composite.setLayoutData((Object)gd);
            this.internalRadioButton = new Button(composite, 16);
            GridData internalRadioButtonGridData = new GridData();
            internalRadioButtonGridData.widthHint = 200;
            this.internalRadioButton.setBackground(new Color(null, 255, 255, 255));
            this.internalRadioButton.setLayoutData((Object)internalRadioButtonGridData);
            this.internalRadioButton.setText(Messages.AddPrivilege_internal);
            this.filterText = new Text(composite, 2048);
            GridData filterTextGridData = new GridData();
            filterTextGridData.widthHint = 320;
            filterTextGridData.grabExcessHorizontalSpace = true;
            filterTextGridData.horizontalAlignment = 4;
            this.filterText.setBackground(new Color(null, 255, 255, 255));
            this.filterText.setLayoutData((Object)filterTextGridData);
            new Label(composite, 0);
            GridData data = new GridData();
            data.widthHint = 320;
            data.heightHint = 134;
            data.grabExcessVerticalSpace = true;
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            PrivilegePage.this.privilegeListTable = new Table(composite, 2592);
            PrivilegePage.this.privilegeListTable.setLayoutData((Object)data);
            new Label(composite, 0);
            Label descriprion = new Label(composite, 1);
            descriprion.setLayoutData((Object)new GridData());
            descriprion.setBackground(new Color(null, 255, 255, 255));
            descriprion.setText(Messages.AddPrivilege_privilege_description);
            new Label(composite, 0);
            GridData descriptionGridData = new GridData();
            descriptionGridData.widthHint = 320;
            descriptionGridData.heightHint = 55;
            descriptionGridData.grabExcessVerticalSpace = true;
            descriptionGridData.grabExcessHorizontalSpace = true;
            descriptionGridData.horizontalAlignment = 4;
            descriptionGridData.verticalAlignment = 4;
            this.DescriptionText = new Text(composite, 2634);
            this.DescriptionText.setBackground(new Color(null, 255, 255, 255));
            this.DescriptionText.setLayoutData((Object)descriptionGridData);
            this.privilegeNameRadio = new Button(composite, 16);
            GridData privilegeNameRadioGridData = new GridData();
            privilegeNameRadioGridData.widthHint = 200;
            this.privilegeNameRadio.setLayoutData((Object)privilegeNameRadioGridData);
            this.privilegeNameRadio.setBackground(new Color(null, 255, 255, 255));
            this.privilegeNameRadio.setText(Messages.AddPrivilege_custom_privileges);
            this.privilegeNameText = new Text(composite, 2048);
            GridData privilegeNameTextGridData = new GridData();
            privilegeNameTextGridData.widthHint = 320;
            privilegeNameTextGridData.grabExcessHorizontalSpace = true;
            privilegeNameTextGridData.horizontalAlignment = 4;
            this.privilegeNameText.setBackground(new Color(null, 255, 255, 255));
            this.privilegeNameText.setLayoutData((Object)privilegeNameTextGridData);
            this.fileRadioButton = new Button(composite, 16);
            GridData fileRadioButtonGridData = new GridData();
            fileRadioButtonGridData.widthHint = 150;
            this.fileRadioButton.setBackground(new Color(null, 255, 255, 255));
            this.fileRadioButton.setLayoutData((Object)fileRadioButtonGridData);
            this.fileRadioButton.setText(Messages.AddPrivilege_file);
            Composite fileComposite = new Composite(composite, 0);
            GridLayout grid = new GridLayout(2, false);
            grid.marginHeight = 0;
            grid.marginWidth = 0;
            grid.horizontalSpacing = 20;
            grid.verticalSpacing = 0;
            fileComposite.setLayout((Layout)grid);
            GridData fileCompositeGridData = new GridData();
            fileCompositeGridData.widthHint = 320;
            fileCompositeGridData.grabExcessHorizontalSpace = true;
            fileCompositeGridData.horizontalAlignment = 4;
            fileComposite.setBackground(new Color(null, 255, 255, 255));
            fileComposite.setLayoutData((Object)fileCompositeGridData);
            this.filePathText = new Text(fileComposite, 2056);
            GridData filePathTextGridData = new GridData(1, 0, true, false);
            filePathTextGridData.widthHint = 220;
            filePathTextGridData.grabExcessHorizontalSpace = true;
            filePathTextGridData.horizontalAlignment = 4;
            this.filePathText.setBackground(new Color(null, 255, 255, 255));
            this.filePathText.setLayoutData((Object)filePathTextGridData);
            this.fileBrowseButton = new Button(fileComposite, 8);
            this.fileBrowseButton.setText(org.tizen.common.Messages.BrowserButtonLabel);
            this.fileBrowseButton.setBackground(new Color(null, 255, 255, 255));
            this.fileBrowseButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PrivilegePage.this.privilegeListTable.removeAll();
                    String strfilter = AddCustomPrivilegeDialog.this.filterText.getText().trim();
                    if (strfilter.isEmpty()) {
                        int i = 0;
                        while (i < AddCustomPrivilegeDialog.this.availablePrivileges.length) {
                            TableItem item = new TableItem(PrivilegePage.this.privilegeListTable, 0);
                            item.setText(AddCustomPrivilegeDialog.this.availablePrivileges[i]);
                            ++i;
                        }
                        return;
                    }
                    String[] stringArray = AddCustomPrivilegeDialog.this.availablePrivileges;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String privilegeName = stringArray[n2];
                        if (privilegeName.contains(strfilter)) {
                            TableItem item = new TableItem(PrivilegePage.this.privilegeListTable, 0);
                            item.setText(privilegeName);
                        }
                        ++n2;
                    }
                }
            });
            String apiVersion = this.fpage.getEditor().getCoreManifest().getApiVersion();
            int seperator = apiVersion.indexOf(46);
            apiVersion = apiVersion.substring(0, seperator == -1 ? apiVersion.length() : seperator);
            this.majorVersion = Integer.parseInt(apiVersion);
            if (this.majorVersion >= 4) {
                this.appDefRadioButton = new Button(composite, 16);
                GridData appDefRadioButtonGridData = new GridData();
                appDefRadioButtonGridData.widthHint = 200;
                this.appDefRadioButton.setBackground(new Color(null, 255, 255, 255));
                this.appDefRadioButton.setLayoutData((Object)appDefRadioButtonGridData);
                this.appDefRadioButton.setText(Messages.AddPrivilege_AppDefined);
                grid = new GridLayout(3, false);
                grid.marginHeight = 0;
                grid.marginWidth = 0;
                grid.horizontalSpacing = 20;
                grid.verticalSpacing = 20;
                Composite appPrivComposite = new Composite(composite, 0);
                appPrivComposite.setLayout((Layout)grid);
                GridData appPrivGridData = new GridData();
                appPrivGridData.widthHint = 320;
                appPrivGridData.grabExcessHorizontalSpace = true;
                appPrivGridData.horizontalAlignment = 4;
                appPrivComposite.setBackground(new Color(null, 255, 255, 255));
                appPrivComposite.setLayoutData((Object)appPrivGridData);
                this.privTypeCombo = new Combo(appPrivComposite, 2056);
                String[] stringArray = this.privilegeProvider;
                int n = this.privilegeProvider.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.privTypeCombo.add(s);
                    ++n2;
                }
                this.privTypeCombo.setText(this.privilegeProvider[0]);
                GridData privProdiverGridData = new GridData(1, 0, true, false);
                privProdiverGridData.widthHint = 100;
                privProdiverGridData.grabExcessHorizontalSpace = true;
                privProdiverGridData.horizontalAlignment = 4;
                this.privTypeCombo.setLayoutData((Object)privProdiverGridData);
                this.privTypeCombo.setBackground(new Color(null, 255, 255, 255));
                this.privTypeCombo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        Combo privTypeCombo = (Combo)event.getSource();
                        PrivilegePage.this.privTypeText = privTypeCombo.getText();
                    }
                });
                this.licenseCheckBox = new Button(appPrivComposite, 32);
                this.licenseCheckBox.setText("License");
                this.licenseCheckBox.setBackground(new Color(null, 255, 255, 255));
                this.licenseCheckBox.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        Button btn = (Button)event.getSource();
                        PrivilegePage.this.isLicenseSelected = btn.getSelection();
                        AddCustomPrivilegeDialog.this.licenseCombo.setEnabled(PrivilegePage.this.isLicenseSelected.booleanValue());
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                        this.widgetSelected(event);
                    }
                });
                this.licenseCheckBox.setSelection(false);
                this.licenseCombo = new Combo(appPrivComposite, 2316);
                this.licenseCombo.setLayoutData((Object)privProdiverGridData);
                this.licenseCombo.setBackground(new Color(null, 255, 255, 255));
                String[] items = new String[]{"New License..."};
                this.licenseCombo.setItems(items);
                this.licenseCombo.select(0);
                this.licenseCombo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        FileDialog dialog = new FileDialog(AddCustomPrivilegeDialog.this.licenseCombo.getShell());
                        dialog.setText(Messages.AddPrivilege_license_header);
                        String resultLocation = dialog.open();
                        PrivilegePage.this.licensePath = resultLocation;
                        if (resultLocation != null) {
                            String fileName = resultLocation.substring(resultLocation.lastIndexOf(File.separator) + 1);
                            AddCustomPrivilegeDialog.this.licenseCombo.setText(fileName);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                GridData privTextGridData = new GridData();
                privTextGridData.horizontalSpan = 3;
                privTextGridData.grabExcessHorizontalSpace = true;
                privTextGridData.horizontalAlignment = 4;
                this.appDefPrivilegeText = new Text(appPrivComposite, 2048);
                this.appDefPrivilegeText.setLayoutData((Object)privTextGridData);
                this.appDefPrivilegeText.setBackground(new Color(null, 255, 255, 255));
                this.appDefPrivilegeText.setMessage(Messages.AddPrivilege_AppDefined_hint);
                this.appDefPrivilegeText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        Text privText = (Text)event.getSource();
                        PrivilegePage.this.privilegeText = privText.getText();
                    }
                });
                this.appDefRadioButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        AddCustomPrivilegeDialog.this.changeSelection(RESPONSE_KIND.PRIVILEGE_APPDEFINED);
                        AddCustomPrivilegeDialog.this.getButton(0).setEnabled(true);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
            }
            this.internalRadioButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddCustomPrivilegeDialog.this.changeSelection(RESPONSE_KIND.PRIVILEGE_INTERNAL);
                    AddCustomPrivilegeDialog.this.getButton(0).setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            String[] allPrivs = null;
            allPrivs = PrivilegePage.this.privilegeManager.getAvailablePrivileges();
            ArrayList<String> filtered = new ArrayList<String>(allPrivs.length);
            String[] stringArray = allPrivs;
            int n = allPrivs.length;
            int privProdiverGridData = 0;
            while (privProdiverGridData < n) {
                String p = stringArray[privProdiverGridData];
                if (!PrivilegePage.this.getEditor().getCoreManifest().hasPrivilege(p)) {
                    filtered.add(p);
                }
                ++privProdiverGridData;
            }
            if (!filtered.isEmpty()) {
                this.availablePrivileges = filtered.toArray(new String[filtered.size()]);
                Arrays.sort(this.availablePrivileges, 0, this.availablePrivileges.length, String.CASE_INSENSITIVE_ORDER);
                int i = 0;
                while (i < this.availablePrivileges.length) {
                    TableItem item = new TableItem(PrivilegePage.this.privilegeListTable, 0);
                    item.setText(this.availablePrivileges[i]);
                    ++i;
                }
                this.internalRadioButton.setSelection(true);
                this.changeSelection(RESPONSE_KIND.PRIVILEGE_INTERNAL);
            } else {
                this.filterText.setEnabled(false);
                this.internalRadioButton.setEnabled(false);
                PrivilegePage.this.privilegeListTable.setEnabled(false);
                this.privilegeNameRadio.setSelection(true);
                this.changeSelection(RESPONSE_KIND.PRIVILEGE_NAME);
            }
            PrivilegePage.this.privilegeListTable.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String privilege = (String)e.item.toString().subSequence(11, e.item.toString().length() - 1);
                    String description = PrivilegePage.this.privilegeManager.getDescription(privilege);
                    if (description == null) {
                        AddCustomPrivilegeDialog.this.DescriptionText.setText(String.valueOf(PrivilegePage.this.privilegeManager.getPrivilegeLevel(privilege).getName()) + " " + Messages.AddPrivilege_level_label);
                    } else {
                        AddCustomPrivilegeDialog.this.DescriptionText.setText(String.valueOf(PrivilegePage.this.privilegeManager.getPrivilegeLevel(privilege).getName()) + " " + Messages.AddPrivilege_level_label + " " + description);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.privilegeNameRadio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String url = AddCustomPrivilegeDialog.this.privilegeNameText.getText().trim();
                    String key = "wrong URI";
                    IMessageManager manager = AddCustomPrivilegeDialog.this.fpage.getManagedForm().getMessageManager();
                    if (!StringUtil.isEmpty((CharSequence)url) && !ValidationUtil.checkForURL((String)url)) {
                        manager.addMessage((Object)key, Messages.AddPrivilege_custom_privileges_error, null, 3, (Control)AddCustomPrivilegeDialog.this.privilegeNameText);
                        AddCustomPrivilegeDialog.this.getButton(0).setEnabled(false);
                    }
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    AddCustomPrivilegeDialog.this.changeSelection(RESPONSE_KIND.PRIVILEGE_NAME);
                }
            });
            this.privilegeNameText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    e.doit = !Character.isWhitespace(e.character);
                }
            });
            this.privilegeNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String url = AddCustomPrivilegeDialog.this.privilegeNameText.getText().trim();
                    String key = "wrong URI";
                    IMessageManager manager = AddCustomPrivilegeDialog.this.fpage.getManagedForm().getMessageManager();
                    if (!StringUtil.isEmpty((CharSequence)url) && !ValidationUtil.checkForURL((String)url)) {
                        manager.addMessage((Object)key, Messages.AddPrivilege_custom_privileges_error, null, 3, (Control)AddCustomPrivilegeDialog.this.privilegeNameText);
                        AddCustomPrivilegeDialog.this.getButton(0).setEnabled(false);
                    } else {
                        manager.removeMessage((Object)key, (Control)AddCustomPrivilegeDialog.this.privilegeNameText);
                        AddCustomPrivilegeDialog.this.getButton(0).setEnabled(true);
                    }
                }
            });
            this.fileRadioButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                    AddCustomPrivilegeDialog.this.getButton(0).setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    AddCustomPrivilegeDialog.this.changeSelection(RESPONSE_KIND.PRIVILEGE_FILE);
                }
            });
            this.fileBrowseButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    AddCustomPrivilegeDialog.this.browseFiles();
                }
            });
            return composite;
        }

        protected void computeResult() {
            TableItem[] privilegeNames;
            this.selectedPrivileges = new ArrayList();
            TableItem[] tableItemArray = privilegeNames = PrivilegePage.this.privilegeListTable.getItems();
            int n = privilegeNames.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    this.selectedPrivileges.add(item.getText());
                }
                ++n2;
            }
            this.privilegeName = new String();
            this.privilegeName = this.privilegeNameText.getText();
            this.privilegeFilePath = new String();
            this.privilegeFilePath = this.filePathText.getText();
        }

        private void changeSelection(RESPONSE_KIND kind) {
            this.selection = kind;
            this.filterText.setEnabled(RESPONSE_KIND.PRIVILEGE_INTERNAL == this.selection);
            PrivilegePage.this.privilegeListTable.setEnabled(RESPONSE_KIND.PRIVILEGE_INTERNAL == this.selection);
            this.privilegeNameText.setEnabled(RESPONSE_KIND.PRIVILEGE_NAME == this.selection);
            this.filePathText.setEnabled(RESPONSE_KIND.PRIVILEGE_FILE == this.selection);
            this.fileBrowseButton.setEnabled(RESPONSE_KIND.PRIVILEGE_FILE == this.selection);
            if (this.majorVersion >= 4) {
                this.privTypeCombo.setEnabled(RESPONSE_KIND.PRIVILEGE_APPDEFINED == this.selection);
                this.licenseCheckBox.setEnabled(RESPONSE_KIND.PRIVILEGE_APPDEFINED == this.selection);
                this.licenseCombo.setEnabled(RESPONSE_KIND.PRIVILEGE_APPDEFINED == this.selection && this.licenseCheckBox.getSelection());
                this.appDefPrivilegeText.setEnabled(RESPONSE_KIND.PRIVILEGE_APPDEFINED == this.selection);
            }
        }

        private void browseFiles() {
            FileDialog dialog = new FileDialog(this.filePathText.getShell());
            dialog.setFilterExtensions(ACCEPTED_EXTENSIONS);
            dialog.setText(Messages.AddPrivilege_file_header);
            String fileName = this.filePathText.getText();
            if (!fileName.isEmpty()) {
                dialog.setFilterPath(fileName);
            } else {
                dialog.setFilterPath(null);
            }
            String resultLocation = dialog.open();
            if (resultLocation != null) {
                this.filePathText.setText(resultLocation);
            }
        }

        public RESPONSE_KIND getResultKind() {
            return this.selection;
        }

        public String getPrivilegeName() {
            return this.privilegeName;
        }

        public TableItem[] getInternalPrivilegeNames() {
            return PrivilegePage.this.privilegeListTable.getItems();
        }

        public File getPrivilegeFile() {
            return new File(this.getPrivilegeFilePath());
        }

        public String getPrivilegeFilePath() {
            return this.privilegeFilePath;
        }

        public void setPrivilegeFilePath(String privilegeFilePath) {
            this.privilegeFilePath = privilegeFilePath;
        }
    }

    public static enum RESPONSE_KIND {
        PRIVILEGE_NAME,
        PRIVILEGE_FILE,
        PRIVILEGE_INTERNAL,
        PRIVILEGE_APPDEFINED;

    }
}

