/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.tizen.nativecore.ext.xmlstore.CoreXMLStore;
import org.tizen.nativecore.misc.utils.CheckerUtil;
import org.xml.sax.SAXException;

public class ManifestStartup
implements IStartup {
    IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(final IResourceChangeEvent event) {
            if (event.getResource() instanceof IProject) {
                WorkspaceJob job = new WorkspaceJob("Build Info Update"){

                    public IStatus runInWorkspace(IProgressMonitor arg0) throws CoreException {
                        CoreXMLStore coreXmlManager;
                        File manifestFile;
                        IProject project = event.getResource().getProject();
                        if (project != null && (manifestFile = new File(project.getLocation().toFile().getAbsolutePath(), "tizen-manifest.xml")).exists() && (coreXmlManager = new CoreXMLStore(project)).loadXml(manifestFile)) {
                            IConfiguration configuration;
                            String entryCDT;
                            try {
                                CheckerUtil.runChecker(project, null, coreXmlManager.getApiVersion());
                            }
                            catch (ParserConfigurationException e) {
                                e.printStackTrace();
                            }
                            catch (SAXException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            String entry = coreXmlManager.getCoreManifest().getDefaultApp().getExec();
                            IManagedBuildInfo mbi = ManagedBuildManager.getBuildInfo((IResource)project);
                            if (mbi != null && !entry.equals(entryCDT = (configuration = mbi.getDefaultConfiguration()).getArtifactName())) {
                                configuration.setArtifactName(entry);
                                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    };

    public void earlyStartup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener, 32);
    }
}

