/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tizen.nativecore.ext.manifest.AppControl;
import org.tizen.nativecore.ext.manifest.BackgroundCategory;
import org.tizen.nativecore.ext.manifest.Category;
import org.tizen.nativecore.ext.manifest.DataControl;
import org.tizen.nativecore.ext.manifest.FrameComponent;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Label;
import org.tizen.nativecore.ext.manifest.Metadata;
import org.tizen.nativecore.ext.manifest.ServiceComponent;
import org.tizen.nativecore.ext.manifest.TizenSplashScreen;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.utils.CheckerUtil;
import org.tizen.nativecore.misc.utils.Constants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComponentBasedApplication
implements IApplication {
    private String appID;
    private String exec;
    private String type;
    private String noDisplay;
    private String multiple;
    private String apiVersion;
    private Label defaultLabel;
    private Icon defaultIcon;
    private List<Metadata> metadataList;
    private List<BackgroundCategory> bgCategoryList;
    private String hwAcceleration;
    private List<DataControl> datacontrolList;
    private String splashScreenDisplay;
    private List<AppControl> appServiceList;
    private Map<String, Category> category_map = new HashMap<String, Category>();
    private List<TizenSplashScreen> splash_list = new ArrayList<TizenSplashScreen>();
    private List<FrameComponent> frameComponentList = new ArrayList<FrameComponent>();
    private List<ServiceComponent> serviceComponentList = new ArrayList<ServiceComponent>();
    private List<LocaledValue> label_list = new ArrayList<LocaledValue>();
    private List<LocaledValue> icon_list = new ArrayList<LocaledValue>();

    @Override
    public void loadElement(Element element) {
        this.appID = element.getAttribute("appid");
        this.exec = element.getAttribute("exec");
        this.type = element.getAttribute("type");
        this.noDisplay = element.getAttribute("nodisplay");
        this.multiple = element.getAttribute("multiple");
        this.apiVersion = element.getAttribute("api-version");
        this.hwAcceleration = element.getAttribute("hw-acceleration");
        this.splashScreenDisplay = element.getAttribute("splash-screen-display");
        Node node = element.getFirstChild();
        while (node != null) {
            String nodeName = node.getNodeName();
            if (nodeName.equals("frame-component")) {
                FrameComponent frameComponent = new FrameComponent();
                frameComponent.loadElement((Element)node);
                this.frameComponentList.add(frameComponent);
            } else if (nodeName.equals("service-component")) {
                ServiceComponent serviceComponent = new ServiceComponent();
                serviceComponent.loadElement((Element)node);
                this.serviceComponentList.add(serviceComponent);
            } else if (nodeName.equals("label")) {
                Label label = new Label();
                label.loadElement((Element)node);
                if (label.getLang() != null && label.getLang().length() > 0) {
                    this.label_list.add(new LocaledValue(label.getLang(), label.getValue()));
                } else {
                    this.defaultLabel = label;
                }
            } else if (nodeName.equals("icon")) {
                Icon icon = new Icon();
                icon.loadElement((Element)node);
                if (icon.getLang() != null && icon.getLang().length() > 0 || icon.getDpi() != null && icon.getDpi().length() > 0) {
                    this.icon_list.add(new LocaledValue(icon.getLang(), icon.getValue(), icon.getDpi()));
                } else {
                    this.defaultIcon = icon;
                }
            } else if (nodeName.equals("app-control")) {
                AppControl application_service = new AppControl();
                application_service.loadElement((Element)node);
                this.getAppServiceList().add(application_service);
            } else if (nodeName.equals("category")) {
                Category category = new Category();
                category.loadElement((Element)node);
                this.getCategory_map().put(category.getName(), category);
            } else if (nodeName.equals("metadata")) {
                Metadata metadata = new Metadata();
                metadata.loadElement((Element)node);
                this.getMetadataList().add(metadata);
            } else if (nodeName.equals("datacontrol")) {
                DataControl datacontrol = new DataControl();
                datacontrol.loadElement((Element)node);
                this.getDataControlList().add(datacontrol);
            } else if (nodeName.equals("background-category")) {
                BackgroundCategory bgCategory = new BackgroundCategory();
                bgCategory.loadElement((Element)node);
                this.getBgCategoryList().add(bgCategory);
            } else if (nodeName.equals("splash-screens")) {
                if (node.getFirstChild() == null) {
                    node.getParentNode().removeChild(node);
                }
                Node childNode = node.getFirstChild();
                while (childNode != null) {
                    String childNodeName = childNode.getNodeName();
                    if (childNodeName.equalsIgnoreCase("splash-screen")) {
                        TizenSplashScreen splashScreen = new TizenSplashScreen();
                        splashScreen.loadElement((Element)childNode);
                        this.getSplashScreenList().add(splashScreen);
                    }
                    childNode = childNode.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
    }

    @Override
    public void generateElement(Document dom, Element parent) {
        Element elementComponent = dom.createElement("component-based-application");
        if (this.appID != null && this.appID.length() > 0) {
            elementComponent.setAttribute("appid", this.appID);
        }
        if (this.exec != null && this.exec.length() > 0) {
            elementComponent.setAttribute("exec", this.exec);
        }
        if (this.noDisplay != null && this.noDisplay.length() > 0 && !this.noDisplay.equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            elementComponent.setAttribute("nodisplay", this.noDisplay);
        }
        if (this.multiple != null && this.multiple.length() > 0 && !this.multiple.equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            elementComponent.setAttribute("multiple", this.multiple);
        }
        if (this.type != null && this.type.length() > 0) {
            elementComponent.setAttribute("type", this.type);
        }
        if (this.apiVersion != null && CheckerUtil.isApplicationAPIVersionSupported(this.apiVersion)) {
            elementComponent.setAttribute("api-version", this.apiVersion);
        }
        if (this.hwAcceleration != null && this.hwAcceleration.length() > 0 && !this.hwAcceleration.equals(Constants.HW_ACCELERATION_VALUES[0])) {
            elementComponent.setAttribute("hw-acceleration", this.hwAcceleration);
        }
        if (this.splashScreenDisplay != null && this.splashScreenDisplay.length() > 0) {
            elementComponent.setAttribute("splash-screen-display", this.splashScreenDisplay);
        }
        this.generateLabels(dom, elementComponent);
        this.generateIcons(dom, elementComponent);
        if (this.appServiceList != null) {
            for (AppControl ac : this.appServiceList) {
                ac.generateElement(dom, elementComponent);
            }
        }
        if (this.getCategory_map().size() > 0) {
            Collection<Category> values = this.getCategory_map().values();
            Iterator<Object> Ir_values = values.iterator();
            while (Ir_values.hasNext()) {
                ((Category)Ir_values.next()).generateElement(dom, elementComponent);
            }
        }
        for (Metadata m : this.getMetadataList()) {
            if (m == null) continue;
            m.generateElement(dom, elementComponent);
        }
        for (DataControl d : this.getDataControlList()) {
            if (d == null) continue;
            d.generateElement(dom, elementComponent);
        }
        for (BackgroundCategory b : this.getBgCategoryList()) {
            if (b == null) continue;
            b.generateElement(dom, elementComponent);
        }
        if (this.splash_list != null && this.splash_list.size() > 0) {
            Element splashElement = dom.createElement("splash-screens");
            elementComponent.appendChild(splashElement);
            int i = 0;
            while (i < this.splash_list.size()) {
                this.splash_list.get(i).generateElement(dom, splashElement);
                ++i;
            }
        }
        if (this.frameComponentList.size() > 0) {
            for (FrameComponent frameComponent : this.frameComponentList) {
                frameComponent.generateElement(dom, elementComponent);
            }
        }
        if (this.serviceComponentList.size() > 0) {
            for (ServiceComponent serviceComponent : this.serviceComponentList) {
                serviceComponent.generateElement(dom, elementComponent);
            }
        }
        parent.appendChild(elementComponent);
    }

    public List<FrameComponent> getFrameComponentList() {
        return this.frameComponentList;
    }

    public List<ServiceComponent> getServiceComponentList() {
        return this.serviceComponentList;
    }

    public void clear() {
        this.frameComponentList.clear();
        this.serviceComponentList.clear();
    }

    public List<DataControl> getDataControlList() {
        if (this.datacontrolList == null) {
            this.datacontrolList = new ArrayList<DataControl>();
        }
        return this.datacontrolList;
    }

    public List<TizenSplashScreen> getSplashScreenList() {
        return this.splash_list;
    }

    private void generateLabels(Document dom, Element parent) {
        List<LocaledValue> labels = this.getLabels();
        if (labels.isEmpty() && this.defaultLabel == null) {
            return;
        }
        if (this.defaultLabel != null) {
            Element eLabel = dom.createElement("label");
            eLabel.setTextContent(this.defaultLabel.getValue());
            parent.appendChild(eLabel);
        }
        for (LocaledValue lv : labels) {
            Element eLabel = dom.createElement("label");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eLabel.setAttribute("xml:lang", lv.getLocale());
            }
            eLabel.setTextContent(lv.getValue());
            parent.appendChild(eLabel);
        }
    }

    private void generateIcons(Document dom, Element parent) {
        List<LocaledValue> icons = this.getIcons();
        if (icons.isEmpty() && this.defaultIcon == null) {
            return;
        }
        if (this.defaultIcon != null) {
            Element eIcon = dom.createElement("icon");
            eIcon.setTextContent(this.defaultIcon.getValue());
            parent.appendChild(eIcon);
        }
        for (LocaledValue lv : icons) {
            Element eIcon = dom.createElement("icon");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eIcon.setAttribute("xml:lang", lv.getLocale());
            }
            if (lv.getDpi() != null && lv.getDpi().length() > 0) {
                eIcon.setAttribute("dpi", lv.getDpi());
            }
            eIcon.setTextContent(lv.getValue());
            parent.appendChild(eIcon);
        }
    }

    @Override
    public List<AppControl> getAppServiceList() {
        if (this.appServiceList == null) {
            this.appServiceList = new ArrayList<AppControl>();
        }
        return this.appServiceList;
    }

    @Override
    public void setAppServiceList(List<AppControl> application_service) {
        this.appServiceList = application_service;
    }

    @Override
    public List<LocaledValue> getLabels() {
        return this.label_list;
    }

    @Override
    public Label getDefaultLabel() {
        return this.defaultLabel;
    }

    @Override
    public void setDefaultLabel(Label label) {
        this.defaultLabel = label;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<Metadata> getMetadataList() {
        if (this.metadataList == null) {
            this.metadataList = new ArrayList<Metadata>();
        }
        return this.metadataList;
    }

    @Override
    public String getExec() {
        return this.exec;
    }

    @Override
    public void setExec(String exec) {
        this.exec = exec;
    }

    @Override
    public String getAppid() {
        return this.appID;
    }

    @Override
    public void setAppid(String appId) {
        this.appID = appId;
    }

    @Override
    public Map<String, Category> getCategory_map() {
        return this.category_map;
    }

    @Override
    public List<LocaledValue> getIcons() {
        return this.icon_list;
    }

    @Override
    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    @Override
    public void setDefaultIcon(Icon icon) {
        this.defaultIcon = icon;
    }

    @Override
    public List<BackgroundCategory> getBgCategoryList() {
        if (this.bgCategoryList == null) {
            this.bgCategoryList = new ArrayList<BackgroundCategory>();
        }
        return this.bgCategoryList;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

