/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.apichecker.inplacechecker;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.tizen.nativecore.apichecker.inplacechecker.APICheckerThread;
import org.tizen.nativecore.apichecker.ui.APCPropertyPage;

public class DocumentChangeListener
implements IDocumentListener {
    public void documentAboutToBeChanged(DocumentEvent arg0) {
    }

    public void documentChanged(DocumentEvent event) {
        String changedText = event.getText();
        if (!(changedText.contains(";") || changedText.contains("\n") || changedText.isEmpty())) {
            return;
        }
        IDocument doc = event.getDocument();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage workbenchPage = window.getActivePage();
        if (workbenchPage == null) {
            return;
        }
        IEditorPart activeEditor = workbenchPage.getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        if (!(activeEditor instanceof ITextEditor)) {
            return;
        }
        ITextEditor ite = (ITextEditor)activeEditor;
        IEditorInput input = ite.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (doc == null || file == null) {
            return;
        }
        IProject project = file.getProject();
        if (!APCPropertyPage.getWithEditOption(project)) {
            return;
        }
        APICheckerThread workerThread = new APICheckerThread(file, doc);
        workerThread.start();
    }
}

