/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.misc.IConstants;
import org.tizen.nativecore.misc.core.LanguageData;
import org.tizen.nativecore.misc.core.LanguageListXmlStore;
import org.tizen.nativecore.misc.editor.SectionHelper;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.dlg.Messages;
import org.tizen.nativecore.misc.internal.ui.wizard.icon.UiNewIconWizard;
import org.tizen.nativecore.misc.utils.Constants;

public class UiNewMultiResolutionIconChooserDialog
extends SelectionStatusDialog {
    private FormToolkit toolkit;
    private TizenFormPage fpage;
    private Icon fIcon;
    private Combo fLanguage;
    private Combo fResolution;
    private List fList;
    private Button fNewBtn;
    private Button fRemoveBtn;
    private IFolder resFolder;
    private Button okButton;
    private String[] resolutions;
    private ArrayList<String> languages;
    private ArrayList<String> deleteList;
    private static String EMPTY = "";
    private static String DEFAULT_STRING = "default";
    IResourceVisitor visitor = new IResourceVisitor(){

        public boolean visit(IResource resource) throws CoreException {
            if (!(resource instanceof IContainer) && resource.getFileExtension().equalsIgnoreCase("png")) {
                Path basePath = new Path(String.valueOf(resource.getProject().getProjectRelativePath().toString()) + IConstants.DIR_SHARED_RES);
                UiNewMultiResolutionIconChooserDialog.this.fList.add(resource.getProjectRelativePath().makeRelativeTo((IPath)basePath).toString());
            }
            return true;
        }
    };
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (event.widget == UiNewMultiResolutionIconChooserDialog.this.fLanguage) {
                UiNewMultiResolutionIconChooserDialog.this.fIcon.setLang(UiNewMultiResolutionIconChooserDialog.this.fLanguage.getText().split(" : ")[0]);
            } else if (event.widget == UiNewMultiResolutionIconChooserDialog.this.fResolution) {
                String res = UiNewMultiResolutionIconChooserDialog.this.fResolution.getText();
                if (res.equalsIgnoreCase(DEFAULT_STRING)) {
                    res = EMPTY;
                }
                UiNewMultiResolutionIconChooserDialog.this.fIcon.setDpi(res);
                IProject project = UiNewMultiResolutionIconChooserDialog.this.fpage.getEditor().getProject();
                UiNewMultiResolutionIconChooserDialog.this.resFolder = project != null ? project.getFolder(IConstants.DIR_SHARED_RES).getFolder(res) : null;
                if (UiNewMultiResolutionIconChooserDialog.this.resFolder != null && !UiNewMultiResolutionIconChooserDialog.this.resFolder.exists()) {
                    try {
                        UiNewMultiResolutionIconChooserDialog.this.resFolder.create(true, true, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                UiNewMultiResolutionIconChooserDialog.this.populateList();
            }
        }
    };

    public UiNewMultiResolutionIconChooserDialog(FormToolkit tk, TizenFormPage page) {
        super(Display.getDefault().getActiveShell());
        this.setTitle(Messages.UiNewMultiResolutionIconChooserDialog_tooltip);
        this.toolkit = tk;
        this.fpage = page;
        this.fIcon = new Icon();
        IProject project = this.fpage.getEditor().getProject();
        if (project != null) {
            this.resFolder = project.getFolder(IConstants.DIR_SHARED_RES);
        }
        Object[] res = new String[]{DEFAULT_STRING};
        this.resolutions = (String[])ArrayUtils.addAll((Object[])res, (Object[])Constants.RESOLUTION_VALUES);
        this.deleteList = new ArrayList();
        ArrayList<LanguageData> languageList = LanguageListXmlStore.getInstance().getLanguageList();
        this.languages = new ArrayList();
        this.languages.add(DEFAULT_STRING);
        for (LanguageData languageData : languageList) {
            this.languages.add(String.valueOf(languageData.getId()) + " : " + languageData.getName());
        }
    }

    public Icon getIcon() {
        return this.fIcon;
    }

    public void setIcon(Icon icon) {
        this.fIcon = icon;
    }

    public ArrayList<String> getDeleteList() {
        return this.deleteList;
    }

    public void setDeleteList(ArrayList<String> deleteList) {
        this.deleteList = deleteList;
    }

    protected void computeResult() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
        if (this.fIcon.getLang().equalsIgnoreCase(EMPTY) && this.fIcon.getDpi().equalsIgnoreCase(EMPTY)) {
            if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.UiNewMultiResolutionIconChooserDialog_confirm_default, (String)Messages.UiNewMultiResolutionIconChooserDialog_default_icon_message)) {
                super.okPressed();
            }
        } else {
            super.okPressed();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        parentComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 510;
        parentComposite.setLayoutData((Object)gd);
        Composite table = SectionHelper.createTableLayout(parentComposite, this.toolkit, 1);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite topRow = SectionHelper.createTableLayout(table, this.toolkit, 2);
        this.fLanguage = SectionHelper.createLabelAndReadOnlyCombo(topRow, this.toolkit, Messages.UiNewMultiResolutionIconChooserDialog_language, this.languages.toArray(new String[0]), Messages.UiNewMultiResolutionIconChooserDialog_locale_tooltip);
        this.fResolution = SectionHelper.createLabelAndReadOnlyCombo(topRow, this.toolkit, Messages.UiNewMultiResolutionIconChooserDialog_resolution, this.resolutions, Messages.UiNewMultiResolutionIconChooserDialog_resolution_tooltip);
        this.fList = new List(table, 2564);
        this.fList.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite bottomRow = SectionHelper.createTableLayout(table, this.toolkit, 2);
        this.fNewBtn = this.toolkit.createButton(bottomRow, Messages.UiNewMultiResolutionIconChooserDialog_new, 8);
        this.fRemoveBtn = this.toolkit.createButton(bottomRow, Messages.UiNewMultiResolutionIconChooserDialog_delete, 8);
        this.init();
        return parentComposite;
    }

    private void init() {
        int i;
        this.fResolution.addModifyListener(this.modifyListener);
        if (this.fIcon.getDpi() != null && this.fIcon.getDpi().length() > 0) {
            i = 1;
            while (i < this.resolutions.length) {
                if (this.resolutions[i].contains(this.fIcon.getDpi())) {
                    this.fResolution.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.fResolution.select(0);
        }
        this.fLanguage.addModifyListener(this.modifyListener);
        if (this.fIcon.getLang() != null && this.fIcon.getLang().length() > 0) {
            i = 0;
            for (String languageData : this.languages) {
                if (languageData.contains(this.fIcon.getLang())) {
                    this.fLanguage.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.fLanguage.select(0);
        }
        TableWrapData d = new TableWrapData(128);
        d.grabHorizontal = true;
        d.heightHint = 200;
        this.fList.setLayoutData((Object)d);
        this.fList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                UiNewMultiResolutionIconChooserDialog.this.fIcon.setValue(UiNewMultiResolutionIconChooserDialog.this.fList.getSelection()[0]);
                UiNewMultiResolutionIconChooserDialog.this.getButton(0).setEnabled(true);
            }
        });
        this.populateList();
        if (this.fIcon.getValue() != null) {
            String[] items = this.fList.getItems();
            int i2 = 0;
            while (i2 < items.length) {
                if (items[i2].equalsIgnoreCase(this.fIcon.getValue())) {
                    this.fList.select(i2);
                    break;
                }
                ++i2;
            }
        }
        this.fNewBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiNewMultiResolutionIconChooserDialog.this.onNewIcon(e);
            }
        });
        this.fRemoveBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiNewMultiResolutionIconChooserDialog.this.onDeleteIcon(e);
            }
        });
    }

    public void onDeleteIcon(SelectionEvent e) {
        String[] objects = this.fList.getSelection();
        if (objects.length == 1) {
            String name = objects[0];
            this.deleteList.add(name);
            IProject project = this.fpage.getProject();
            if (project != null) {
                Path filePath = new Path(String.valueOf(project.getProjectRelativePath().toString()) + IConstants.DIR_SHARED_RES + File.separator + name);
                try {
                    project.getFile((IPath)filePath).delete(true, null);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
            this.populateList();
        }
    }

    public void onNewIcon(SelectionEvent e) {
        UiNewIconWizard wizard = new UiNewIconWizard(this.fpage.getProject(), this.fIcon.getDpi());
        wizard.getOptions().setIconType(this.fIcon.getIconType());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() != 0) {
            return;
        }
        this.populateList();
    }

    protected void populateList() {
        if (this.fList != null) {
            this.fList.removeAll();
            try {
                if (this.resFolder.exists()) {
                    this.resFolder.accept(this.visitor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            Object[] items = this.fList.getItems();
            Arrays.sort(items);
            this.fList.removeAll();
            this.fList.setItems((String[])items);
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
    }
}

