/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tizen.nativecore.misc.editor.Messages;

public class POFile {
    private static final String MSG_ID = "msgid";
    private static final String QUOTE = "\"";
    private static final String SPACE = " ";
    private static final String EMPTY_STRING = "";
    private File pofile;
    private HashMap<String, String> labelAndValues;

    public POFile(File pofile) {
        block16: {
            this.pofile = null;
            this.labelAndValues = new HashMap();
            if (pofile == null) {
                throw new NullPointerException(Messages.POFile_no_content_msg);
            }
            this.pofile = pofile;
            BufferedReader br = null;
            try {
                try {
                    FileReader reader = new FileReader(pofile);
                    br = new BufferedReader(reader);
                    try {
                        String currentLine = null;
                        String label = null;
                        while ((currentLine = br.readLine()) != null) {
                            if (!currentLine.startsWith(MSG_ID)) continue;
                            String[] msgId = currentLine.split(SPACE);
                            label = msgId[1].replace(QUOTE, EMPTY_STRING);
                            currentLine = br.readLine();
                            String[] msgStr = currentLine.split("(?<!\\\\)\"");
                            String value = msgStr[1].replace("\\\"", QUOTE);
                            this.labelAndValues.put(label, value);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                    if (br == null) break block16;
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public File getFile() {
        return this.pofile;
    }

    public List<String> getLabelsFromPOFile() throws FileNotFoundException {
        ArrayList<String> labels = new ArrayList<String>();
        BufferedReader br = null;
        try {
            FileReader reader = new FileReader(this.pofile);
            br = new BufferedReader(reader);
            try {
                String currentLine = null;
                while ((currentLine = br.readLine()) != null) {
                    if (!currentLine.startsWith(MSG_ID)) continue;
                    String label = null;
                    String[] str = currentLine.split(SPACE);
                    label = str[1].replace(QUOTE, EMPTY_STRING);
                    labels.add(label);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return labels;
    }

    public HashMap<String, String> getLabelAndValues() {
        return this.labelAndValues;
    }

    public void setLabelAndValues(HashMap<String, String> labelAndValues) {
        this.labelAndValues = labelAndValues;
    }
}

