/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.csviewer.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sdb.command.FsCommand;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.RootJob;
import org.tizen.common.util.SdbCommandUtil;
import org.tizen.nativecommon.ApplicationConfiguration;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.sdblib.util.IOUtil;

public class CrashReportUtil {
    private static Logger logger = LoggerFactory.getLogger(ProjectUtil.class);
    public static final String CRASH_DIRNAME = "crash-info";

    public static String pullCSFile(IDevice device, String remoteCSPath) throws CoreException, IOException {
        String csLocalPath = null;
        String appid = "";
        if (remoteCSPath != null) {
            String csFile = FilenameUtil.getFilename((String)remoteCSPath);
            appid = ProjectUtil.getAppId((String)csFile);
            if (appid != null) {
                logger.info("Success in getting appid: " + appid);
                csLocalPath = CrashReportUtil.pullAndGetPath(csFile, appid, device, remoteCSPath);
            } else {
                logger.error("Failed to search a project: " + appid);
            }
            CrashReportUtil.checkArchiveFile(device, remoteCSPath);
        } else {
            logger.error("Failed to get app id from file name: " + remoteCSPath);
        }
        return csLocalPath;
    }

    private static String pullAndGetPath(String csFile, String appid, IDevice device, String remoteCSPath) throws CoreException, IOException {
        String csLocalPath = null;
        IProject project = CrashReportUtil.searchProject(appid);
        if (project != null) {
            IFolder folder = project.getFolder(CRASH_DIRNAME);
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            String csLocalDirPath = folder.getLocation().toOSString();
            csLocalPath = String.valueOf(csLocalDirPath) + File.separatorChar + csFile;
            SyncService syncService = null;
            try {
                syncService = device.getSyncService();
                SyncResult result = syncService.pull(device.getFileEntry(remoteCSPath), csLocalDirPath);
                if (result.isOk()) {
                    ProjectUtil.refreshResources((IProject)project);
                    logger.info("Downloaded cs file: " + csLocalPath);
                } else {
                    logger.error("Failed to pull file: " + csFile);
                }
            }
            finally {
                IOUtil.tryClose((Closeable)syncService);
            }
        }
        return csLocalPath;
    }

    private static void checkArchiveFile(IDevice device, String remoteCSPath) {
        boolean isZipExtension = "zip".equals(FilenameUtil.getExtension((String)remoteCSPath));
        String fileName = FilenameUtil.getFilename((String)remoteCSPath);
        String CSName = fileName.substring(0, fileName.indexOf(46)).trim();
        String CSPath = remoteCSPath.substring(0, remoteCSPath.lastIndexOf(47) + 1).trim();
        String zipFilePath = String.valueOf(CSPath) + CSName + ".zip";
        String infoFilePathinZip = String.valueOf(CSName) + "/" + CSName + ".info";
        String extractInfoFilePath = String.valueOf(CSPath) + CSName + ".info";
        if (isZipExtension) {
            class InstallJob
            implements RootJob {
                private boolean isSuccess = false;
                private final /* synthetic */ IDevice val$device;
                private final /* synthetic */ String val$zipFilePath;
                private final /* synthetic */ String val$infoFilePathinZip;
                private final /* synthetic */ String val$extractInfoFilePath;

                InstallJob(IDevice iDevice, String string, String string2, String string3) {
                    this.val$device = iDevice;
                    this.val$zipFilePath = string;
                    this.val$infoFilePathinZip = string2;
                    this.val$extractInfoFilePath = string3;
                }

                public void run() {
                    FsCommand command = new FsCommand(this.val$device, null);
                    try {
                        this.isSuccess = command.unzipCOptionAndCreateFile(this.val$zipFilePath, this.val$infoFilePathinZip, this.val$extractInfoFilePath);
                    }
                    catch (Exception exception) {
                        this.isSuccess = false;
                        return;
                    }
                }

                public boolean isSuccess() {
                    return this.isSuccess;
                }
            }
            InstallJob installJob = new InstallJob(device, zipFilePath, infoFilePathinZip, extractInfoFilePath);
            SdbCommandUtil.runCommandOnRoot((IDevice)device, (RootJob)installJob);
        }
    }

    public static IProject searchProject(String appid) {
        IProject project = null;
        if (appid != null) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ApplicationConfiguration config = null;
            String tmpId = null;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                config = new ApplicationConfiguration(proj);
                if (config != null && (tmpId = config.getAppId()) != null) {
                    if (appid.equals(tmpId)) {
                        project = proj;
                        break;
                    }
                    int idxSub = tmpId.lastIndexOf(".");
                    String lastSegementOfAppid = tmpId.substring(idxSub + 1, tmpId.length()).trim();
                    if (appid.equals(lastSegementOfAppid)) {
                        project = proj;
                        break;
                    }
                }
                ++n2;
            }
        }
        return project;
    }
}

