/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.delegate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.launcher.LauncherInstances;
import org.tizen.nativeplatform.launcher.delegate.ILaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.factory.PkgFilterFactory;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.launcher.rpm.IPkgFilter;
import org.tizen.nativeplatform.launcher.rpm.RpmPackageLauncher;
import org.tizen.nativeplatform.launcher.wizards.PlatformInstallAsWizard;
import org.tizen.nativeplatform.launcher.wizards.PlatformLaunchWizard;
import org.tizen.nativeplatform.launcher.wizards.PlatformLaunchWizardDialog;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.IPkgModelMaker;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.types.LaunchTypes;
import org.tizen.nativeplatform.util.CommonPackageUtil;
import org.tizen.nativeplatform.util.IPackageUtil;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.nativeplatform.util.PlatformProjectUtil;

public class LaunchConfigurationProcessor
implements ILaunchConfigurationProcessor {
    private ILaunchConfiguration launchConfig;
    private IProject project;
    private IConfiguration buildConfig;
    private String mode;
    private IProgressMonitor monitor;
    private Shell shell;
    private PkgCommandTarget target;
    private String applicationId = "";
    private IPackageUtil pkgUtil = LauncherInstances.getPackageUtil();
    private IPkgFilter pkgFilter = PkgFilterFactory.getFilter(PlatformProjectUtil.getPkgType());
    private String rootstrapInstallLog = "";
    private String deviceInstallLog = "";
    private boolean continueLaunch = true;
    private boolean onlyInstall = false;

    public LaunchConfigurationProcessor() {
    }

    public LaunchConfigurationProcessor(Shell shell, ILaunchConfiguration launchConfig, IProject project, String mode, PkgCommandTarget target, IProgressMonitor monitor) {
        this.shell = shell;
        this.launchConfig = launchConfig;
        this.project = project;
        this.mode = mode;
        this.target = target;
        this.monitor = monitor;
        this.buildConfig = this.getBuildConfiguration();
    }

    public LaunchConfigurationProcessor(Shell shell, ILaunchConfiguration launchConfig, IProject project, String mode, PkgCommandTarget target, IProgressMonitor monitor, boolean onlyInstall) {
        this.shell = shell;
        this.launchConfig = launchConfig;
        this.project = project;
        this.mode = mode;
        this.target = target;
        this.monitor = monitor;
        this.buildConfig = this.getBuildConfiguration();
        this.onlyInstall = onlyInstall;
    }

    @Override
    public boolean process() throws CoreException {
        boolean configurationIsSet = this.isSetProgramPath(this.launchConfig);
        boolean isEflApp = CommonPackageUtil.checkXmls((IProject)this.project);
        LauncherInstances.getLaunchCommandUtil().winTransferSshKey(this.target);
        if (configurationIsSet) {
            if (isEflApp) {
                String appId = this.launchConfig.getAttribute("org.tizen.platform.launch.APP_ID_ATTR", "");
                this.killIfRunningApplication(appId);
            }
            boolean result = this.installPackages(configurationIsSet, this.monitor);
            UserLogger.end((String)"platform.launch", (String)"pre.launch");
            return result;
        }
        this.monitor.beginTask("", 2);
        try {
            if (isEflApp) {
                String[] appIds;
                String[] stringArray = appIds = PlatformLaunchUtil.getAppId((IProject)this.project);
                int n = appIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String appId = stringArray[n2];
                    this.killIfRunningApplication(appId);
                    ++n2;
                }
            }
            UserLogger.end((String)"platform.launch", (String)"pre.launch");
            if (!this.setLaunchConfiguration((IProgressMonitor)new SubProgressMonitor(this.monitor, 1), isEflApp)) {
                return false;
            }
        }
        finally {
            this.monitor.done();
        }
        return true;
    }

    private boolean _installPackages(List<IPackage> devicePkgs, List<IPackage> rootstrapPkgs, boolean reinstallOp, IProgressMonitor monitor) throws CoreException {
        block6: {
            int totalWorks = 1;
            monitor.beginTask("", totalWorks);
            RpmPackageLauncher pkgLauncher = new RpmPackageLauncher(this.project, this.target, devicePkgs, rootstrapPkgs, reinstallOp);
            try {
                try {
                    if (this.mode.equals("debug")) {
                        pkgLauncher.debugLaunchPkgs(LaunchTypes.NONE, this.shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        this.setSmackRule();
                        break block6;
                    }
                    pkgLauncher.launchPkgs(this.shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (InterruptedException e) {
                    this.newCoreException(PlatformLaunchMessages.FAILED_INSTALL_PKGS, e);
                    monitor.done();
                    this.rootstrapInstallLog = pkgLauncher.getRootstrapLog();
                    this.deviceInstallLog = pkgLauncher.getDeviceLog();
                }
            }
            finally {
                monitor.done();
                this.rootstrapInstallLog = pkgLauncher.getRootstrapLog();
                this.deviceInstallLog = pkgLauncher.getDeviceLog();
            }
        }
        return true;
    }

    private void setSmackRule() {
        String[] programPaths = PlatformLaunchUtil.getProgramPath((IProject)this.project);
        if (programPaths == null || programPaths.length <= 0) {
            return;
        }
        IPkgCommander commander = this.target.getDeviceCommander();
        StringBuffer pathlist = new StringBuffer();
        String[] stringArray = programPaths;
        int n = programPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            pathlist.append(path);
            pathlist.append(" ");
            ++n2;
        }
        String list = pathlist.toString().trim();
        Map smackInfo = PlatformLaunchUtil.getSmackInfo((IPkgCommander)commander, (String)list);
        if (smackInfo == null) {
            return;
        }
        for (String filepath : smackInfo.keySet()) {
            String[] labels = (String[])smackInfo.get(filepath);
            String a_label = labels[0];
            if (a_label != null && !a_label.isEmpty()) {
                commander.executeBinaryBySudo(this.getSmackRuleCommand(a_label));
            }
            commander.setSmackExecute(filepath, "\"\"");
        }
    }

    private String getSmackRuleCommand(String value) {
        value = value.replaceAll("\"", "");
        String cmd = String.format("echo \"sdbd::home %s rwx\" | smackload", value);
        return cmd;
    }

    private boolean installPackages(boolean configurationIsSet, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.launchConfig.getWorkingCopy();
        ArrayList<IPackage> devicePackages = new ArrayList<IPackage>();
        ArrayList<IPackage> rootstrapPackages = new ArrayList<IPackage>();
        boolean reinstallOp = true;
        if (configurationIsSet) {
            IPkgModelMaker maker = CommonPackageUtil.getModelMaker();
            Map devicePkgs = wc.getAttribute("org.tizen.platform.launch.DEVICE_PACKAGE_LIST_ATTR", new HashMap());
            Set pathSet = devicePkgs.keySet();
            devicePackages.addAll(maker.makeModels(pathSet));
            for (IPackage pkg : devicePackages) {
                String path = pkg.getPath();
                String tool = (String)devicePkgs.get(path);
                pkg.setTool(tool);
            }
            Map rootstrapPkgs = wc.getAttribute("org.tizen.platform.launch.ROOTSTRAP_PACKAGE_LIST_ATTR", new HashMap());
            pathSet = rootstrapPkgs.keySet();
            rootstrapPackages.addAll(maker.makeModels(pathSet));
            for (IPackage pkg : rootstrapPackages) {
                String path = pkg.getPath();
                String tool = (String)rootstrapPkgs.get(path);
                pkg.setTool(tool);
            }
        } else {
            List packages = null;
            packages = this.pkgUtil.getPackages(this.project, this.buildConfig);
            if (packages != null && !packages.isEmpty()) {
                devicePackages.addAll(this.pkgFilter.filter(CmdTargetTypes.DEVICE, packages));
                rootstrapPackages.addAll(this.pkgFilter.filter(CmdTargetTypes.ROOTSTRAP, packages));
            }
            this.setOptionAttributes(wc, devicePackages, rootstrapPackages, reinstallOp);
        }
        if (this.questionIfNoPackagesToInstall(devicePackages, rootstrapPackages)) {
            return this._installPackages(devicePackages, rootstrapPackages, reinstallOp, monitor);
        }
        return false;
    }

    private boolean setLaunchConfiguration(IProgressMonitor monitor, final boolean isEflApp) throws CoreException {
        monitor.beginTask("", 1);
        final ILaunchConfigurationWorkingCopy wc = this.launchConfig.getWorkingCopy();
        try {
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    PlatformLaunchWizardDialog wizardDlg;
                    if (LaunchConfigurationProcessor.this.onlyInstall) {
                        PlatformInstallAsWizard installWizard = new PlatformInstallAsWizard(LaunchConfigurationProcessor.this.shell, LaunchConfigurationProcessor.this.launchConfig, LaunchConfigurationProcessor.this.project, LaunchConfigurationProcessor.this.buildConfig, LaunchConfigurationProcessor.this.target, LaunchConfigurationProcessor.this.mode, isEflApp);
                        wizardDlg = new PlatformLaunchWizardDialog(LaunchConfigurationProcessor.this.shell, installWizard);
                    } else {
                        PlatformLaunchWizard wizard = new PlatformLaunchWizard(LaunchConfigurationProcessor.this.shell, LaunchConfigurationProcessor.this.launchConfig, LaunchConfigurationProcessor.this.project, LaunchConfigurationProcessor.this.buildConfig, LaunchConfigurationProcessor.this.target, LaunchConfigurationProcessor.this.mode, isEflApp);
                        wizardDlg = new PlatformLaunchWizardDialog(LaunchConfigurationProcessor.this.shell, wizard);
                    }
                    wizardDlg.create();
                    if (wizardDlg.open() == 0) {
                        String programPath = wizardDlg.getProgramPath();
                        String arguments = wizardDlg.getArguments();
                        List<IPackage> devicePkgs = wizardDlg.getDevicePackages();
                        List<IPackage> rootstrapPkgs = wizardDlg.getRootstrapPackages();
                        boolean loadSharedLib = wizardDlg.loadSharedLibAutomatically();
                        LaunchConfigurationProcessor.this.applicationId = wizardDlg.getSelectedApp();
                        Map<String, String> environments = wizardDlg.getEnvironments();
                        LaunchConfigurationProcessor.this.setOptionAttributes(wc, devicePkgs, rootstrapPkgs, true);
                        LaunchConfigurationProcessor.this.setOptionAttributes(wc, programPath, arguments, LaunchConfigurationProcessor.this.applicationId, environments, loadSharedLib);
                    }
                }
            });
        }
        finally {
            monitor.done();
        }
        if (this.isSetProgramPath(this.launchConfig)) {
            if (this.applicationId != null && !this.applicationId.isEmpty()) {
                this.killIfRunningApplication(this.applicationId);
            }
            return true;
        }
        return this.onlyInstall;
    }

    protected void setOptionAttributes(ILaunchConfigurationWorkingCopy wc, String programPath, String arguments, String applicationId, Map<String, String> environments, boolean loadSharedLib) {
        if (programPath != null) {
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programPath);
        }
        if (arguments != null) {
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", arguments);
        }
        if (applicationId != null) {
            wc.setAttribute("org.tizen.platform.launch.APP_ID_ATTR", applicationId);
        }
        if (environments != null && environments.size() == 0) {
            wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        } else {
            wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, environments);
        }
        wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
        wc.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, loadSharedLib);
        try {
            wc.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
            e.printStackTrace();
        }
    }

    protected void setOptionAttributes(ILaunchConfigurationWorkingCopy wc, List<IPackage> devicePackages, List<IPackage> rootstrapPackages, boolean reinstallOp) {
        String tool;
        String path;
        HashMap<String, String> values;
        wc.setAttribute("org.tizen.platform.launch.REINSTALL_OP_ATTR", reinstallOp);
        if (devicePackages != null) {
            values = new HashMap<String, String>();
            for (IPackage p : devicePackages) {
                path = p.getPath();
                tool = p.getTool();
                if (tool == null || tool.isEmpty()) {
                    tool = "rpm";
                }
                values.put(path, tool);
            }
            wc.setAttribute("org.tizen.platform.launch.DEVICE_PACKAGE_LIST_ATTR", values);
        }
        if (rootstrapPackages != null) {
            values = new HashMap();
            for (IPackage p : rootstrapPackages) {
                path = p.getPath();
                tool = p.getTool();
                if (tool == null || tool.isEmpty()) {
                    tool = "rpm";
                }
                values.put(path, tool);
            }
            wc.setAttribute("org.tizen.platform.launch.ROOTSTRAP_PACKAGE_LIST_ATTR", values);
        }
        try {
            wc.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
            e.printStackTrace();
        }
    }

    protected boolean isSetProgramPath(ILaunchConfiguration wc) throws CoreException {
        String path = wc.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        return !path.isEmpty();
    }

    protected void killIfRunningApplication(String appId) throws CoreException {
        if (appId == null || appId.isEmpty()) {
            return;
        }
        IPkgCommander commander = this.target.getCommander(CmdTargetTypes.DEVICE);
        boolean isRunning = commander.isRunningApp(appId);
        if (isRunning) {
            commander.killApp(appId);
        }
    }

    protected void newCoreException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.tizen.nativeplatform", message, exception);
        throw new CoreException((IStatus)status);
    }

    protected IConfiguration getBuildConfiguration() {
        return PlatformConfigurationManager.getDefaultConfiguration((IProject)this.project);
    }

    protected boolean questionIfNoPackagesToInstall(List<IPackage> devicePackages, List<IPackage> rootstrapPackages) {
        final StringBuffer msg = new StringBuffer();
        if (devicePackages.isEmpty()) {
            msg.append("There is no package to install to device.");
            msg.append("\n");
        }
        if (this.mode.equals("debug") && rootstrapPackages.isEmpty()) {
            msg.append("There is no package to install to rootstrap.");
            msg.append("\n");
        }
        if (msg.length() != 0) {
            msg.append("\n");
            msg.append("Do you want to continue?");
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (DialogUtil.openQuestionDialog((String)msg.toString()) == 64) {
                        LaunchConfigurationProcessor.this.continueLaunch = true;
                    } else {
                        LaunchConfigurationProcessor.this.continueLaunch = false;
                    }
                }
            });
        }
        return this.continueLaunch;
    }
}

