/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsoleViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativeplatform.model.Architecture;
import org.tizen.nativeplatform.pkgmgr.ui.AddRepoDialog;
import org.tizen.nativeplatform.pkgmgr.ui.ModifyRepoDialog;
import org.tizen.nativeplatform.preferences.RootstrapPreferencesManager;
import org.tizen.nativeplatform.rootstrap.CommonRootstrapManager;
import org.tizen.nativeplatform.rootstrap.util.RootstrapNameUtil;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapWizardData;

public class RootstrapSettingPage2
extends WizardPage {
    private final String BUNDLE_NAME = String.valueOf(RootstrapSettingPage2.class.getPackage().getName()) + ".RootstrapWizardUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private Shell shell;
    private IOConsoleViewer logViewer;
    private TableViewer repoTable;
    private Combo archCombo;
    private Text rootstrapText;
    private Button add_bt;
    private Button remove_bt;
    private Button modify_bt;
    private Button moveup_bt;
    private Button movedown_bt;
    private Button generateImmediateBt;
    private final String GENERATE_CONSOLE_NAME = "Rootstrap Generation";
    protected final Logger logger = LoggerFactory.getLogger(RootstrapSettingPage2.class);

    public RootstrapSettingPage2(String pageName, Shell shell) {
        super(pageName);
        this.shell = shell;
        this.setTitle(this.resources.getString("RootstrapPage2.Title"));
    }

    public void updatePageForRemoteRepo() {
        List<String> snapshots = RootstrapWizardData.getSnapshots();
        String rootstrapName = RootstrapNameUtil.getRootstrapNameForRemoteRepo(snapshots.toArray(new String[0]));
        this.rootstrapText.setText(rootstrapName);
        this.setArchitectureCombo(RootstrapWizardData.getArchStrings());
        this.UpdateRepositories(null);
        this.addDefaultInput();
        this.enableRepositoryButtons(true);
    }

    public void updatePageForLocalRepo() {
        String localrepoPath = RootstrapWizardData.getLocalrepoPath();
        String rootstrapName = RootstrapNameUtil.getRootstrapNameForLocalRepo(localrepoPath);
        this.rootstrapText.setText(rootstrapName);
        this.setArchitectureCombo(RootstrapWizardData.getArchStrings());
        ArrayList<String> localrepos = new ArrayList<String>();
        localrepos.add(localrepoPath);
        this.UpdateRepositories(localrepos);
        this.enableRepositoryButtons(false);
    }

    private void addDefaultInput() {
        ArrayList<String> repos = (ArrayList<String>)this.repoTable.getInput();
        if (repos == null) {
            repos = new ArrayList<String>();
        } else {
            repos.clear();
        }
        if (this.archCombo.getText().equals("armv7l")) {
            this.addDefaultRootstrapUrl(repos, RootstrapPreferencesManager.getStandardRootstrapUrl0Default());
            this.addDefaultRootstrapUrl(repos, RootstrapPreferencesManager.getStandardRootstrapUrl1Default());
        } else {
            this.addDefaultRootstrapUrl(repos, RootstrapPreferencesManager.getStandardRootstrapUrl0Ia32Default());
            this.addDefaultRootstrapUrl(repos, RootstrapPreferencesManager.getStandardRootstrapUrl1Ia32Default());
        }
        this.UpdateRepositories(repos);
    }

    private void addDefaultRootstrapUrl(List<String> list, String defaultValue) {
        if (!defaultValue.equals("")) {
            list.add(defaultValue);
        }
    }

    private void setArchitectureCombo(List<String> archs) {
        this.archCombo.setItems(archs.toArray(new String[0]));
        this.archCombo.select(0);
        RootstrapWizardData.setRootstrapArch(this.archCombo.getText());
    }

    private void enableRepositoryButtons(boolean enable) {
        this.add_bt.setEnabled(enable);
        this.remove_bt.setEnabled(enable);
        this.modify_bt.setEnabled(enable);
        this.moveup_bt.setEnabled(enable);
        this.movedown_bt.setEnabled(enable);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createNameComposite(composite);
        this.createArchComposite(composite);
        this.createTableComposite(composite);
        this.createLogViewer(composite);
        this.setControl((Control)composite);
    }

    private void createNameComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Label lName = new Label(composite, 0);
        lName.setText(this.resources.getString("RootstrapPage3.Name"));
        this.rootstrapText = new Text(composite, 2052);
        this.rootstrapText.setLayoutData((Object)gridData);
        this.rootstrapText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RootstrapWizardData.setRootstrapName(RootstrapSettingPage2.this.rootstrapText.getText());
                RootstrapSettingPage2.this.validateRootstrapName();
            }
        });
    }

    private void createArchComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Label archLabel = new Label(composite, 16);
        archLabel.setText(this.resources.getString("RootstrapPage.Label.Arch"));
        this.archCombo = new Combo(composite, 8);
        this.archCombo.setLayoutData((Object)gridData);
        this.archCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RootstrapWizardData.setRootstrapArch(RootstrapSettingPage2.this.archCombo.getText());
                RootstrapSettingPage2.this.UpdateRepositories(null);
                RootstrapSettingPage2.this.addDefaultInput();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.generateImmediateBt = new Button(composite, 32);
        this.generateImmediateBt.setText(this.resources.getString("RootstrapPage.Label.GenImmediately"));
        this.generateImmediateBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RootstrapWizardData.setGenImmediately(RootstrapSettingPage2.this.generateImmediateBt.getSelection());
            }
        });
        this.generateImmediateBt.setSelection(false);
    }

    private void createLogViewer(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridData gridData = new GridData(768);
        gridData.heightHint = 150;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new FillLayout());
        RootstrapWizardData.setConsoleMgr(new ConsoleManager("Rootstrap Generation", false));
        RootstrapWizardData.getConsoleMgr().clear();
        MessageConsoleStream mcs = RootstrapWizardData.getConsoleMgr().getMessageConsoleStream();
        this.logViewer = new IOConsoleViewer(composite, (TextConsole)mcs.getConsole());
        int line = this.logViewer.getTextWidget().getLineCount();
        if (line > 0) {
            this.logViewer.getTextWidget().setTopIndex(line);
        }
        IOUtil.tryClose((Object[])new Object[]{mcs});
    }

    private void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 100;
        gridData.heightHint = 100;
        composite.setLayoutData((Object)gridData);
        this.createRepositoryTable(composite);
        this.createRepositoryButtons(composite);
    }

    private void createRepositoryTable(Composite parent) {
        Composite t_composite = new Composite(parent, 0);
        t_composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        t_composite.setLayout((Layout)layout);
        this.repoTable = new TableViewer(t_composite, 2304);
        Table table = this.repoTable.getTable();
        GridData tableGridData = new GridData(1808);
        table.setLayoutData((Object)tableGridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{"Repositories"};
        int[] columnWidths = new int[]{1000};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(columnWidths[i]);
            tableColumn.setResizable(true);
            ++i;
        }
        this.repoTable.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void createRepositoryButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.createAddButton(composite);
        this.createRemoveButton(composite);
        this.createModifyButton(composite);
        this.createMoveupButton(composite);
        this.createMovedownButton(composite);
    }

    private void createAddButton(Composite parent) {
        this.add_bt = new Button(parent, 8);
        Image addIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/add.gif");
        this.add_bt.setImage(addIcon);
        this.add_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                AddRepoDialog dialog = new AddRepoDialog(RootstrapSettingPage2.this.shell, "Rootstrap", false);
                if (dialog.open() != 0) {
                    return;
                }
                String url = dialog.getRepositoryURL();
                RootstrapSettingPage2.this.addRepository(url);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createRemoveButton(Composite parent) {
        this.remove_bt = new Button(parent, 8);
        Image removeIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/remove.gif");
        this.remove_bt.setImage(removeIcon);
        this.remove_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int selectedIdx = RootstrapSettingPage2.this.repoTable.getTable().getSelectionIndex();
                RootstrapSettingPage2.this.removeRepository(selectedIdx);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createModifyButton(Composite parent) {
        this.modify_bt = new Button(parent, 8);
        Image modifyIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/edit.gif");
        this.modify_bt.setImage(modifyIcon);
        this.modify_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int selectedIdx = RootstrapSettingPage2.this.repoTable.getTable().getSelectionIndex();
                String repo = (String)RootstrapSettingPage2.this.repoTable.getTable().getItem(selectedIdx).getData();
                String name = "repository";
                ModifyRepoDialog dialog = new ModifyRepoDialog(RootstrapSettingPage2.this.shell, "Rootstrap", name, repo, false);
                if (dialog.open() != 0) {
                    return;
                }
                if (dialog.isDirty()) {
                    String newUrl = dialog.getRepositoryURL();
                    RootstrapSettingPage2.this.modifyRepository(selectedIdx, newUrl);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createMoveupButton(Composite parent) {
        this.moveup_bt = new Button(parent, 8);
        Image moveupIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/list-moveup.gif");
        this.moveup_bt.setImage(moveupIcon);
        this.moveup_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int selectedIdx = RootstrapSettingPage2.this.repoTable.getTable().getSelectionIndex();
                if (selectedIdx < 1) {
                    return;
                }
                RootstrapSettingPage2.this.moveUpRepository(selectedIdx);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createMovedownButton(Composite parent) {
        this.movedown_bt = new Button(parent, 8);
        Image movedownIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/list-movedown.gif");
        this.movedown_bt.setImage(movedownIcon);
        this.movedown_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int size = ((List)RootstrapSettingPage2.this.repoTable.getInput()).size();
                int selectedIdx = RootstrapSettingPage2.this.repoTable.getTable().getSelectionIndex();
                if (selectedIdx >= size - 1) {
                    return;
                }
                RootstrapSettingPage2.this.moveDownRepository(selectedIdx);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void addRepository(String newRepo) {
        ArrayList<String> repos = (ArrayList<String>)this.repoTable.getInput();
        if (repos == null) {
            repos = new ArrayList<String>();
        }
        repos.add(newRepo);
        this.UpdateRepositories(repos);
    }

    private void moveUpRepository(int index) {
        String repo_1 = (String)this.repoTable.getTable().getItem(index).getData();
        String repo_2 = (String)this.repoTable.getTable().getItem(index - 1).getData();
        List repos = (List)this.repoTable.getInput();
        repos.remove(index - 1);
        repos.add(index - 1, repo_1);
        repos.remove(index);
        repos.add(index, repo_2);
        this.UpdateRepositories(repos);
        this.repoTable.getTable().setSelection(index - 1);
    }

    private void moveDownRepository(int index) {
        String repo_1 = (String)this.repoTable.getTable().getItem(index).getData();
        String repo_2 = (String)this.repoTable.getTable().getItem(index + 1).getData();
        List repos = (List)this.repoTable.getInput();
        repos.remove(index + 1);
        repos.add(index + 1, repo_1);
        repos.remove(index);
        repos.add(index, repo_2);
        this.UpdateRepositories(repos);
        this.repoTable.getTable().setSelection(index + 1);
    }

    private void modifyRepository(int index, String newRepo) {
        List repos = (List)this.repoTable.getInput();
        repos.remove(index);
        repos.add(index, newRepo);
        this.UpdateRepositories(repos);
    }

    private void removeRepository(int index) {
        String data = (String)this.repoTable.getTable().getItem(index).getData();
        List repos = (List)this.repoTable.getInput();
        ArrayList<String> newRepos = new ArrayList<String>();
        for (String repo : repos) {
            if (repo.equals(data)) continue;
            newRepos.add(repo);
        }
        this.UpdateRepositories(newRepos);
    }

    private void UpdateRepositories(List<String> data) {
        if (data == null) {
            int selectIdx = this.archCombo.getSelectionIndex();
            data = new ArrayList<String>();
            if (selectIdx >= 0) {
                String text = this.archCombo.getText();
                List<Architecture> architectures = RootstrapWizardData.getArchitectures();
                if (architectures == null || architectures.isEmpty()) {
                    return;
                }
                for (Architecture arch : architectures) {
                    List repos;
                    if (!arch.getArch().equals(text) || (repos = arch.getRepositories()) == null || repos.isEmpty()) continue;
                    int idx = 0;
                    while (idx < repos.size()) {
                        data.add((String)repos.get(idx));
                        ++idx;
                    }
                }
            }
        }
        this.repoTable.setInput(data);
        RootstrapWizardData.getRepositories().clear();
        RootstrapWizardData.addRepositories(data);
        this.updatePageCompleted();
    }

    private void setDefaultMessage() {
        int repoSize = RootstrapWizardData.getRepositories().size();
        this.setMessage(String.format(this.resources.getString("RtPage.Msg.GetRepo"), repoSize));
    }

    public boolean validateRootstrapName() {
        String rootstrapName = this.rootstrapText.getText();
        if (!RootstrapNameUtil.validateRootstrapName(rootstrapName)) {
            this.pageNotCompleted(this.resources.getString("RootstrapPage.Error.RootstrapName"));
            return false;
        }
        if (CommonRootstrapManager.existsRootstrap(rootstrapName)) {
            this.pageNotCompleted(String.format(this.resources.getString("RootstrapPage.Error.ExistsRootstrap"), rootstrapName));
            return false;
        }
        this.pageCompleted();
        return true;
    }

    public void updatePageCompleted() {
        if (this.validPageComplete()) {
            this.pageCompleted();
        } else {
            this.pageNotCompleted(this.resources.getString("RtPage.ErrorMsg.FailedGetRepo"));
        }
    }

    private boolean validPageComplete() {
        String rootstrapName = RootstrapWizardData.getRootstrapName();
        int repoSize = RootstrapWizardData.getRepositories().size();
        int tableCount = this.repoTable.getTable().getItemCount();
        return tableCount > 0 && repoSize == tableCount && !rootstrapName.isEmpty();
    }

    private void pageNotCompleted(String errorMsg) {
        this.setErrorMessage(errorMsg);
        this.setPageComplete(false);
    }

    private void pageCompleted() {
        this.setErrorMessage(null);
        this.setDefaultMessage();
        this.setPageComplete(true);
    }
}

