/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.nativeplatform.util.IPlatformUtility;

public class PlatformUtilityFactory {
    private static final String EXTENSION_ID = "org.tizen.nativeplatform.utility";
    private static final String TAG_UTIL = "utility";
    private static final String ATTR_ID = "id";
    private static final String ATTR_OS = "os";
    private static final String ATTR_CLASS = "class";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public IPlatformUtility getUtility() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] exts = ep.getExtensions();
        ArrayList<Proxy> found = new ArrayList<Proxy>();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configElems = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configElems.length) {
                Proxy proxy = this.parseType(configElems[j], TAG_UTIL);
                if (proxy != null) {
                    found.add(proxy);
                }
                ++j;
            }
            ++i;
        }
        Proxy[] proxy = found.toArray(new Proxy[found.size()]);
        int i2 = 0;
        while (i2 < proxy.length) {
            if (OSChecker.isLinux() || OSChecker.isUnix() ? proxy[i2].getOs().equals("linux") || proxy[i2].getOs().equals("unix") : OSChecker.isWindows() && (proxy[i2].getOs().equals("windows") || proxy[i2].getOs().equals("win"))) {
                return (IPlatformUtility)proxy[i2].getProvider();
            }
            ++i2;
        }
        return null;
    }

    private Proxy parseType(IConfigurationElement configElem, String tag) {
        if (!configElem.getName().equals(tag)) {
            return null;
        }
        try {
            return new Proxy(configElem);
        }
        catch (Exception e) {
            String name = configElem.getAttribute(ATTR_ID);
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load provider named" + name + " in " + configElem.getDeclaringExtension().getNamespace();
            this.logger.error(msg, (Throwable)e);
            return null;
        }
    }

    private static class Proxy {
        private IConfigurationElement configElement;
        private String id;
        private String os;
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());

        public Proxy(IConfigurationElement configElem) {
            this.configElement = configElem;
            this.id = this.getAttribute(configElem, PlatformUtilityFactory.ATTR_ID, "");
            this.os = this.getAttribute(configElem, PlatformUtilityFactory.ATTR_OS, "linux");
            this.getAttribute(configElem, PlatformUtilityFactory.ATTR_CLASS, null);
        }

        public String getOs() {
            return this.os;
        }

        private String getAttribute(IConfigurationElement configElem, String name, String defaultValue) {
            String value = configElem.getAttribute(name);
            if (value != null) {
                return value;
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IllegalArgumentException("Missing" + name + "attribute");
        }

        public Object getProvider() {
            Object obj = null;
            try {
                obj = this.configElement.createExecutableExtension(PlatformUtilityFactory.ATTR_CLASS);
            }
            catch (CoreException e) {
                String msg = "Failed to get provider: " + this.configElement.getAttribute(PlatformUtilityFactory.ATTR_CLASS) + " in type: " + this.id + " in plugin: " + this.configElement.getDeclaringExtension().getNamespace();
                this.logger.error(msg, (Throwable)e);
            }
            return obj;
        }
    }
}

