/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.toolbar.DeviceDescriptor;
import org.tizen.common.connection.ui.TizenRemoteFileDialog;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.LocalPortChecker;
import org.tizen.nativecommon.TizenNativeException;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativeplatform.IPlatformXMLStore;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.preferences.DevicePreferencesManager;
import org.tizen.nativeplatform.preferences.PreferencesManager;
import org.tizen.nativeplatform.preferences.RootstrapPreferencesManager;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.util.CommonBuildCommandUtil;
import org.tizen.nativeplatform.util.PlatformFileUtil;
import org.tizen.nativeplatform.util.PlatformProjectUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.service.FileEntry;

public class PlatformLaunchUtil {
    public static int LIMIT_COMMAND_LENGTH = 800;
    public static final String APP_PROJ_DEFAULT_SELECTION = "[Nothing]";
    public static final String LAUNCHPAD_PATH = "/usr/bin/launchpad-loader";
    public static final String GDB_PACKAGE = "gdb";
    public static final String AUL_PACKAGE = "aul";
    public static final String LAUNCHPAD_PACKAGE = "launchpad";
    public static final String TEMP_STRING_EXEC = "##changableexec##";
    public static final String TEMP_STRING_ID = "##changableid##";
    public static final int GDBLOCAL_BASEPORT_DEFAULT = 46100;
    private static final String BUNDLE_NAME = String.valueOf(PlatformLaunchUtil.class.getPackage().getName()) + ".UIMessages";
    private static ResourceBundle resources = ResourceBundle.getBundle(BUNDLE_NAME);
    private static final Logger logger = LoggerFactory.getLogger(PlatformLaunchUtil.class);

    public static boolean checkDeviceRootOn(IDevice device) {
        if (device != null && !device.isRoot()) {
            try {
                if (!device.becomeSuperUser(true)) {
                    return false;
                }
            }
            catch (Exception e) {
                logger.error(resources.getString("Device.not.rooton"), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static Shell getAvaiableShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                window = windows[0];
            } else {
                return null;
            }
        }
        return window.getShell();
    }

    public static String[] getProjectInfo(IProject project) {
        String version;
        String name;
        String[] infos;
        block18: {
            infos = new String[2];
            name = null;
            version = null;
            IFolder folder = project.getFolder("packaging");
            File dir = new File(folder.getLocation().toOSString());
            File specfile = null;
            if (dir.exists()) {
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isFile() && f.getName().endsWith(".spec")) {
                        specfile = f;
                        break;
                    }
                    ++n2;
                }
            }
            if (specfile == null) {
                return null;
            }
            BufferedReader in = null;
            try {
                String s;
                in = new BufferedReader(new FileReader(specfile.getPath()));
                while ((s = in.readLine()) != null) {
                    String[] arrStr;
                    if ((s = s.trim()).startsWith("Name:")) {
                        arrStr = s.split(":");
                        if (arrStr.length == 2) {
                            name = arrStr[1].trim();
                            continue;
                        }
                    } else if (s.startsWith("Version:") && (arrStr = s.split(":")).length == 2) {
                        version = arrStr[1].trim();
                        continue;
                    }
                    if (name == null || version == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (FileNotFoundException e) {
                logger.error("failed to get project information", (Throwable)e);
                IOUtil.tryClose((Object[])new Object[]{in});
                break block18;
            }
            catch (IOException e) {
                try {
                    logger.error("failed to get project information", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{in});
                break block18;
            }
            IOUtil.tryClose((Object[])new Object[]{in});
        }
        if (name != null && version != null) {
            infos[0] = name;
            infos[1] = version;
            return infos;
        }
        return null;
    }

    public static String[] getDebugPackageName(IPkgCommander commander, String binaryPkg) {
        String sourcePackage = commander.getSrcPkgName(binaryPkg);
        String[] result = new String[3];
        if (sourcePackage.isEmpty()) {
            result[0] = String.valueOf(binaryPkg) + "-debuginfo";
            result[1] = String.valueOf(binaryPkg) + "-debugsource";
        } else {
            result[0] = String.valueOf(sourcePackage) + "-debuginfo";
            result[1] = String.valueOf(sourcePackage) + "-debugsource";
        }
        return result;
    }

    public static String getDevelPackageName(IPkgCommander commander, String binaryPkg) {
        String sourcePackage = commander.getSrcPkgName(binaryPkg);
        String result = "";
        result = sourcePackage.isEmpty() ? String.valueOf(binaryPkg) + "-devel" : String.valueOf(sourcePackage) + "-devel";
        return result;
    }

    public static void readyGdbServer(PkgCommandTarget cmdTarget, IDevice device, TizenLaunchCommand command, IPath srcPath) throws CoreException, TimeoutException, SdbCommandRejectedException, IOException, Exception {
        String gdbserverPath = srcPath.toString();
        if (!PlatformFileUtil.existsFile(gdbserverPath)) {
            IPkgCommander commander = cmdTarget.getCommander(CmdTargetTypes.ROOTSTRAP);
            commander.installRemotePkg("gdb-server", null);
        }
        if (!PlatformFileUtil.existsFile(gdbserverPath)) {
            LaunchUtils.newCoreException((String)NLS.bind((String)TizenLaunchMessages.GDBSERVER_NOT_INSTALLED, (Object)device.getDeviceName()), null);
        }
        PlatformLaunchUtil.copyFileToDevice(cmdTarget.getRootstrap(), device, gdbserverPath, TizenPlatformConstants.GDBSERVER_PLATFORM_CMD);
        device.executeShellCommand(String.format("chmod +x %s", TizenPlatformConstants.GDBSERVER_PLATFORM_CMD));
    }

    public static void copyFileToDevice(PlatformRootstrap rootstrap, IDevice device, String srcPath, String descPath) throws CoreException, TimeoutException, SdbCommandRejectedException, IOException {
        boolean result = PlatformInstances.getLaunchCommandUtil().copyFileToDevice(rootstrap, device, srcPath, descPath);
        if (!result) {
            String msg = String.valueOf(TizenLaunchMessages.CANNOT_TRANSFER_FILE) + "[gdbserver] Emulator or device launching maybe is not completed. " + "Please try debugging again after a while.";
            DialogUtil.openErrorDialog((Shell)PlatformLaunchUtil.getAvaiableShell(), (String)"Error", (String)msg);
            LaunchUtils.newCoreException((String)TizenLaunchMessages.CANNOT_TRANSFER_FILE, null);
        }
    }

    public static boolean checkGdbServerInDevice(IDevice device, TizenLaunchCommand command) throws CoreException {
        String resultCommand = String.valueOf(TizenPlatformConstants.GDBSERVER_PLATFORM_CMD) + " --version" + "; echo $?;";
        try {
            command.run(resultCommand, "0");
        }
        catch (TizenNativeException e) {
            logger.error("failed to check gdb-Server in Device", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error("failed to check gdb-Server in Device", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean checkGdbServerInBuildSystem(String rootstrapPath) {
        IPath path = new Path(rootstrapPath).append("usr").append("bin").append("gdbserver");
        File gdbserver = new File(path.toOSString());
        return gdbserver.exists();
    }

    public static String[] getProgramPath(IProject project) {
        IPlatformXMLStore store = PlatformProjectUtil.getManifestXmlStore(project);
        if (store.loadXml()) {
            return PlatformLaunchUtil.getProgramPath(store);
        }
        return null;
    }

    public static String[] getProgramPath(IPlatformXMLStore store) {
        List<String> files = store.getExecutableFiles();
        if (files != null && files.size() > 0) {
            return files.toArray(new String[0]);
        }
        return null;
    }

    public static String[] getAppId(IProject project) {
        IPlatformXMLStore store = PlatformProjectUtil.getManifestXmlStore(project);
        if (store.loadXml()) {
            return PlatformLaunchUtil.getAppId(store);
        }
        return null;
    }

    public static String getAppId(IProject project, String programPath) {
        IPlatformXMLStore store = PlatformProjectUtil.getManifestXmlStore(project);
        if (store.loadXml()) {
            return PlatformLaunchUtil.getAppId(store, programPath);
        }
        return null;
    }

    public static String[] getAppId(IPlatformXMLStore store) {
        return store.getAppId();
    }

    public static String getAppId(IPlatformXMLStore store, String programPath) {
        return store.getAppId(programPath);
    }

    public static boolean questionPackaging(IProject project) {
        String msg = String.format(resources.getString("Question.packaging"), new Object[0]);
        return 64 == DialogUtil.openQuestionDialog((String)msg);
    }

    public static boolean questionContinue() {
        return 64 == DialogUtil.openQuestionDialog((String)resources.getString("Question.continue"));
    }

    public static FileEntry selectRemoteFile(Shell shell, String title) {
        return PlatformLaunchUtil.selectRemoteFile(shell, title, "/opt/apps");
    }

    public static FileEntry selectRemoteFile(Shell shell, String title, String defaultPath) {
        FileEntry selectedFile = null;
        if (shell != null) {
            TizenRemoteFileDialog dlg;
            IDevice device = PlatformLaunchUtil.getDefaultLaunchTarget();
            if (device == null) {
                MessageBox msgBox = new MessageBox(shell, 2);
                msgBox.setMessage(TizenLaunchMessages.CANNOT_CONNECT_TO_DEVICE);
                msgBox.open();
                return null;
            }
            if (defaultPath == null || defaultPath.isEmpty()) {
                defaultPath = device.getAppInstallPath();
            }
            if ((dlg = new TizenRemoteFileDialog(shell, title, device, false, String.valueOf(defaultPath) + "/")).open() == TizenRemoteFileDialog.TizenRemoteFileDialogResult.OK) {
                selectedFile = dlg.getSelectedFileEntry();
            }
        }
        return selectedFile;
    }

    public static IDevice getDefaultLaunchTarget() {
        IDevice device = null;
        DeviceDescriptor deviceDescriptor = ConnectionPlugin.getDefault().getTargetToolBarManager().getDefaultDeviceDescriptor();
        if (deviceDescriptor != null) {
            device = deviceDescriptor.getIDevice();
        }
        return device;
    }

    public static IDevice getDefaultLaunchTarget(IProject platformProject) {
        IDevice device = null;
        try {
            device = ConnectionPlugin.getDefault().getTargetToolBarManager().getDefaultLaunchTarget(platformProject);
        }
        catch (CoreException coreException) {
            logger.info("Launch is going to stop because default target is not ready");
        }
        return device;
    }

    public static String changeCommand(String cmd, String prevId, String prevExec, String newId, String newExec) {
        boolean changedExec = false;
        boolean changedId = false;
        if (!prevExec.equals(newExec) && cmd.contains(prevExec)) {
            cmd = cmd.replaceAll(prevExec, TEMP_STRING_EXEC);
            changedExec = true;
        }
        if (!prevId.equals(newId) && cmd.contains(prevId)) {
            cmd = cmd.replaceAll(prevId, TEMP_STRING_ID);
            changedId = true;
        }
        if (changedExec) {
            cmd = cmd.replaceAll(TEMP_STRING_EXEC, newExec);
        }
        if (changedId) {
            cmd = cmd.replaceAll(TEMP_STRING_ID, newId);
        }
        if (changedId || changedExec) {
            return cmd;
        }
        return null;
    }

    public static String findIP(String in) {
        Matcher m = Pattern.compile("((\\d+\\.){3}\\d+):(\\d+)").matcher(in);
        if (m.find()) {
            String[] p = m.group(1).split("\\.");
            int i = 0;
            while (i < 4) {
                if (Integer.parseInt(p[i]) > 255) {
                    return null;
                }
                ++i;
            }
            if (Integer.parseInt(m.group(3)) > 65535) {
                return null;
            }
            return m.group(0);
        }
        return null;
    }

    public static Map<String, String[]> getSmackInfo(IPkgCommander commander, String fileList) {
        HashMap<String, String[]> smackInfo = new HashMap<String, String[]>();
        String[] args = fileList.length() > LIMIT_COMMAND_LENGTH ? CommonBuildCommandUtil.splitCommandArgs(fileList) : new String[]{fileList};
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (!arg.isEmpty()) {
                ICommandStatus status = commander.getSmack(arg);
                if (status == null || !status.isOk()) {
                    logger.error(String.format("Failed to get smack info [%s]", fileList));
                    return null;
                }
                List<String> result = status.getValues();
                if (result == null) {
                    logger.error(String.format("Failed to get smack info [%s]", fileList));
                    return null;
                }
                for (String line : result) {
                    String targetFile = "";
                    String[] labels = new String[]{"", ""};
                    String[] stringArray2 = line.split(" ");
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String info = stringArray2[n4];
                        if (info.startsWith("access=")) {
                            String[] a_label = info.split("=");
                            if (a_label.length == 2) {
                                labels[0] = a_label[1].trim();
                            }
                        } else if (info.startsWith("execute")) {
                            String[] e_label = info.split("=");
                            if (e_label.length == 2) {
                                labels[1] = e_label[1].trim();
                            }
                        } else {
                            targetFile = info;
                        }
                        ++n4;
                    }
                    if (targetFile.isEmpty()) {
                        logger.error(String.format("Failed to get smack info [%s]", fileList));
                        return null;
                    }
                    smackInfo.put(targetFile, labels);
                }
            }
            ++n2;
        }
        return smackInfo;
    }

    public static IPkgCommander.TOOL getDeviceLocalPkgTool() {
        String tool = DevicePreferencesManager.getDeviceLocalPkgInstallTool();
        if (tool.equals("zypper")) {
            return IPkgCommander.TOOL.ZYPPER;
        }
        if (tool.equals("rpm")) {
            return IPkgCommander.TOOL.RPM;
        }
        return IPkgCommander.TOOL.RPM;
    }

    public static IPkgCommander.TOOL getDeviceRemotePkgTool() {
        String tool = DevicePreferencesManager.getDeviceRemotePkgInstallTool();
        if (tool.equals("zypper")) {
            return IPkgCommander.TOOL.ZYPPER;
        }
        if (tool.equals("rpm")) {
            return IPkgCommander.TOOL.RPM;
        }
        return IPkgCommander.TOOL.ZYPPER;
    }

    public static String getDeviceLocalPkgInstallOp() {
        return DevicePreferencesManager.getDeviceLocalPkgInstallOp();
    }

    public static String getDeviceRemotePkgInstallOp() {
        return DevicePreferencesManager.getDeviceRemotePkgInstallOp();
    }

    public static IPkgCommander.TOOL getRootstrapLocalPkgTool() {
        String tool = RootstrapPreferencesManager.getRootstrapLocalPkgInstallTool();
        if (tool.equals("zypper")) {
            return IPkgCommander.TOOL.ZYPPER;
        }
        if (tool.equals("rpm")) {
            return IPkgCommander.TOOL.RPM;
        }
        return IPkgCommander.TOOL.ZYPPER;
    }

    public static IPkgCommander.TOOL getRootstrapRemotePkgTool() {
        String tool = RootstrapPreferencesManager.getRootstrapRemotePkgInstallTool();
        if (tool.equals("zypper")) {
            return IPkgCommander.TOOL.ZYPPER;
        }
        if (tool.equals("rpm")) {
            return IPkgCommander.TOOL.RPM;
        }
        return IPkgCommander.TOOL.ZYPPER;
    }

    public static String getRootstrapLocalPkgInstallOp() {
        return RootstrapPreferencesManager.getRootstrapLocalPkgInstallOp();
    }

    public static String getRootstrapRemotePkgInstallOp() {
        return RootstrapPreferencesManager.getRootstrapRemotePkgInstallOp();
    }

    public static String getHostIp() {
        String prefIp = PreferencesManager.getHostIp();
        if (!prefIp.isEmpty()) {
            return prefIp;
        }
        try {
            InetAddress hostIp = InetAddress.getLocalHost();
            return hostIp.getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error("failed to get HostIP", (Throwable)e);
            return "";
        }
    }

    public static int getDefaultDebugPort(IDevice currentDevice) {
        int debugPort = 0;
        int debugPortBase = 46100;
        if (currentDevice != null && !currentDevice.isEmulator()) {
            debugPortBase += 100;
        }
        debugPort = debugPortBase;
        while (debugPort < 65535 && !LocalPortChecker.isPortAvailable((int)debugPort)) {
            debugPort += 10;
        }
        if (LocalPortChecker.isPortAvailable((int)debugPort)) {
            return debugPort;
        }
        return -1;
    }
}

