/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeplatform.launcher.wizards.EnvironmentDialog;
import org.tizen.nativeplatform.launcher.wizards.LogTabDialog;
import org.tizen.nativeplatform.launcher.wizards.ShowLogDialog;
import org.tizen.nativeplatform.launcher.wizards.ShowPackageStatusDialog;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.pkg.model.PkgStatus;

public class PlatformCommonLaunchWizard
extends Wizard
implements IPageChangingListener,
IPageChangedListener {
    protected IProject project;
    protected IConfiguration config;
    protected PkgCommandTarget target;
    protected ILaunchConfiguration launchConfig;
    protected Shell shell;
    protected String programPath = "";
    protected String arguments = "";
    protected String selectedApp = "";
    protected Map<String, String> envs;
    protected boolean reinstallOp;
    protected List<IPackage> devicePackages = new ArrayList<IPackage>();
    protected List<IPackage> rootstrapPackages = new ArrayList<IPackage>();
    protected String mode = "";
    protected boolean result;
    protected boolean canFinish = false;
    protected String deviceLog = "";
    protected String rootstrapLog = "";
    protected boolean loadSharedLib = true;

    public PlatformCommonLaunchWizard() {
    }

    public PlatformCommonLaunchWizard(Shell shell, IProject project, IConfiguration config, PkgCommandTarget target, String mode) {
        this.project = project;
        this.config = config;
        this.shell = shell;
        this.target = target;
        this.mode = mode;
        this.setWindowTitle("Launch Configuration");
        this.setNeedsProgressMonitor(true);
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    public PlatformCommonLaunchWizard(Shell shell, ILaunchConfiguration launchConfig, IProject project, IConfiguration config, PkgCommandTarget target, String mode) {
        this.project = project;
        this.config = config;
        this.shell = shell;
        this.target = target;
        this.mode = mode;
        this.launchConfig = launchConfig;
        this.setWindowTitle("Launch Configuration");
        this.setNeedsProgressMonitor(true);
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public void setEnableFinish(boolean value) {
        this.canFinish = value;
    }

    public boolean performFinish() {
        return true;
    }

    public String getProgramPath() {
        return this.programPath;
    }

    public String getArguments() {
        return this.arguments;
    }

    public List<IPackage> getDevicePackage() {
        return this.devicePackages;
    }

    public List<IPackage> getRootstrapPackage() {
        return this.rootstrapPackages;
    }

    public boolean getReinstallOp() {
        return this.reinstallOp;
    }

    public String getSelectedApp() {
        return this.selectedApp;
    }

    public Map<String, String> getEnvironments() {
        return this.envs;
    }

    public boolean loadSharedLibAutomatically() {
        return this.loadSharedLib;
    }

    public void addPages() {
    }

    public void pageChanged(PageChangedEvent event) {
    }

    public void handlePageChanging(PageChangingEvent event) {
    }

    public void cancelChanging(PageChangingEvent event) {
        event.doit = false;
    }

    public void openLogDialog(final String desc, final String log) {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ShowLogDialog dialog = new ShowLogDialog(PlatformCommonLaunchWizard.this.shell, desc, log);
                dialog.open();
            }
        });
    }

    public void openLogTabDialog() {
        if (this.target.getDeviceCommander() != null) {
            this.deviceLog = this.target.getDeviceCommander().getLogs();
        }
        if (this.target.getRootstrapCommander() != null) {
            this.rootstrapLog = this.target.getRootstrapCommander().getLogs();
        }
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                LogTabDialog dialog = new LogTabDialog(PlatformCommonLaunchWizard.this.shell, PlatformCommonLaunchWizard.this.deviceLog, PlatformCommonLaunchWizard.this.rootstrapLog);
                dialog.open();
            }
        });
    }

    public void openSetEnvDialog() {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                EnvironmentDialog dialog = new EnvironmentDialog(PlatformCommonLaunchWizard.this.shell, PlatformCommonLaunchWizard.this.envs);
                if (dialog.open() == 0) {
                    PlatformCommonLaunchWizard.this.envs = dialog.getEnvs();
                }
            }
        });
    }

    public void openErrorDialog(final String error) {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                DialogUtil.openErrorDialog((String)error);
            }
        });
    }

    public boolean openPkgStatusDialog(final List<PkgStatus> BuildSystemPkgStatus, final List<PkgStatus> DevicePkgStatus) {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ShowPackageStatusDialog statusDlg = new ShowPackageStatusDialog(PlatformCommonLaunchWizard.this.shell, BuildSystemPkgStatus, DevicePkgStatus);
                PlatformCommonLaunchWizard.this.result = statusDlg.open() == 0;
            }
        });
        return this.result;
    }
}

