/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.util.PlatformProjectUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.util.DeviceUtil;

public class DeviceChangeListener
implements IDeviceChangeListener {
    protected final Logger logger = LoggerFactory.getLogger(DeviceChangeListener.class);

    public void onConnected(IDevice device) {
        if (!DeviceUtil.isOnline((IDevice)device)) {
            return;
        }
        PkgCommandTarget target = new PkgCommandTarget(PlatformProjectUtil.getPkgType(), device);
        try {
            device.becomeSuperUser(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Failed to root on device");
        }
        target.getDeviceCommander().actionBeforeUsingZypper();
    }

    public void onDisconnected(IDevice device) {
    }

    public void onChanged(IDevice device, int changeMask) {
    }
}

