/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.tools;

public class RpmTool {
    public static final String NAME = "rpm";
    public static final String PATH = "/bin/rpm";
    private static final String TOOL = "rpm";
    private static final String WS = " ";
    private static final String UNINSTALL_OP = "--erase";
    private static final String INSTALL_OP = "--install";
    private static final String VERBOSE_OP = "--verbose";
    private static final String HASH_OP = "--hash";
    private static final String IGNOREOS_OP = "--ignoreos";
    private static final String FORCE_OP = "--force";
    private static final String NODEPS_OP = "--nodeps";
    private static final String IGNOREARCH_OP = "--ignorearch";
    private static final String WHATPROVIDE_OP = "--whatprovides";
    private static final String UPGRADE_OP = "--upgrade";
    private static final String OLDPKG_OP = "--oldpackage";
    private static final String QUERY_OP = "-q";
    private static final String QUERY_PKGLIST_OP = "-qa";
    private static final String QUERY_PKGINFO_OP = "-qi";
    private static final String QUERY_RPMFILE_INFO_OP = "-qp";
    private static final String QUERY_FILELIST_OP = "-ql";
    private static final String QUERY_INFO_TAG_OP = "--qf";
    private static final String QUERY_REQUIRES = "--requires";
    private static final String TAG_ARCH = "%{ARCH},";
    private static final String TAG_NAME = "%{NAME},";
    private static final String TAG_FULL_VER = "%{VERSION}-%{RELEASE},";
    private static final String TAG_VER = "%{VERSION}";
    private static final String TAG_RELEASE_VER = "%{RELEASE}";
    public static final String TITLE_NAME = "Name";
    public static final String TITLE_VERSION = "Version";
    public static final String TITLE_RELEASE = "Release";
    public static final String TITLE_ARCH = "Architecture";
    public static final String TITLE_VENDOR = "Vendor";
    public static final String TITLE_SIZE = "Size";
    public static final String TITLE_SUMMARY = "Summary";
    public static final String TITLE_DESC = "Description";
    public static final String TITLE_REQUIRES = "Requires";
    public static final String TITEL_SRC_RPM = "Source RPM";

    public static String getInstallCommandFormat() {
        StringBuffer command = new StringBuffer();
        command.append(INSTALL_OP).append(WS);
        command.append(HASH_OP).append(WS);
        command.append(VERBOSE_OP).append(WS);
        command.append(UPGRADE_OP).append(WS);
        command.append(FORCE_OP).append(WS);
        command.append(NODEPS_OP).append(WS);
        command.append("%s");
        return command.toString();
    }

    public static String installCommand(String commandFormat, String[] list) {
        StringBuffer sbFiles = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbFiles.append(String.valueOf(s) + WS);
            ++n2;
        }
        String files = sbFiles.toString().trim();
        String options = String.format(commandFormat, files);
        return "/bin/rpm " + options;
    }

    public static String installCommand(String[] list) {
        StringBuffer sbFiles = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbFiles.append(String.valueOf(s) + WS);
            ++n2;
        }
        String files = sbFiles.toString().trim();
        return RpmTool.makeCommand(INSTALL_OP, HASH_OP, VERBOSE_OP, IGNOREOS_OP, FORCE_OP, NODEPS_OP, IGNOREARCH_OP, files);
    }

    public static String uninstallCommand(String[] list) {
        StringBuffer sbPkgs = new StringBuffer();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sbPkgs.append(String.valueOf(s) + WS);
            ++n2;
        }
        String pkgs = sbPkgs.toString().trim();
        return RpmTool.makeCommand(UNINSTALL_OP, NODEPS_OP, pkgs);
    }

    public static String pkgListCommand() {
        return RpmTool.makeCommand(QUERY_PKGLIST_OP);
    }

    public static String pkgListCommand(String pkg) {
        return RpmTool.makeCommand(QUERY_PKGLIST_OP, pkg);
    }

    public static String pkgInfoCommand(String pkg) {
        return RpmTool.makeCommand(QUERY_PKGINFO_OP, pkg);
    }

    public static String pkgRequiresCommand(String pkg) {
        return RpmTool.makeCommand(QUERY_OP, QUERY_REQUIRES, pkg);
    }

    public static String installedFileListCommand(String pkg) {
        return RpmTool.makeCommand(QUERY_FILELIST_OP, pkg);
    }

    public static String fileInfoByTagCommand(String tag, String file) {
        return RpmTool.makeCommand(QUERY_RPMFILE_INFO_OP, QUERY_INFO_TAG_OP, tag, file);
    }

    public static String aPkgInfoByTagCommand(String tag, String pkg) {
        return RpmTool.makeCommand(QUERY_OP, QUERY_INFO_TAG_OP, tag, pkg);
    }

    public static String pkgInfoByTagCommand(String tag, String pkg) {
        return RpmTool.makeCommand(QUERY_PKGLIST_OP, QUERY_INFO_TAG_OP, tag, pkg);
    }

    public static String pkgListByTagCommand(String tag) {
        return RpmTool.makeCommand(QUERY_PKGLIST_OP, QUERY_INFO_TAG_OP, tag);
    }

    public static String whatProvideCommand(String capability) {
        return RpmTool.makeCommand(QUERY_PKGINFO_OP, WHATPROVIDE_OP, capability);
    }

    public static String fileArchCommand(String file) {
        return RpmTool.fileInfoByTagCommand(TAG_ARCH, file);
    }

    public static String fileNameCommand(String file) {
        return RpmTool.fileInfoByTagCommand(TAG_NAME, file);
    }

    public static String fileFullVerCommand(String file) {
        return RpmTool.fileInfoByTagCommand(TAG_FULL_VER, file);
    }

    public static String fileVerCommand(String file) {
        return RpmTool.fileInfoByTagCommand(TAG_VER, file);
    }

    public static String fileRelVerCommand(String file) {
        return RpmTool.fileInfoByTagCommand(TAG_RELEASE_VER, file);
    }

    public static String pkgArchCommand(String pkg) {
        return RpmTool.pkgInfoByTagCommand(TAG_ARCH, pkg);
    }

    public static String pkgNameCommand(String pkg) {
        return RpmTool.pkgInfoByTagCommand(TAG_NAME, pkg);
    }

    public static String pkgFullVerCommand(String pkg) {
        return RpmTool.pkgInfoByTagCommand(TAG_FULL_VER, pkg);
    }

    public static String pkgVerCommand(String pkg) {
        return RpmTool.pkgInfoByTagCommand(TAG_VER, pkg);
    }

    public static String pkgRelVerCommand(String pkg) {
        return RpmTool.pkgInfoByTagCommand(TAG_RELEASE_VER, pkg);
    }

    private static String makeCommand(String ... options) {
        StringBuffer sbCommand = new StringBuffer("rpm ");
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            if (!(op = op.trim()).isEmpty()) {
                sbCommand.append(String.valueOf(op) + WS);
            }
            ++n2;
        }
        return sbCommand.toString().trim();
    }
}

