/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.nativeplatform.pkg.model.PkgInfo;
import org.tizen.nativeplatform.pkgmgr.ui.PkgPropertiesDialog;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.repo.model.RepositoryProvider;

public class PkgDependencyTab {
    private TabFolder folder = null;
    private String[] comboItems = new String[]{"Dependencies"};
    private String dependencies = "";
    private Combo cDepends;
    private Text tSummaryValue;
    private final String BUNDLE_NAME = String.valueOf(PkgPropertiesDialog.class.getPackage().getName()) + ".PkgMgrUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    public PkgDependencyTab(Shell shell, TabFolder folder, PkgInfo pkgInfo) {
        this.folder = folder;
        StringBuffer sbDepList = new StringBuffer();
        for (String dep : pkgInfo.getDependencies()) {
            sbDepList.append(" " + dep + "\n");
        }
        this.dependencies = sbDepList.toString();
    }

    protected CopyOnWriteArrayList<Repository> getRepositoryList() {
        return RepositoryProvider.INSTANCE.getBuildsystemRepos();
    }

    public void createTab() {
        this.createCommonTab(this.resources.getString("PropDlg.Tab.Depend"));
    }

    protected void createCommonTab(String title) {
        TabItem tab = new TabItem(this.folder, 0);
        tab.setText(title);
        Composite composite = new Composite((Composite)this.folder, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createInfoComposite(composite);
        tab.setControl((Control)composite);
    }

    private void createInfoComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        GridData gd = new GridData(1808);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gd);
        this.cDepends = new Combo(composite, 8);
        this.cDepends.setLayoutData((Object)new GridData(768));
        this.cDepends.setItems(this.comboItems);
        this.cDepends.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selected = PkgDependencyTab.this.cDepends.getText();
                if (selected.equals(PkgDependencyTab.this.comboItems[0])) {
                    PkgDependencyTab.this.tSummaryValue.setText(PkgDependencyTab.this.dependencies);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tSummaryValue = new Text(composite, 2818);
        gd = new GridData(1808);
        this.tSummaryValue.setLayoutData((Object)gd);
        this.tSummaryValue.setText(this.dependencies);
        this.cDepends.select(0);
    }
}

