/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.osgi.framework.Bundle;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.PackageProvider;
import org.tizen.nativeplatform.pkgmgr.ui.BuildsystemTab;
import org.tizen.nativeplatform.pkgmgr.ui.DeviceTab;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class RPMPackageDialog
extends Dialog {
    private TabFolder tabFolder;
    private PkgCommandTarget target = null;
    private boolean enableRootstrapTab = false;
    private boolean enableDeviceTab = false;
    private int tabIndex = 0;
    private BuildsystemTab rootstrapTab;
    private DeviceTab deviceTab;
    private int x = 0;
    private int y = 0;
    private final int width = 900;
    private final int height = 900;
    private final String BUNDLE_NAME = String.valueOf(RPMPackageDialog.class.getPackage().getName()) + ".PkgMgrUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    public RPMPackageDialog(Shell parentShell, PkgCommandTarget target) {
        super(parentShell);
        this.target = target;
        if (target.isSetDevice()) {
            this.enableDeviceTab = true;
            this.setDeviceRootOn();
        }
        if (target.isSetRootstrap()) {
            this.enableRootstrapTab = true;
        }
        Rectangle bounds = parentShell.getBounds();
        this.x = bounds.x + (bounds.width - 900) / 2;
        this.y = bounds.y + (bounds.height - 900) / 2;
    }

    private void setDeviceRootOn() {
        IDevice device = this.target.getDevice();
        if (!device.isRoot()) {
            try {
                device.becomeSuperUser(true);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (SdbCommandRejectedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setImage(Shell parentShell) {
        Bundle bundle = Platform.getBundle((String)"org.tizen.nativeplatform");
        try {
            parentShell.setImage(new Image((Device)Display.getCurrent(), FileLocator.toFileURL((URL)bundle.getEntry("icons/package_installer.gif")).getPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setShellStyle(int newShellStyle) {
        int newStyle = newShellStyle;
        super.setShellStyle(newStyle |= 0);
    }

    public boolean close() {
        Job job = new Job("Finalizing"){

            protected IStatus run(IProgressMonitor monitor) {
                int works = 0;
                if (RPMPackageDialog.this.enableRootstrapTab) {
                    ++works;
                }
                if (RPMPackageDialog.this.enableDeviceTab) {
                    ++works;
                }
                monitor.beginTask(RPMPackageDialog.this.resources.getString("PkgMgr.Msg.Apply.Changes"), works);
                if (RPMPackageDialog.this.enableRootstrapTab) {
                    RPMPackageDialog.this.rootstrapTab.closeTab();
                    monitor.worked(1);
                }
                if (RPMPackageDialog.this.enableDeviceTab) {
                    RPMPackageDialog.this.deviceTab.closeTab();
                    monitor.worked(1);
                }
                PackageProvider.INSTANCE.clear();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.resources.getString("PkgMgr.Title"));
        if (!this.enableRootstrapTab && !this.enableDeviceTab) {
            newShell.setLocation(this.x, this.y);
            newShell.setSize(450, 225);
            this.setImage(newShell);
        } else {
            newShell.setLocation(this.x, this.y);
            newShell.setSize(900, 900);
            this.setImage(newShell);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(1, false));
        if (!this.enableRootstrapTab && !this.enableDeviceTab) {
            this.createError(container, this.resources.getString("PkgMgr.Error.Noselected"));
        } else {
            this.createDialogDescription(container);
            this.createTabs(container);
        }
        return null;
    }

    private void createError(Composite parent, String message) {
        Composite com = new Composite(parent, 0);
        com.setLayoutData((Object)new GridData(256));
        com.setLayout((Layout)new GridLayout(1, false));
        Label errorLabel = new Label(com, 0);
        errorLabel.setText(message);
    }

    private void createDialogDescription(Composite composite) {
        Composite comp_descrip = new Composite(composite, 2048);
        Color whiteColor = new Color((Device)composite.getDisplay(), 255, 255, 255);
        comp_descrip.setLayout((Layout)new GridLayout(1, false));
        GridData comp_descrip_gd = new GridData(768);
        comp_descrip_gd.heightHint = 30;
        comp_descrip.setLayoutData((Object)comp_descrip_gd);
        comp_descrip.setBackground(whiteColor);
        Label label = new Label(comp_descrip, 0);
        label.setText(this.resources.getString("PkgMgr.Frame.Description"));
        label.setBackground(whiteColor);
    }

    private void createTabs(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.setLayout((Layout)new GridLayout(1, false));
        if (this.enableRootstrapTab) {
            this.rootstrapTab = new BuildsystemTab(this.getShell(), this.tabFolder, this.target);
            this.rootstrapTab.createTab();
        }
        if (this.enableDeviceTab) {
            this.deviceTab = new DeviceTab(this.getShell(), this.tabFolder, this.target);
            this.deviceTab.createTab();
        }
        this.tabFolder.setSelection(this.tabIndex);
    }
}

