/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.pkgmgr.ui.ModifyRepoDialog;
import org.tizen.nativeplatform.repo.commander.RepoManager;

public abstract class RepoCommonDialog
extends Dialog {
    protected Text remoteText;
    protected Text localText;
    protected Button remoteCheckBt;
    protected Button localCheckBt;
    protected Button browseBt;
    protected boolean supportLocalRepo = false;
    protected String type = null;
    protected int x = 0;
    protected int y = 0;
    protected int width = 600;
    protected int height = 300;
    protected final String BUNDLE_NAME = String.valueOf(ModifyRepoDialog.class.getPackage().getName()) + ".PkgMgrUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    protected RepoCommonDialog(Shell parentShell) {
        super(parentShell);
        Rectangle bounds = parentShell.getBounds();
        this.x = bounds.x + (bounds.width - this.width) / 2;
        this.y = bounds.y + (bounds.height - this.height) / 2;
    }

    protected abstract void initControls();

    protected void configureShell(Shell newShell, String title) {
        super.configureShell(newShell);
        newShell.setText(title);
        newShell.setLocation(this.x, this.y);
        if (!this.supportLocalRepo) {
            this.height = 200;
        }
        newShell.setSize(this.width, this.height);
    }

    protected void createRepoComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(770));
        composite.setLayout((Layout)new GridLayout(3, false));
        this.remoteCheckBt = new Button(composite, 16);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.remoteCheckBt.setLayoutData((Object)gridData);
        this.remoteCheckBt.setText(this.resources.getString("AddRepo.Button.Check.Remote"));
        this.remoteCheckBt.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    RepoCommonDialog.this.remoteText.setEnabled(true);
                } else {
                    RepoCommonDialog.this.remoteText.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(this.resources.getString("AddRepo.Label.Uri"));
        this.remoteText = new Text(composite, 2180);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.remoteText.setLayoutData((Object)gridData);
        if (this.supportLocalRepo) {
            this.localCheckBt = new Button(composite, 16);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.localCheckBt.setLayoutData((Object)gridData);
            this.localCheckBt.setText(this.resources.getString("AddRepo.Button.Check.Local"));
            this.localCheckBt.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    Button button = (Button)event.widget;
                    if (button.getSelection()) {
                        RepoCommonDialog.this.localText.setEnabled(true);
                        RepoCommonDialog.this.browseBt.setEnabled(true);
                    } else {
                        RepoCommonDialog.this.localText.setEnabled(false);
                        RepoCommonDialog.this.browseBt.setEnabled(false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Label pathLabel = new Label(composite, 0);
            pathLabel.setText(this.resources.getString("AddRepo.Local.Label.Path"));
            this.localText = new Text(composite, 2180);
            gridData = new GridData(768);
            this.localText.setLayoutData((Object)gridData);
            this.localText.setEditable(false);
            this.browseBt = new Button(composite, 0);
            this.browseBt.setText(this.resources.getString("AddRepo.Button.Browse"));
            this.browseBt.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(RepoCommonDialog.this.getShell());
                    dialog.setText(RepoCommonDialog.this.resources.getString("AddRepo.DirDlg.Title"));
                    String repoPath = dialog.open();
                    if (repoPath == null) {
                        return;
                    }
                    Path path = new Path(repoPath);
                    if (RepoManager.getValidator((IPath)path).validate()) {
                        List<String> archs = RepoManager.getValidator((IPath)path).availableArchs();
                        if (archs == null) {
                            DialogUtil.openErrorDialog((String)RepoCommonDialog.this.resources.getString("AddRepo.Msg.Error.getArch"));
                            return;
                        }
                    } else {
                        DialogUtil.openErrorDialog((String)RepoCommonDialog.this.resources.getString("AddRepo.Msg.Error.NotLocalRepo"));
                        return;
                    }
                    RepoCommonDialog.this.localText.setText(repoPath);
                }

                public void mouseUp(MouseEvent e) {
                }
            });
        }
        this.initControls();
    }

    protected String getRepoType() {
        return this.type;
    }
}

