/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor;

import com.cthing.cmakeed.core.commands.CMakeCommand;
import com.cthing.cmakeed.core.commands.CMakeCommands;
import com.cthing.cmakeed.core.properties.CMakeProperties;
import com.cthing.cmakeed.core.properties.CMakeProperty;
import com.cthing.cmakeed.core.reservedwords.CMakeReservedWord;
import com.cthing.cmakeed.core.reservedwords.CMakeReservedWords;
import com.cthing.cmakeed.core.variables.CMakeVariable;
import com.cthing.cmakeed.core.variables.CMakeVariables;
import com.cthing.cmakeed.ui.editor.EditorUtils;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class CMakeEditorTextHover
implements ITextHover {
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            IRegion wordRegion = this.getWordRegion(textViewer, hoverRegion);
            String word = textViewer.getDocument().get(wordRegion.getOffset(), wordRegion.getLength());
            CMakeCommand cmd = CMakeCommands.getCommand((String)word);
            if (cmd != null) {
                return String.valueOf(cmd.getName()) + ": " + cmd.getDescription();
            }
            CMakeProperty prop = CMakeProperties.getCommand((String)word);
            if (prop != null) {
                return "CMake Property: " + prop.getDescription();
            }
            CMakeReservedWord resword = CMakeReservedWords.getCommand((String)word);
            if (resword != null) {
                return "CMake Reserved Word: " + resword.getName();
            }
            CMakeVariable var = CMakeVariables.getCommand((String)word);
            if (var != null) {
                return "CMake Defined Variable: " + var.getDescription();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public IRegion getWordRegion(ITextViewer viewer, IRegion region) {
        IDocument doc;
        int offset = region.getOffset();
        if (offset >= (doc = viewer.getDocument()).getLength()) {
            return null;
        }
        int startOffset = offset;
        while (!EditorUtils.startOfWord((IDocument)doc, (int)startOffset) && startOffset >= 0) {
            --startOffset;
        }
        int endOffset = offset;
        while (!EditorUtils.startOfWord((IDocument)doc, (int)endOffset) && endOffset < doc.getLength()) {
            ++endOffset;
        }
        Region reg = new Region(startOffset, endOffset - startOffset - 1);
        return reg;
    }
}

