/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizard.pages;

import java.util.ResourceBundle;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchCommonPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformCommonLaunchWizard;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.util.ProcessSelector;
import org.tizen.sdblib.IDevice;

public class PlatformLaunchSettingProcPage
extends PlatformLaunchCommonPage {
    private final String BUNDLE_NAME = String.valueOf(PlatformLaunchSettingProcPage.class.getPackage().getName()) + ".LaunchWizardPageUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private Text processText;
    private Text pidText;
    private Text pathText;
    private IProcessInfo procInfo;
    private PlatformCommonLaunchWizard wizard;
    private IDevice device;

    public PlatformLaunchSettingProcPage(PlatformCommonLaunchWizard wizard, Shell shell, String pageName, IProject project, IConfiguration config, PkgCommandTarget target) {
        super(pageName, shell, project, config, target);
        this.setTitle(this.resources.getString("ProcPage.Title"));
        this.setDescription(this.resources.getString("ProcPage.Desc"));
        this.setPageComplete(true);
        this.wizard = wizard;
        this.device = target.getDevice();
        this.setPlatformPackages();
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 0;
        composite.setLayoutData((Object)gridData);
        this.createProcessComposite(composite);
        this.createProcessInfoComposite(composite);
        this.setControl((Control)composite);
    }

    private void createProcessComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        Label procLabel = new Label(composite, 0);
        procLabel.setText(this.resources.getString("ProcPage.Label.ProcName"));
        this.processText = new Text(composite, 2056);
        this.processText.setLayoutData((Object)gridData);
        Button findBt = new Button(composite, 8);
        findBt.setText(this.resources.getString("ProcPage.Button.Browse"));
        findBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ProcessSelector selector = new ProcessSelector(PlatformLaunchSettingProcPage.this.device);
                PlatformLaunchSettingProcPage.this.procInfo = selector.getProcess(PlatformLaunchSettingProcPage.this.getShell());
                if (PlatformLaunchSettingProcPage.this.procInfo != null) {
                    Path ppath = new Path(PlatformLaunchSettingProcPage.this.procInfo.getName());
                    int pid = PlatformLaunchSettingProcPage.this.procInfo.getPid();
                    String name = ppath.lastSegment().trim();
                    String value = String.valueOf(name) + " [" + String.valueOf(pid) + "]";
                    PlatformLaunchSettingProcPage.this.processText.setText(value);
                    PlatformLaunchSettingProcPage.this.pidText.setText(String.valueOf(pid));
                    PlatformLaunchSettingProcPage.this.pathText.setText(PlatformLaunchSettingProcPage.this.procInfo.getName());
                    PlatformLaunchSettingProcPage.this.wizard.setEnableFinish(true);
                    PlatformLaunchSettingProcPage.this.wizard.getContainer().updateButtons();
                } else {
                    PlatformLaunchSettingProcPage.this.wizard.setEnableFinish(false);
                    PlatformLaunchSettingProcPage.this.wizard.getContainer().updateButtons();
                }
            }
        });
    }

    private void createProcessInfoComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        Label pidPath = new Label(composite, 0);
        pidPath.setText(this.resources.getString("ProcPage.Label.Pid"));
        this.pidText = new Text(composite, 2048);
        this.pidText.setLayoutData((Object)gridData);
        this.pidText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PlatformLaunchSettingProcPage.this.validate();
            }
        });
        Label procPath = new Label(composite, 0);
        procPath.setText(this.resources.getString("ProcPage.Label.ProcPath"));
        this.pathText = new Text(composite, 2048);
        this.pathText.setLayoutData((Object)gridData);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PlatformLaunchSettingProcPage.this.validate();
            }
        });
    }

    public void validate() {
        String pid = this.pidText.getText();
        String path = this.pathText.getText();
        boolean enableFinish = false;
        if (pid.isEmpty() || path.isEmpty()) {
            this.setErrorMessage(this.resources.getString("ProcPage.Desc1"));
            this.wizard.getContainer().updateButtons();
        } else if (!this.validateDigit(pid)) {
            this.setErrorMessage(this.resources.getString("ProcPage.Desc3"));
            this.wizard.getContainer().updateButtons();
        } else {
            this.setErrorMessage(null);
            this.setMessage(this.resources.getString("ProcPage.Desc2"));
            enableFinish = true;
            this.wizard.getContainer().updateButtons();
        }
        this.wizard.setEnableFinish(enableFinish);
        this.wizard.getContainer().updateButtons();
    }

    private boolean validateDigit(String input) {
        char[] chars = new char[input.length()];
        input.getChars(0, chars.length, chars, 0);
        int i = 0;
        while (i < chars.length) {
            if ('0' > chars[i] || chars[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getProgramPath() {
        return this.pathText.getText().trim();
    }

    public int getPid() {
        return Integer.parseInt(this.pidText.getText());
    }

    public String getProcName() {
        String path = this.getProgramPath();
        if (path == null || path.isEmpty()) {
            return "";
        }
        return new Path(path).lastSegment();
    }
}

