/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.core;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.util.RootstrapUtil;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Target;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RootstrapXMLGenerator {
    protected static final String URL_SEP = "|";
    protected static final String ELEMENT_EXTENSION = "extension";
    protected static final String ELEMENT_ROOTSTRAP = "rootstrap";
    protected static final String ELEMENT_PROPERTY = "property";
    protected static final String ATTR_POINT = "point";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_ARCH = "architecture";
    protected static final String ATTR_PATH = "path";
    protected static final String ATTR_VER = "version";
    protected static final String ATTR_TOOLTYPE = "supportToolchainType";
    protected static final String ATTR_KEY = "key";
    protected static final String ATTR_VALUE = "value";
    protected String id = "";
    protected String name = "";
    protected String arch = "";
    protected String version = "";
    protected String path = "";
    protected List<String> repositories;
    protected IPath confFile = null;
    protected boolean isDefault = false;
    protected static final Logger logger = LoggerFactory.getLogger(RootstrapXMLGenerator.class);

    public RootstrapXMLGenerator(String id, String name, String arch, String version, String path, List<String> repositories, IPath confFile, boolean isDefault) {
        this.id = id;
        this.name = name;
        this.arch = arch;
        this.version = version;
        this.path = path;
        this.repositories = repositories;
        this.confFile = confFile;
        this.isDefault = isDefault;
    }

    public RootstrapXMLGenerator(String id, String name, String arch, String version, List<String> repositories, IPath confFile) {
        this.id = id;
        this.name = name;
        this.arch = arch;
        this.version = version;
        this.repositories = repositories;
        this.confFile = confFile;
    }

    public boolean generate() {
        Path pluginPath = new Path(SmartBuildInterface.getInstance().getPluginPath());
        IPath filePath = pluginPath.append(String.valueOf(this.id) + ".xml");
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement(ELEMENT_EXTENSION);
            doc.appendChild(rootElement);
            Attr attr = doc.createAttribute(ATTR_POINT);
            attr.setValue("rootstrapDefinition");
            rootElement.setAttributeNode(attr);
            Element firstnode = doc.createElement(ELEMENT_ROOTSTRAP);
            rootElement.appendChild(firstnode);
            firstnode.setAttribute(ATTR_ID, this.id);
            firstnode.setAttribute(ATTR_NAME, this.name);
            firstnode.setAttribute(ATTR_ARCH, this.arch);
            if (this.path == null || this.path.isEmpty()) {
                firstnode.setAttribute(ATTR_PATH, RootstrapUtil.getUserRootstrapPathOfXml((String)this.name));
            } else {
                firstnode.setAttribute(ATTR_PATH, RootstrapUtil.getRootstrapPathOfXml((String)this.path));
            }
            firstnode.setAttribute(ATTR_TOOLTYPE, "tizen.platform");
            firstnode.setAttribute(ATTR_VER, this.version);
            StringBuffer sbReposURL = new StringBuffer();
            for (String URL2 : this.repositories) {
                if (sbReposURL.length() != 0) {
                    sbReposURL.append(URL_SEP);
                }
                sbReposURL.append(URL2);
            }
            Element secondnode = doc.createElement(ELEMENT_PROPERTY);
            firstnode.appendChild(secondnode);
            secondnode.setAttribute(ATTR_KEY, "REPOSITORY_URLS");
            secondnode.setAttribute(ATTR_VALUE, sbReposURL.toString());
            Element thirdnode = doc.createElement(ELEMENT_PROPERTY);
            firstnode.appendChild(thirdnode);
            thirdnode.setAttribute(ATTR_KEY, "CONFIGURATION_FILE");
            if (this.confFile == null) {
                thirdnode.setAttribute(ATTR_VALUE, "");
            } else {
                thirdnode.setAttribute(ATTR_VALUE, this.confFile.toOSString());
            }
            if (this.isDefault) {
                Element fourthnode = doc.createElement(ELEMENT_PROPERTY);
                firstnode.appendChild(fourthnode);
                fourthnode.setAttribute(ATTR_KEY, "DEFAULT");
                fourthnode.setAttribute(ATTR_VALUE, "true");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new FileOutputStream(new File(filePath.toOSString())));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            logger.error(String.format("Failed to generate XML file: [%s]", e), (Throwable)e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void removeXML(String id) {
        PluginManager pm = PluginManager.getInstance();
        List targetList = pm.getTargetList();
        ArrayList<Target> removeList = new ArrayList<Target>();
        for (Target target : targetList) {
            if (!target.getRootstrapId().equals(id)) continue;
            removeList.add(target);
        }
        for (Target target : removeList) {
            pm.removeTarget(target);
        }
        new File(RootstrapUtil.getPluginXML((String)id)).delete();
    }
}

