/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor.actions;

import com.cthing.cmakeed.ui.CMakeEditorPlugin;
import com.cthing.cmakeed.ui.editor.CMakeEditor;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CMakeEditorUnCommentActionDelegate
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    CMakeEditor editor;

    public void selectionChanged(IAction action, ISelection selection) {
        if (CMakeEditorPlugin.getActiveEditor() instanceof CMakeEditor) {
            this.editor = (CMakeEditor)CMakeEditorPlugin.getActiveEditor();
        }
    }

    public void run(IAction action) {
        IDocument document = this.editor.getCMakeEditorSourceViewer().getDocument();
        ISelection currentSelection = this.editor.getCMakeEditorSourceViewer().getSelection();
        if (currentSelection instanceof ITextSelection) {
            ITextSelection selection = (ITextSelection)currentSelection;
            try {
                int begin = document.getLineOffset(selection.getStartLine());
                int end = document.getLineOffset(selection.getEndLine() + 1);
                StringBuilder sb = new StringBuilder(document.get().substring(0, begin));
                String content = document.get().substring(begin, end);
                LineNumberReader reader = new LineNumberReader(new StringReader(content));
                int charsAdded = 0;
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        String trimmedLine = line.trim();
                        if (trimmedLine.startsWith("#")) {
                            line = line.replaceFirst("#", "");
                            sb.append(line).append('\n');
                            ++charsAdded;
                        } else {
                            sb.append(line).append('\n');
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    CMakeEditorPlugin.logError((Object)this, (Throwable)e);
                }
                sb.append(document.get().substring(end, document.get().length()));
                document.set(sb.toString());
                int length = selection.getLength() - charsAdded;
                if (length < 0) {
                    length = 0;
                }
                TextSelection endSelection = new TextSelection(selection.getOffset(), length);
                this.editor.getSelectionProvider().setSelection((ISelection)endSelection);
            }
            catch (BadLocationException e) {
                CMakeEditorPlugin.logError((Object)this, (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean linesContentCommentChar(String content) {
        if (content.length() == 0) {
            return false;
        }
        LineNumberReader reader = new LineNumberReader(new StringReader(content));
        boolean ret = false;
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return ret;
                }
                if (!line.startsWith("#")) return true;
                ret = false;
            }
        }
        catch (IOException e) {
            CMakeEditorPlugin.logError((Object)this, (Throwable)e);
            return false;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }
}

