/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.nativeplatform.filefilter.RpmFileFilter;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.util.CommonPackageUtil;
import org.tizen.nativeplatform.util.IPackageUtil;
import org.tizen.nativeplatform.util.PackageStoreManager;

public class PackageUtil
implements IPackageUtil {
    public List<IPackage> getPackages(IProject project, IConfiguration config) {
        List cached = PackageStoreManager.get((IProject)project, (IConfiguration)config);
        if (cached != null) {
            return cached;
        }
        ArrayList<String> pkgs = new ArrayList<String>();
        IFolder folder = project.getFolder(config.getName());
        File dir = new File(folder.getLocation().toOSString());
        if (dir.exists()) {
            String[] files;
            String[] stringArray = files = dir.list((FilenameFilter)new RpmFileFilter());
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                IPath pkgPath = new Path(dir.getPath()).append(file);
                pkgs.add(pkgPath.toOSString());
                ++n2;
            }
        }
        List newPkgs = CommonPackageUtil.getPackages(pkgs);
        PackageStoreManager.put((IProject)project, (IConfiguration)config, (List)newPkgs);
        return newPkgs;
    }

    public List<IPackage> getPackages(IProject project, IConfiguration config, String selectedRootstrapArch) {
        List cached = PackageStoreManager.get((IProject)project, (IConfiguration)config);
        if (cached != null) {
            if (((IPackage)cached.get(0)).getArch().equals(selectedRootstrapArch)) {
                return cached;
            }
            return null;
        }
        ArrayList<String> pkgs = new ArrayList<String>();
        IFolder folder = project.getFolder(config.getName());
        File dir = new File(folder.getLocation().toOSString());
        if (dir.exists()) {
            String[] files;
            String[] stringArray = files = dir.list((FilenameFilter)new RpmFileFilter());
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (file.contains(selectedRootstrapArch)) {
                    IPath pkgPath = new Path(dir.getPath()).append(file);
                    pkgs.add(pkgPath.toOSString());
                }
                ++n2;
            }
        }
        if (!pkgs.isEmpty()) {
            List newPkgs = CommonPackageUtil.getPackages(pkgs);
            PackageStoreManager.put((IProject)project, (IConfiguration)config, (List)newPkgs);
            return newPkgs;
        }
        return null;
    }
}

