/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.project.wizard.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.managedbuilder.ui.wizards.ManagedBuildWizard;
import org.eclipse.cdt.ui.wizards.CNewWizard;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mihalis.opal.preferenceWindow.PWTab;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.ui.wizards.TizenCommonNewWizardPage;
import org.tizen.common.ui.wizards.TizenWizardProjectCheckViewer;
import org.tizen.common.ui.wizards.model.Category;
import org.tizen.common.ui.wizards.model.Template;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativeappcommon.templateengine.TizenTemplateProcessParser;
import org.tizen.nativeappcommon.wizards.EntryDescriptorPlatformMap;
import org.tizen.nativeappcommon.wizards.Messages;
import org.tizen.nativeappcommon.wizards.TizenMainWizardPage;
import org.tizen.nativeplatform.preferences.PreferencesManager;
import org.tizen.nativeplatform.project.wizard.git.GitDescManager;
import org.tizen.nativeplatform.project.wizard.git.model.GitDescription;
import org.tizen.nativeplatform.project.wizard.model.TizenPlatformTemplateModel;
import org.tizen.nativeplatform.project.wizard.ui.TemplateTizenPlatformNewWizard;
import org.tizen.nativeplatform.project.wizard.ui.TizenPlatformPWComposite;
import org.tizen.nativeplatform.util.CommonPackageUtil;
import org.w3c.dom.Element;

public class TizenPlatformMainWizardPage
extends TizenMainWizardPage {
    private static final String ROOT_NAME = "TEMPLATE-ROOT";
    protected static final String NAME_PATTERN = "^[a-zA-Z]+[a-zA-Z0-9]{2,49}";
    private final Logger logger = LoggerFactory.getLogger(TizenPlatformMainWizardPage.class);
    private static final String BUNDLE_NAME = String.valueOf(TizenPlatformMainWizardPage.class.getPackage().getName()) + ".WizardUIMessages";
    private static ResourceBundle resources = ResourceBundle.getBundle(BUNDLE_NAME);

    public TizenPlatformMainWizardPage() {
        this("");
    }

    public TizenPlatformMainWizardPage(String pageName) {
        super(pageName);
        this.setNewProjectChecker(new TizenWizardProjectCheckViewer((TizenCommonNewWizardPage)this, this.getErrorReporter()));
    }

    public TizenPlatformMainWizardPage(String pageName, String appType) {
        super(pageName, appType);
        this.setNewProjectChecker(new TizenWizardProjectCheckViewer((TizenCommonNewWizardPage)this, this.getErrorReporter()));
    }

    public Category createTemplateTabModel() {
        this.fModel = new Category(null, ROOT_NAME, null, false);
        new Category(this.fModel, "Template", "template.png");
        this.toolchainComposite = new Composite(this.fComposite, 0);
        SWTUtil.setGridLayoutData((Control)this.toolchainComposite, (int)0, (int)0, (int)-1, (int)-1, (int)0);
        this.initManagedBuildWizardItems();
        UserLogger.start((String)"native.wizard", (String)"native.wizard.model");
        return this.fModel;
    }

    public boolean validatePage() {
        if (!this.projectCheckViewer.validatePage()) {
            return false;
        }
        if (super.validatePage()) {
            String projectName = this.getProjectName();
            TizenPlatformTemplateModel template = this.getSelectedTemplate();
            if (template == null) {
                return false;
            }
            String sampleName = template.getName();
            String category = template.getParentCategory().getName();
            if (CommonPackageUtil.validateProjectName((String)category, (String)projectName)) {
                return true;
            }
            String msg = String.format(resources.getString("WizardPage.GitError.Keyword.Block"), projectName, sampleName);
            this.setErrorMessage(msg);
        }
        return false;
    }

    public TizenPlatformTemplateModel getSelectedTemplate() {
        return (TizenPlatformTemplateModel)((Object)this.fSelectedTemplate);
    }

    protected List<EntryDescriptor> updateData(Composite right, IWizardItemsListListener ls, IWizard wizard) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui.CDTWizard");
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return null;
        }
        List<Object> items = new ArrayList<EntryDescriptor>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extensions[i].getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("wizard")) {
                    int n3;
                    CNewWizard w = null;
                    try {
                        w = (CNewWizard)element.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_2, (Throwable)e);
                    }
                    if (w == null) {
                        return null;
                    }
                    if (w instanceof ManagedBuildWizard) {
                        w.setDependentControl(right, ls);
                        EntryDescriptor[] entryDescriptorArray = w.createItems(true, wizard);
                        n3 = entryDescriptorArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            EntryDescriptor ed = entryDescriptorArray[n4];
                            items.add(ed);
                            ++n4;
                        }
                    } else if (w instanceof TemplateTizenPlatformNewWizard) {
                        EntryDescriptor[] eds;
                        w.setDependentControl(right, ls);
                        EntryDescriptor[] entryDescriptorArray = eds = ((TemplateTizenPlatformNewWizard)w).createItems(true, wizard);
                        int n5 = eds.length;
                        n3 = 0;
                        while (n3 < n5) {
                            EntryDescriptor ed = entryDescriptorArray[n3];
                            items.add(ed);
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            ++i;
        }
        i = 0;
        while (i < items.size()) {
            EntryDescriptor ed = (EntryDescriptor)items.get(i);
            if (ed.isDefaultForCategory()) {
                items.remove(i);
                --i;
            }
            ++i;
        }
        if (ls != null) {
            items = ls.filterItems(items);
        }
        return items;
    }

    protected IPath getTemplatePath() {
        return null;
    }

    private IPath getTemplatePath(ProfileInfo platformInfo) {
        String samplePath = InstallPathConfig.getSamplesPath((ProfileInfo)platformInfo, (String)platformInfo.getLatestPlatformVersion());
        if (samplePath == null) {
            return null;
        }
        return new Path(samplePath).append("platform").append("rpm");
    }

    protected void buildTab(PWTab tab, String name, Category category) {
        TizenPlatformPWComposite pwComposite = new TizenPlatformPWComposite(name, category, this);
        tab.add((PWWidget)pwComposite);
    }

    protected void createModelRootForPlatformProject(List<EntryDescriptor> eds) {
        Hashtable<String, String> testedEntryDescriptors = new Hashtable<String, String>();
        boolean found3 = false;
        try {
            for (EntryDescriptor ed : eds) {
                IPath samplePath;
                File sampleFile;
                if (ed.getParentId() == null) continue;
                boolean found1 = false;
                String tempPath = ed.getPath();
                for (EntryDescriptor ed2 : eds) {
                    if (!ed2.getId().equals(ed.getParentId())) continue;
                    found3 = true;
                    found1 = true;
                    ed.setParentId(null);
                    ed.setPath(String.valueOf(ed2.getId()) + "/" + ed.getId());
                    ed.setParent(ed2);
                    if (ed2.getHandler() != null && testedEntryDescriptors.containsKey(ed.getId()) && ((String)testedEntryDescriptors.get(ed.getId())).equals(ed2.getId())) {
                        ed.setHandler(ed2.getHandler());
                        break;
                    }
                    if (ed2.getHandler() == null || !ed2.getHandler().isApplicable(ed)) break;
                    testedEntryDescriptors.put(ed.getId(), ed2.getId());
                    ed.setHandler(ed2.getHandler());
                    break;
                }
                if (!found1) continue;
                List<Object> categories = null;
                IPath descPath = null;
                ProfileInfo platformInfo = EntryDescriptorPlatformMap.getInstance().get(ed);
                if (platformInfo == null) continue;
                if (tempPath == null) {
                    categories = new ArrayList<String>();
                    categories.add(this.DEFAULT_TAB);
                    categories.add("Other");
                    descPath = this.getTemplatePath(InstallPathConfig.getLatestProfileInfo()).append(ed.getName());
                } else {
                    categories = Arrays.asList(tempPath.split("/"));
                    IPath templatePath = this.getTemplatePath(platformInfo);
                    if (templatePath != null) {
                        descPath = templatePath.append(tempPath).append(ed.getName());
                    }
                }
                if (((String)categories.get(0)).equals("Git") && tempPath != null) {
                    descPath = new Path(String.valueOf(tempPath.substring(17)) + "/" + ed.getName());
                    PreferencesManager.SiteConfiguration config = PreferencesManager.loadActiveSiteConfiguration();
                    GitDescription desc = null;
                    if (config != null) {
                        String siteConfigName = config.getName();
                        desc = GitDescManager.getDesc(siteConfigName, descPath.toString());
                    }
                    Category entry = this.addChildEntry(this.fModel, platformInfo, categories);
                    TizenPlatformTemplateModel template2 = new TizenPlatformTemplateModel(platformInfo, ed.getName(), ed, null, null, null, desc, "Platform Git");
                    entry.addTemplate((Template)template2);
                    continue;
                }
                if (descPath == null || !(sampleFile = (samplePath = descPath.append("sample.xml")).toFile()).exists()) continue;
                TemplateDescriptor templateDesc = TizenTemplateProcessParser.createTemplateDesc((File)sampleFile);
                Element root = templateDesc.getRootElement();
                Element slpPropertyElement = TizenTemplateProcessParser.getElementFromTag((Element)root, (String)"slp-property");
                slpPropertyElement = TizenTemplateProcessParser.getElementFromTag((Element)slpPropertyElement, (String)"property-group");
                String projDesc = TizenTemplateProcessParser.getTextContextFromElement((Element)slpPropertyElement, (String)"sample-description");
                String label = TizenTemplateProcessParser.getTextContextFromElement((Element)slpPropertyElement, (String)"sample-name");
                String icon = TizenTemplateProcessParser.getTextContextFromElement((Element)slpPropertyElement, (String)"wizard-icon");
                String category = TizenTemplateProcessParser.getTextContextFromElement((Element)slpPropertyElement, (String)"category");
                Category entry = this.addChildEntry(this.fModel, platformInfo, categories);
                IPath iconPath = icon != null ? descPath.append(icon) : null;
                descPath = projDesc != null ? descPath.append(projDesc) : this.getTemplatePath().append("description.xml");
                TizenPlatformTemplateModel template = new TizenPlatformTemplateModel(platformInfo, label, ed, descPath, samplePath, iconPath, null, category);
                entry.addTemplate((Template)template);
            }
            if (!found3) {
                this.logger.error(Messages.EXCEPTION_WHILE_PROJECT_CREATION_1);
            }
        }
        finally {
            EntryDescriptorPlatformMap.getInstance().remove();
        }
    }

    public TizenPlatformTemplateModel getLastSelectedTemplate() {
        return this.getSelectedTemplate();
    }

    public TizenWizardProjectCheckViewer.IErrorMessageReporter getErrorReporter() {
        return new TizenWizardProjectCheckViewer.IErrorMessageReporter(){

            public void reportError(String errorMessage, boolean infoOnly) {
                boolean valid;
                if (infoOnly) {
                    TizenPlatformMainWizardPage.this.setMessage(errorMessage, 1);
                    TizenPlatformMainWizardPage.this.setErrorMessage(null);
                } else {
                    TizenPlatformMainWizardPage.this.setErrorMessage(errorMessage);
                }
                boolean bl = valid = errorMessage == null;
                if (valid) {
                    valid = TizenPlatformMainWizardPage.this.validatePage();
                }
                TizenPlatformMainWizardPage.this.setPageComplete(valid);
            }
        };
    }
}

