/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.preferences.ui;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeplatform.pkg.tools.RpmTool;
import org.tizen.nativeplatform.pkg.tools.ZypperTool;
import org.tizen.nativeplatform.preferences.PreferencesManager;

public class RootstrapPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor localPkgInstallOpField;
    private StringFieldEditor remotePkgInstallOpField;

    public void init(IWorkbench workbench) {
        IPreferenceStore store = PreferencesManager.getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription("Rootstrap configuration");
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        SWTUtil.createSpacer((Composite)composite, (int)1);
        this.createLocalPackageToolComposite(composite);
        SWTUtil.createSpacer((Composite)composite, (int)1);
        this.createRemotePackageToolComposite(composite);
    }

    private void createLocalPackageToolComposite(Composite parent) {
        Group comp = SWTUtil.createGroup((Composite)parent, (String)"Local Package Install Command", (int)1);
        Composite formatComposite = SWTUtil.createCompositeEx((Composite)comp, (int)1, (int)768);
        RadioGroupFieldEditor pkgToolField = new RadioGroupFieldEditor("rootstrap.local.pkg.install.tool", "Tool:", 2, (String[][])new String[][]{{"ZYPPER", "zypper"}, {"RPM", "rpm"}}, formatComposite);
        this.addField((FieldEditor)pkgToolField);
        this.localPkgInstallOpField = new StringFieldEditor("rootstrap.local.pkg.install.op", "Install option:", formatComposite);
        this.addField((FieldEditor)this.localPkgInstallOpField);
    }

    private void createRemotePackageToolComposite(Composite parent) {
        Group comp = SWTUtil.createGroup((Composite)parent, (String)"Remote Package Install Command", (int)1);
        Composite formatComposite = SWTUtil.createCompositeEx((Composite)comp, (int)1, (int)768);
        RadioGroupFieldEditor pkgToolField = new RadioGroupFieldEditor("rootstrap.remote.pkg.install.tool", "Tool:", 2, (String[][])new String[][]{{"ZYPPER", "zypper"}}, formatComposite);
        this.addField((FieldEditor)pkgToolField);
        this.remotePkgInstallOpField = new StringFieldEditor("rootstrap.remote.pkg.install.op", "Install option:", formatComposite);
        this.addField((FieldEditor)this.remotePkgInstallOpField);
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor editor;
        String prefName;
        if (event.getSource() instanceof FieldEditor && (prefName = (editor = (FieldEditor)event.getSource()).getPreferenceName()).equals("rootstrap.local.pkg.install.tool")) {
            if (event.getNewValue().equals("rpm")) {
                this.localPkgInstallOpField.setStringValue(RpmTool.getInstallCommandFormat());
            } else if (event.getNewValue().equals("zypper")) {
                this.localPkgInstallOpField.setStringValue(ZypperTool.getLocalInstallCommandFormat());
            }
        }
        super.propertyChange(event);
    }
}

