/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.tizen.nativeplatform.IPlatformProject;
import org.tizen.nativeplatform.IPlatformXMLStore;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.manifest.PlatformManifestXMLStore;
import org.tizen.nativeplatform.types.PkgTypes;

public class PlatformProjectUtil {
    public static IPlatformProject getTizenPlatformProject(IProject project, Class adapter) {
        if (project == null) {
            throw new IllegalArgumentException("Project can not be null");
        }
        Object obj = project.getAdapter(adapter);
        if (obj == null || !(obj instanceof IPlatformProject)) {
            throw new IllegalArgumentException("Project can not be adapted (obj - " + obj + ", adapter - " + adapter + ")");
        }
        return (IPlatformProject)obj;
    }

    public static boolean isTizenPlatformProject(IProject project) {
        IPlatformProject adapter = PlatformProjectUtil.getTizenPlatformProject(project, IPlatformProject.class);
        return adapter.getTizenProjectType() == null ? false : adapter.getTizenProjectType().isPlatformProject();
    }

    public static boolean isEFLApplication(IProject project) {
        if (PlatformProjectUtil.isTizenPlatformProject(project)) {
            IPlatformProject adapter = PlatformProjectUtil.getTizenPlatformProject(project, IPlatformProject.class);
            return adapter.getTizenProjectType() == null ? false : adapter.isEFLApplication();
        }
        return false;
    }

    public static IPlatformXMLStore getManifestXmlStore(IProject project) {
        PlatformManifestXMLStore store = new PlatformManifestXMLStore();
        store.setProject(project);
        return store;
    }

    public static PkgTypes getPkgType() {
        return PlatformInstances.getBuildCommandUtil(null).getPkgType();
    }

    public static IProject getProjectInstance(String projectName) {
        IWorkspace works = ResourcesPlugin.getWorkspace();
        IProject[] projs = works.getRoot().getProjects();
        IProject result = null;
        IProject[] iProjectArray = projs;
        int n = projs.length;
        int n2 = 0;
        while (n2 < n) {
            IManagedProject managedProject;
            IConfiguration cfg;
            IProject p = iProjectArray[n2];
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)p);
            if (info != null && (cfg = info.getDefaultConfiguration()) != null && (managedProject = cfg.getManagedProject()) != null) {
                String projectArtifactType;
                String string = projectArtifactType = managedProject.getProjectType() != null ? managedProject.getProjectType().getBuildArtefactType().getId() : null;
                if (projectArtifactType != null && projectArtifactType.equals("org.tizen.nativeide.buildArtefactType.platform") && projectName.equals(p.getName())) {
                    result = p;
                    break;
                }
            }
            ++n2;
        }
        return result;
    }
}

