/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.commander.rpm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativeplatform.command.launcher.DeviceCommandLauncher;
import org.tizen.nativeplatform.command.launcher.LaunchCommandCancelThread;
import org.tizen.nativeplatform.pkg.commander.CommandStatus;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.executor.DeviceExecutor;
import org.tizen.nativeplatform.pkg.commander.executor.Executor;
import org.tizen.nativeplatform.pkg.commander.rpm.RpmCommanderCommon;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.pkg.tools.PkgcmdTool;
import org.tizen.nativeplatform.pkg.tools.RpmTool;
import org.tizen.nativeplatform.pkg.tools.ZypperTool;
import org.tizen.nativeplatform.pkgmgr.PackageManagerOutputReceiver;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

public class RpmCommanderDevice
extends RpmCommanderCommon {
    protected static final String PROCESS_GET_PROCESS_ID_COMMAND = String.valueOf(TizenPlatformConstants.SDK_ROOT_COMMAND) + " process | grep '%s' | grep -v grep | awk '{print $1}'";
    protected static final String CONSOLE_NAME = "Device Internal";
    protected static final String CMD_CHANGE_UPDATEMODE = "/bin/change-booting-mode.sh --update";
    protected static final String CMD_ACTION_FOR_USING_ZYPPER = "sed -i \"s/# arch = s390/arch = i686/g\" /etc/zypp/zypp.conf";
    protected static final String ZYPPER_CONF_FILE = "/etc/zypp/zypp.conf";
    protected final CmdTargetTypes CMD_TYPE = CmdTargetTypes.DEVICE;
    protected IDevice device;

    public RpmCommanderDevice(IDevice device, boolean useConsoleLog) {
        super(useConsoleLog, CONSOLE_NAME);
        this.device = device;
    }

    public RpmCommanderDevice(IDevice device) {
        super(CONSOLE_NAME);
        this.device = device;
    }

    @Override
    public ICommandStatus copyFile(String srcPath, String dstPath) {
        SyncService syncService;
        ArrayList<String> value = new ArrayList<String>();
        Path pathOnDevice = new Path(dstPath);
        try {
            syncService = this.device.getSyncService();
        }
        catch (TimeoutException e) {
            return new CommandStatus(4, "", e.getMessage(), e);
        }
        catch (SdbCommandRejectedException e) {
            return new CommandStatus(4, "", e.getMessage(), e);
        }
        catch (IOException e) {
            return new CommandStatus(4, "", e.getMessage(), e);
        }
        SyncResult syncResult = syncService.push(srcPath, this.device.getFileEntry(pathOnDevice.removeLastSegments(1).toString()));
        if (!syncResult.isOk()) {
            return new CommandStatus(4, "", syncResult.getMessage(), null);
        }
        value.add(pathOnDevice.toString());
        this.printResultLog(String.format("[RDS] Copied file: %s \n -> %s", srcPath, dstPath));
        return new CommandStatus(0, value, null);
    }

    @Override
    public boolean existsFile(String file) {
        boolean ret = false;
        String command = String.format("ls %s 2>/dev/null", file);
        PackageManagerOutputReceiver hrec = this.getNewOuputReceiver();
        DeviceExecutor executor = new DeviceExecutor(command, null);
        executor.setIsPrintCommand(true);
        executor.setIsRoot(true);
        ICommandStatus status = this.execute(executor, hrec);
        if (status == null || !status.isOk()) {
            return ret;
        }
        List<String> value = status.getValues();
        if (value != null) {
            for (String s : value) {
                if (!s.trim().equals(file)) continue;
                ret = true;
                break;
            }
        }
        if (ret) {
            this.printResultLog(String.format("Checked file: %s", file));
        } else {
            this.printResultLog(String.format("Failed to check file: %s", file));
        }
        return ret;
    }

    @Override
    public ICommandStatus copyFilesToTmpDir(String[] fileList) {
        ArrayList<String> value = new ArrayList<String>();
        String[] stringArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            SyncService syncService;
            String filePath = stringArray[n2];
            String filename = new File(filePath).getName();
            IPath pathOnDevice = new Path("/tmp").append(filename);
            try {
                syncService = this.device.getSyncService();
            }
            catch (TimeoutException e) {
                return new CommandStatus(4, "", e.getMessage(), e);
            }
            catch (SdbCommandRejectedException e) {
                return new CommandStatus(4, "", e.getMessage(), e);
            }
            catch (IOException e) {
                return new CommandStatus(4, "", e.getMessage(), e);
            }
            SyncResult syncResult = syncService.push(filePath, this.device.getFileEntry("/tmp"));
            if (!syncResult.isOk()) {
                return new CommandStatus(4, "", String.valueOf(filePath) + ": " + syncResult.getMessage(), null);
            }
            value.add(pathOnDevice.toString());
            ++n2;
        }
        return new CommandStatus(0, value, null);
    }

    @Override
    public ICommandStatus installRemotePkg(String[] pkgs, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        ICommandStatus status = null;
        IPkgCommander.TOOL type = PlatformLaunchUtil.getDeviceRemotePkgTool();
        String option = PlatformLaunchUtil.getDeviceRemotePkgInstallOp();
        if (type == IPkgCommander.TOOL.ZYPPER) {
            String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.installRemoteCommand(option, pkgs));
            status = this.execute(command, monitor);
        }
        if (monitor != null) {
            monitor.worked(1);
            monitor.done();
        }
        return status;
    }

    @Override
    public ICommandStatus installLocalPkg(String[] files, String tool, IProgressMonitor monitor) {
        List<String> value;
        UserLogger.start((String)"copy.pkg");
        ICommandStatus status = this.copyFilesToTmpDir(files);
        if (status == null) {
            return null;
        }
        if (!status.isOk()) {
            this.logger.error(status.getMessage(), status.getException());
            return status;
        }
        UserLogger.end((String)"copy.pkg");
        if (tool == null || tool.isEmpty()) {
            tool = "rpm";
        }
        if ((value = status.getValues()) != null && value.size() > 0) {
            UserLogger.start((String)"install.pkg");
            String command = "";
            String option = "";
            if (tool.equals("rpm")) {
                option = RpmTool.getInstallCommandFormat();
                command = this.makeCommand(this.getResetRpmDb(), RpmTool.installCommand(option, value.toArray(new String[0])));
                status = this.execute(command, 50000, monitor);
            } else if (tool.equals("pkgcmd")) {
                option = PkgcmdTool.getInstallCommandFormat();
                for (String pkg : value) {
                    command = this.makeCommand(this.getResetRpmDb(), PkgcmdTool.installCommand(option, pkg));
                    status = this.execute(command, 50000, monitor);
                }
            } else if (tool.equals("zypper")) {
                option = ZypperTool.getLocalInstallCommandFormat();
                command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.installLocalCommand(option, value.toArray(new String[0])));
                status = this.execute(command, 50000, monitor);
            }
            UserLogger.end((String)"install.pkg");
        }
        if (monitor != null) {
            monitor.worked(1);
            monitor.done();
        }
        return status;
    }

    @Override
    public ICommandStatus installLocalPkg(String[] files, boolean isEfl, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        UserLogger.start((String)"copy.pkg");
        ICommandStatus status = this.copyFilesToTmpDir(files);
        if (status == null) {
            return null;
        }
        if (!status.isOk()) {
            this.logger.error(status.getMessage(), status.getException());
            return status;
        }
        UserLogger.end((String)"copy.pkg");
        IPkgCommander.TOOL type = PlatformLaunchUtil.getDeviceLocalPkgTool();
        String option = PlatformLaunchUtil.getDeviceLocalPkgInstallOp();
        List<String> value = status.getValues();
        if (value != null && value.size() > 0) {
            UserLogger.start((String)"install.pkg");
            if (type == IPkgCommander.TOOL.RPM) {
                String command = this.makeCommand(this.getResetRpmDb(), RpmTool.installCommand(option, value.toArray(new String[0])));
                status = this.execute(command, 50000, monitor);
            } else if (type == IPkgCommander.TOOL.ZYPPER) {
                String command = this.makeCommand(this.getProxyCommand(), this.getResetRpmDb(), ZypperTool.installLocalCommand(option, value.toArray(new String[0])));
                status = this.execute(command, 50000, monitor);
            } else if (type == IPkgCommander.TOOL.PKGCMD) {
                for (String pkg : value) {
                    String command = this.makeCommand(this.getResetRpmDb(), PkgcmdTool.installCommand(option, pkg));
                    status = this.execute(command, 50000, monitor);
                }
            }
            UserLogger.end((String)"install.pkg");
        }
        if (monitor != null) {
            monitor.worked(1);
            monitor.done();
        }
        return status;
    }

    @Override
    public ICommandStatus getMd5Checksum(String path) {
        String command = String.format("md5sum %s", path);
        ICommandStatus status = this.execute(command, null, false, false);
        if (status.isOk()) {
            this.printResultLog(String.format("[RDS] Checked checksum: %s", path));
        }
        return status;
    }

    @Override
    public ICommandStatus removeFile(String path) {
        String command = String.format("rm -f %s", path);
        ICommandStatus status = this.execute(command, null);
        if (status.isOk()) {
            this.printResultLog(String.format("[RDS] Removed file: %s", path));
        }
        return status;
    }

    @Override
    public ICommandStatus makeDir(String path) {
        String command = String.format("mkdir -p %s", path);
        ICommandStatus status = this.execute(command, null);
        if (status.isOk()) {
            this.printResultLog(String.format("[RDS] Make dir: %s", path));
        }
        return status;
    }

    @Override
    public boolean isRunningApp(String appId) {
        List<String> values;
        String command = PkgcmdTool.isRunningAppCommand(appId);
        ICommandStatus status = this.execute(command, null);
        if (status.isOk() && (values = status.getValues()) != null) {
            for (String line : values) {
                if (!line.contains("is Running")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ICommandStatus killApp(String appId) {
        String command = PkgcmdTool.killApp(appId);
        ICommandStatus status = this.execute(command, null);
        return status;
    }

    @Override
    public ICommandStatus launchApp(String appId) {
        String command = String.format("launch_app %s", appId);
        ICommandStatus status = this.execute(command, null);
        return status;
    }

    @Override
    public ICommandStatus executeBinary(String command) {
        DeviceExecutor executor = new DeviceExecutor(command);
        executor.setIsPrintCommand(true);
        ICommandStatus status = this.execute(executor);
        if (!status.isOk()) {
            String cmdLog = status.getCommand();
            String msgLog = status.getException().toString();
            String log = String.format("[Exception]%s:%s", cmdLog, msgLog);
            this.printResultLog(log);
        }
        return status;
    }

    @Override
    public ICommandStatus executeBinaryBySudo(String command) {
        DeviceExecutor executor = new DeviceExecutor(command);
        executor.setIsRoot(true);
        executor.setIsPrintCommand(true);
        ICommandStatus status = this.execute(executor);
        if (!status.isOk()) {
            String cmdLog = status.getCommand();
            String msgLog = status.getException().toString();
            String log = String.format("[Exception]%s:%s", cmdLog, msgLog);
            this.printResultLog(log);
        }
        return status;
    }

    @Override
    public ICommandStatus setSmackExecute(String path, String e_label) {
        StringBuffer sbCommand = new StringBuffer("chsmack");
        if (!e_label.isEmpty()) {
            sbCommand.append(String.format(" -e %s", e_label));
        }
        sbCommand.append(String.format(" %s", path));
        sbCommand.append(String.format(";chsmack %s", path));
        String command = sbCommand.toString();
        ICommandStatus status = this.execute(command, null, false, false);
        if (status.isOk()) {
            List<String> value = status.getValues();
            String e_result = "";
            if (value.size() > 0) {
                String line = value.get(0);
                String[] stringArray = line.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] e;
                    String info = stringArray[n2];
                    if (info.startsWith("execute") && (e = info.split("=")).length == 2) {
                        e_result = e[1];
                    }
                    ++n2;
                }
            }
            if (e_label.equals("\"\"") && e_result.isEmpty()) {
                this.printResultLog(String.format("[RDS] Change smack: %s %s", path, e_label));
            } else if (e_label.equals(e_result)) {
                this.printResultLog(String.format("[RDS] Change smack: %s %s", path, e_label));
            } else {
                return null;
            }
        }
        return status;
    }

    @Override
    public ICommandStatus changeSmack(String path, String a_label, String e_label) {
        StringBuffer sbCommand = new StringBuffer("chsmack");
        if (a_label.isEmpty()) {
            String log = String.format("[RDS] access permission is empty: %s", path);
            this.printResultLog(log);
            return new CommandStatus(0, "", log, null);
        }
        sbCommand.append(String.format(" -a %s", a_label));
        if (!e_label.isEmpty()) {
            sbCommand.append(String.format(" -e %s", e_label));
        } else {
            String log = String.format("[RDS] execute permission is empty: %s", path);
            this.printResultLog(log);
            sbCommand.append(String.format(" -e \"\"", a_label));
        }
        sbCommand.append(String.format(" %s", path));
        sbCommand.append(String.format(";chsmack %s", path));
        String command = sbCommand.toString();
        DeviceExecutor executor = new DeviceExecutor(command);
        executor.setIsRoot(true);
        ICommandStatus status = this.execute(executor);
        if (status.isOk()) {
            List<String> value = status.getValues();
            String a_result = "";
            String e_result = "";
            if (value.size() > 0) {
                String line = value.get(0);
                String[] stringArray = line.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] e;
                    String info = stringArray[n2];
                    if (info.startsWith("access=")) {
                        String[] a = info.split("=");
                        if (a.length == 2) {
                            a_result = a[1];
                        }
                    } else if (info.startsWith("execute") && (e = info.split("=")).length == 2) {
                        e_result = e[1];
                    }
                    ++n2;
                }
            }
            if (a_label.equals(a_result) && e_label.equals(e_result)) {
                this.printResultLog(String.format("[RDS] Change smack: %s %s %s", path, a_label, e_label));
            } else {
                return null;
            }
        }
        return status;
    }

    @Override
    public ICommandStatus getSmack(String paths) {
        String command = String.format("chsmack %s", paths);
        ICommandStatus status = this.execute(command, null, false, false);
        if (status.isOk()) {
            this.printResultLog(String.format("[RDS] Get smack: %s", paths));
        } else {
            this.printResultLog(String.format("[RDS] Failed to get smack: %s", paths));
        }
        return status;
    }

    @Override
    public Map<String, PkgStatus> getLocalPkgList() {
        String tag = "\\<pkg\\>%{NAME},%{VERSION}-%{RELEASE},%{ARCH}\\<\\/pkg\\>";
        return this.getLocalPkgList(tag);
    }

    @Override
    protected void changeUpdateMode() {
        if (!this.device.isEmulator()) {
            this.execute(CMD_CHANGE_UPDATEMODE, null);
        }
    }

    @Override
    public void actionBeforeUsingZypper() {
        if (this.device.isEmulator() && this.existsFile(ZYPPER_CONF_FILE)) {
            String command = CMD_ACTION_FOR_USING_ZYPPER;
            DeviceExecutor executor = new DeviceExecutor(command);
            executor.setIsRoot(true);
            executor.setIsPrintCommand(true);
            this.execute(executor);
        }
    }

    @Override
    protected ICommandStatus execute(String command, IProgressMonitor monitor) {
        return this.execute(command, monitor, true);
    }

    @Override
    protected ICommandStatus execute(String command, int timeout, IProgressMonitor monitor) {
        DeviceExecutor executor = new DeviceExecutor(command, monitor);
        executor.setTimeout(timeout);
        executor.setIsPrintCommand(true);
        return this.execute(executor);
    }

    @Override
    protected ICommandStatus execute(String command, IProgressMonitor monitor, boolean printCommand) {
        LaunchCommandCancelThread cancelThread = null;
        ICommandStatus status = null;
        if (monitor != null) {
            cancelThread = new LaunchCommandCancelThread(this, monitor);
            cancelThread.start();
        }
        try {
            if (printCommand) {
                this.printCommandLog(command);
            }
            if (!(status = DeviceCommandLauncher.execute(this.device, command, this.rec)).isOk()) {
                this.logger.error(status.getMessage(), status.getException());
            }
        }
        finally {
            if (cancelThread != null) {
                cancelThread.setTerminated();
                if (cancelThread.isAlive()) {
                    cancelThread.interrupt();
                }
            }
        }
        return status;
    }

    protected ICommandStatus execute(Executor executor) {
        LaunchCommandCancelThread cancelThread = null;
        ICommandStatus status = null;
        if (executor.getMonitor() != null) {
            cancelThread = new LaunchCommandCancelThread(this, executor.getMonitor());
            cancelThread.start();
        }
        try {
            if (executor.getIsPrintCommand()) {
                this.printCommandLog(executor.getCommand());
            }
            if (!(status = DeviceCommandLauncher.execute(this.device, executor, this.rec)).isOk()) {
                this.logger.error(status.getMessage(), status.getException());
            }
        }
        finally {
            if (cancelThread != null) {
                cancelThread.setTerminated();
                if (cancelThread.isAlive()) {
                    cancelThread.interrupt();
                }
            }
        }
        return status;
    }

    protected ICommandStatus execute(String command, IProgressMonitor monitor, boolean printCommand, boolean printLog) {
        LaunchCommandCancelThread cancelThread = null;
        ICommandStatus status = null;
        if (monitor != null) {
            cancelThread = new LaunchCommandCancelThread(this, monitor);
            cancelThread.start();
        }
        try {
            if (printCommand) {
                this.printCommandLog(command);
            }
            this.rec.setPrintConsole(printLog);
            status = DeviceCommandLauncher.execute(this.device, command, this.rec);
            if (!status.isOk()) {
                this.logger.error(status.getMessage(), status.getException());
            }
        }
        finally {
            if (cancelThread != null) {
                cancelThread.setTerminated();
                if (cancelThread.isAlive()) {
                    cancelThread.interrupt();
                }
            }
        }
        return status;
    }

    @Override
    protected ICommandStatus execute(String command, PackageManagerOutputReceiver rec, IProgressMonitor monitor) {
        return this.execute(command, rec, monitor, true);
    }

    @Override
    protected ICommandStatus execute(String command, PackageManagerOutputReceiver rec, int timeout, IProgressMonitor monitor) {
        DeviceExecutor executor = new DeviceExecutor(command, monitor);
        executor.setTimeout(timeout);
        executor.setIsPrintlog(true);
        return this.execute(executor, rec);
    }

    @Override
    protected ICommandStatus execute(String command, PackageManagerOutputReceiver rec, IProgressMonitor monitor, boolean printlog) {
        LaunchCommandCancelThread cancelThread = null;
        ICommandStatus status = null;
        if (monitor != null) {
            cancelThread = new LaunchCommandCancelThread(this, monitor);
            cancelThread.start();
        }
        try {
            if (printlog) {
                this.printCommandLog(command);
            }
            if (!(status = DeviceCommandLauncher.execute(this.device, command, rec)).isOk()) {
                this.logger.error(status.getMessage(), status.getException());
            }
        }
        finally {
            if (cancelThread != null) {
                cancelThread.setTerminated();
                if (cancelThread.isAlive()) {
                    cancelThread.interrupt();
                }
            }
        }
        return status;
    }

    protected ICommandStatus execute(Executor executor, PackageManagerOutputReceiver rec) {
        LaunchCommandCancelThread cancelThread = null;
        ICommandStatus status = null;
        if (executor.getMonitor() != null) {
            cancelThread = new LaunchCommandCancelThread(this, executor.getMonitor());
            cancelThread.start();
        }
        try {
            if (executor.getIsPrintlog()) {
                this.printCommandLog(executor.getCommand());
            }
            if (!(status = DeviceCommandLauncher.execute(this.device, executor, rec)).isOk()) {
                this.logger.error(status.getMessage(), status.getException());
            }
        }
        finally {
            if (cancelThread != null) {
                cancelThread.setTerminated();
                if (cancelThread.isAlive()) {
                    cancelThread.interrupt();
                }
            }
        }
        return status;
    }

    @Override
    protected PackageManagerOutputReceiver getNewOuputReceiver() {
        PackageManagerOutputReceiver rec = new PackageManagerOutputReceiver();
        rec.setPrintConsole(false);
        return rec;
    }

    @Override
    public CmdTargetTypes getCommandType() {
        return this.CMD_TYPE;
    }

    @Override
    public ICommandStatus unCompressArchivedFile(String rdsFiles) {
        String command = String.format("tar -zxvf /tmp/%s -C / --strip-components=1", rdsFiles);
        DeviceExecutor executor = new DeviceExecutor(command, null);
        executor.setIsRoot(true);
        executor.setIsPrintCommand(true);
        ICommandStatus status = this.execute(executor);
        if (status.isOk()) {
            this.printResultLog(String.format("[RDS] unCompress file: %s", rdsFiles));
        }
        return status;
    }
}

