/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.util.InstallerUtil;

public class RootstrapUtil {
    protected static final String USER_ROOSTRAP_BASE_DIR_NAME = "user-rootstraps";
    protected static final String REMOTE_TIZEN_SDK_DIR_NAME = "tizen-sdk-remote-data";
    protected static final String REMOTE_CONNECTION_DIR = "connection";
    protected static final String REMOTE_CONNECTION_FILE = "info";
    protected static final String REMOTE_TOOLS_DIR_NAME = "tools";
    protected static final String REMOTE_WORKSPACE_DIR = "workspace";
    protected static final String REMOTE_ROOSTRAP_PLUGINS_DIR_NAME = "user-rootstrap-plugins";
    protected static final String REGEX_NAME = "([A-Za-z0-9\\-\\_]+)";

    public static String getBaseArchitecture(String arch) {
        if (arch.contains("arm")) {
            return "arm";
        }
        return "i586";
    }

    public static String getUserRootstrapPath(String id) {
        return new Path(RootstrapUtil.getBaseUserRootstrapPath()).append(id).toOSString();
    }

    public static String getBaseUserRootstrapPath() {
        return new Path(InstallPathConfig.getUserDataPath()).append(USER_ROOSTRAP_BASE_DIR_NAME).toOSString();
    }

    public static String getUserRootstrapPathOfXml(String id) {
        String rootstrapPath = RootstrapUtil.getUserRootstrapPath(id);
        return RootstrapUtil.getRootstrapPathOfXml(rootstrapPath);
    }

    public static String getRootstrapPathOfXml(String path) {
        if (InstallerUtil.isSupportedMultipleSDK()) {
            return path.replaceAll(String.format("%s/", InstallPathConfig.getSDKPath()), "#{SDK_INSTALLED_PATH}/").replaceAll(String.format("%s/", InstallPathConfig.getUserDataPath()), "#{SDK_DATA_PATH}/");
        }
        return path.replaceAll(String.format("%s/", InstallPathConfig.getSDKPath()), "#{SBI_HOME}/../../").replaceAll(String.format("%s/", InstallPathConfig.getUserDataPath()), "#{HOME}/tizen-sdk-data/");
    }

    public static String getPluginXML(String id) {
        Path pluginPath = new Path(SmartBuildInterface.getInstance().getPluginPath());
        return pluginPath.append(String.valueOf(id) + ".xml").toOSString();
    }

    public static IPath getRogenPath() {
        return new Path(InstallPathConfig.getSDKPath()).append(REMOTE_TOOLS_DIR_NAME).append("rogen");
    }

    public static String getRogenBinPath() {
        return RootstrapUtil.getRogenPath().append("bin").append("rogen.rb").toString();
    }

    public static boolean validateRootstrapName(String name) {
        return name.matches(REGEX_NAME);
    }
}

