/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsoleViewer;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.IPkgVersionComparer;
import org.tizen.nativeplatform.pkg.commander.factory.PkgVersionComparerFactory;
import org.tizen.nativeplatform.pkg.model.PkgInfo;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.pkgmgr.PackageManagerOutputReceiver;
import org.tizen.nativeplatform.pkgmgr.ui.PackageTableSelectionAdapter;
import org.tizen.nativeplatform.pkgmgr.ui.PkgPropertiesDialog;
import org.tizen.nativeplatform.pkgmgr.ui.RepoTableSelectionAdapter;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.util.PlatformProjectUtil;

public abstract class CommonTab {
    protected TableViewer repoViewer = null;
    protected CheckboxTableViewer pkgViewer = null;
    protected Combo categoryCombo;
    protected Text filterText;
    protected Text logText;
    protected IOConsoleViewer logViewer;
    protected String logs = "";
    protected boolean isRepoChanged = false;
    protected Action actionProperties;
    protected MenuManager menuMgr;
    protected final Shell shell;
    protected TabFolder folder = null;
    protected static final String BUNDLE_NAME = String.valueOf(CommonTab.class.getPackage().getName()) + ".PkgMgrUIMessages";
    protected static final ResourceBundle resources = ResourceBundle.getBundle(BUNDLE_NAME);
    protected IPkgCommander commander = null;
    protected IPkgCommander hostCommander = null;

    public CommonTab(Shell shell, TabFolder folder, IPkgCommander hostCommander, IPkgCommander commander) {
        this.shell = shell;
        this.folder = folder;
        this.commander = commander;
        this.hostCommander = hostCommander;
    }

    protected abstract CopyOnWriteArrayList<Repository> getRepositoryList();

    public abstract void updateRepositoryInfo();

    public abstract void updateRepository();

    protected abstract boolean handleAddRepositoryButton();

    protected abstract boolean handleModifyRepositoryButton();

    protected abstract boolean handleRemoveRepositoryButton();

    protected abstract boolean handleMoveupRepositoryButton();

    protected abstract boolean handleMovedownRepositoryButton();

    protected abstract void handleUpgradeButton();

    protected abstract List<PkgStatus> getPackageList();

    protected abstract List<PkgStatus> getSelectedPkgList(boolean var1);

    private void makeActions() {
        this.actionProperties = new Action(){

            public void run() {
                CommonTab.this.showProperties();
            }
        };
        this.actionProperties.setText(resources.getString("PkgMgr.Contextmenu.Action.Prop"));
    }

    private void initContextMenu() {
        this.menuMgr = new MenuManager(resources.getString("PkgMgr.Contextmenu.Title"));
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CommonTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.menuMgr.createContextMenu((Control)this.pkgViewer.getTable());
        this.pkgViewer.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionProperties);
    }

    public void doActionForEntry(IActionForEntry action) {
        if (action.doCheckEnable()) {
            action.doAction();
        }
    }

    public void showProperties() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                Table table = CommonTab.this.pkgViewer.getTable();
                TableItem[] item = table.getSelection();
                PkgStatus selected = (PkgStatus)item[0].getData();
                String pkgName = selected.getPkg().getName();
                String installedVer = selected.getInstalledVer();
                String newVer = selected.getNewVer();
                PkgInfo info = null;
                if (!installedVer.isEmpty()) {
                    info = CommonTab.this.commander.getPkgInfo(pkgName, IPkgCommander.TOOL.RPM);
                } else if (!newVer.isEmpty()) {
                    info = CommonTab.this.commander.getPkgInfo(pkgName, IPkgCommander.TOOL.ZYPPER);
                } else {
                    DialogUtil.openErrorDialog((String)resources.getString("PkgMgr.Msg.Error.Display.PkgProp"));
                    return;
                }
                if (info == null) {
                    DialogUtil.openErrorDialog((String)resources.getString("PkgMgr.Msg.Error.Display.PkgProp"));
                    return;
                }
                PkgPropertiesDialog dlg = new PkgPropertiesDialog(CommonTab.this.shell, info);
                dlg.open();
            }

            @Override
            public boolean doCheckEnable() {
                return true;
            }
        });
    }

    protected void createCommonTab(String title) {
        TabItem tab = new TabItem(this.folder, 0);
        tab.setText(title);
        Composite composite = new Composite((Composite)this.folder, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        tab.setControl((Control)composite);
        this.createRepositoryGroup(composite);
        this.createPackageGroup(composite);
        this.createLogSeparator(composite);
        this.createLogViewer(composite);
        this.makeActions();
        this.initContextMenu();
    }

    private void createLogSeparator(Composite parent) {
        Label logLabel = new Label(parent, 258);
        logLabel.setLayoutData((Object)new GridData(768));
    }

    private void createLogViewer(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridData log_gd = new GridData(1808);
        log_gd.heightHint = 150;
        composite.setLayoutData((Object)log_gd);
        composite.setLayout((Layout)new FillLayout());
        PackageManagerOutputReceiver receiver = this.commander.getOutputReceiver();
        if (receiver == null) {
            return;
        }
        MessageConsole c = receiver.getMsgConsoleStream().getConsole();
        this.logViewer = new IOConsoleViewer(composite, (TextConsole)c);
        int line = this.logViewer.getTextWidget().getLineCount();
        if (line > 0) {
            this.logViewer.getTextWidget().setTopIndex(line);
        }
    }

    private void createRepositoryGroup(Composite parent) {
        Group grpRepo = new Group(parent, 0);
        grpRepo.setText(resources.getString("PkgMgr.Frame.Respository"));
        GridData repo_gd = new GridData(768);
        repo_gd.heightHint = 180;
        grpRepo.setLayoutData((Object)repo_gd);
        grpRepo.setLayout((Layout)new GridLayout(2, false));
        this.createRepositoryTable((Composite)grpRepo);
        this.createRepositoryButtons((Composite)grpRepo);
    }

    private void createRepositoryTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new FillLayout());
        this.repoViewer = new TableViewer(composite, 68352);
        this.createColumnsForRepoTable(composite);
        Table reposTable = this.repoViewer.getTable();
        reposTable.setHeaderVisible(true);
        reposTable.setLinesVisible(true);
        this.repoViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.repoViewer.setInput(this.getRepositoryList());
    }

    private void createColumnsForRepoTable(Composite parent) {
        String[] titles = new String[]{resources.getString("PkgMgr.Repo.Table.Column.1"), resources.getString("PkgMgr.Repo.Table.Column.2")};
        int[] bounds = new int[]{100, 900};
        RepoTableSelectionAdapter adapter = new RepoTableSelectionAdapter(this.repoViewer);
        TableViewerColumn colName = this.createTableViewerColumn(this.repoViewer, adapter, titles[0], bounds[0], 0);
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Repository repo = (Repository)element;
                return repo.getName();
            }
        });
        TableViewerColumn colUrl = this.createTableViewerColumn(this.repoViewer, adapter, titles[1], bounds[1], 0);
        colUrl.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Repository repo = (Repository)element;
                return repo.getUri();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, SelectionAdapter adapter, String title, int bound, int Style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, Style);
        TableColumn column = viewerColumn.getColumn();
        column.addSelectionListener((SelectionListener)adapter);
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void createRepositoryButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Button add_bt = new Button(composite, 8);
        Image addIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/add.gif");
        add_bt.setImage(addIcon);
        add_bt.setToolTipText(resources.getString("PkgMgr.Button.AddRepo.Tooltip"));
        add_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(CommonTab.this.shell);
                if (CommonTab.this.handleAddRepositoryButton()) {
                    try {
                        dialog.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask("Add repository", -1);
                                try {
                                    CommonTab.this.updateRepositoryInfo();
                                    (this).CommonTab.this.isRepoChanged = true;
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.Addrepo")) + "(" + e1.toString() + ")"));
                    }
                    catch (InterruptedException e1) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.Addrepo")) + "(" + e1.toString() + ")"));
                    }
                    CommonTab.this.repoViewer.refresh();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button remove_bt = new Button(composite, 8);
        Image removeIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/remove.gif");
        remove_bt.setImage(removeIcon);
        remove_bt.setToolTipText(resources.getString("PkgMgr.Button.RemoveRepo.Tooltip"));
        remove_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(CommonTab.this.shell);
                if (CommonTab.this.handleRemoveRepositoryButton()) {
                    try {
                        dialog.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask("Remove repository", -1);
                                try {
                                    CommonTab.this.updateRepositoryInfo();
                                    (this).CommonTab.this.isRepoChanged = true;
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.Removerepo")) + "(" + e1.toString() + ")"));
                    }
                    catch (InterruptedException e1) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.Removerepo")) + "(" + e1.toString() + ")"));
                    }
                    CommonTab.this.repoViewer.refresh();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button modify_bt = new Button(composite, 8);
        Image modifyIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/rootstrap/edit.gif");
        modify_bt.setImage(modifyIcon);
        modify_bt.setToolTipText(resources.getString("PkgMgr.Button.ModifyRepo.Tooltip"));
        modify_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(CommonTab.this.shell);
                if (CommonTab.this.handleModifyRepositoryButton()) {
                    try {
                        dialog.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask("Modify repository", -1);
                                try {
                                    CommonTab.this.updateRepositoryInfo();
                                    (this).CommonTab.this.isRepoChanged = true;
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.Modifyrepo")) + "(" + e1.toString() + ")"));
                    }
                    catch (InterruptedException e1) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.Modifyrepo")) + "(" + e1.toString() + ")"));
                    }
                    CommonTab.this.repoViewer.refresh();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button moveup_bt = new Button(composite, 8);
        Image moveupIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/list-moveup.gif");
        moveup_bt.setImage(moveupIcon);
        moveup_bt.setToolTipText(resources.getString("PkgMgr.Button.MoverepoUp.Tooltip"));
        moveup_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(CommonTab.this.shell);
                if (CommonTab.this.handleMoveupRepositoryButton()) {
                    int selectedIdx = CommonTab.this.repoViewer.getTable().getSelectionIndex();
                    try {
                        dialog.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask("Move repository up", -1);
                                try {
                                    CommonTab.this.updateRepositoryInfo();
                                    (this).CommonTab.this.isRepoChanged = true;
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.MoverepoUp")) + "(" + e1.toString() + ")"));
                    }
                    catch (InterruptedException e1) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.MoverepoUp")) + "(" + e1.toString() + ")"));
                    }
                    CommonTab.this.repoViewer.refresh();
                    if (selectedIdx >= 1) {
                        CommonTab.this.repoViewer.getTable().setSelection(selectedIdx - 1);
                    } else {
                        CommonTab.this.repoViewer.getTable().setSelection(selectedIdx);
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button movedown_bt = new Button(composite, 8);
        Image movedownIcon = ImageUtil.getImage((String)"org.tizen.nativeplatform", (String)"icons/list-movedown.gif");
        movedown_bt.setImage(movedownIcon);
        movedown_bt.setToolTipText(resources.getString("PkgMgr.Button.MoverepoDown.Tooltip"));
        movedown_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(CommonTab.this.shell);
                if (CommonTab.this.handleMovedownRepositoryButton()) {
                    int selectedIdx = CommonTab.this.repoViewer.getTable().getSelectionIndex();
                    int totalCount = CommonTab.this.repoViewer.getTable().getItemCount();
                    try {
                        dialog.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask("Move repository down", -1);
                                try {
                                    CommonTab.this.updateRepositoryInfo();
                                    (this).CommonTab.this.isRepoChanged = true;
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.MoverepoDown")) + "(" + e1.toString() + ")"));
                    }
                    catch (InterruptedException e1) {
                        DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.MoverepoDown")) + "(" + e1.toString() + ")"));
                    }
                    CommonTab.this.repoViewer.refresh();
                    if (selectedIdx < totalCount) {
                        CommonTab.this.repoViewer.getTable().setSelection(selectedIdx + 1);
                    } else {
                        CommonTab.this.repoViewer.getTable().setSelection(selectedIdx);
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    protected void createPackageGroup(Composite parent) {
        Group grpPkg = new Group(parent, 0);
        grpPkg.setText(resources.getString("PkgMgr.Frame.Package"));
        GridData pkgs_gd = new GridData(1808);
        pkgs_gd.heightHint = 300;
        grpPkg.setLayoutData((Object)pkgs_gd);
        grpPkg.setLayout((Layout)new GridLayout(1, false));
        this.createPackageButtonsAndFilter((Composite)grpPkg);
        this.createPackageTable((Composite)grpPkg);
    }

    protected void createPackageButtonsAndFilter(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createPackageButtons(composite);
        this.createPackageFilter(composite);
    }

    protected void createPackageButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Button refresh_bt = new Button(composite, 8);
        refresh_bt.setText(resources.getString("PkgMgr.Button.RefreshRepo"));
        refresh_bt.setToolTipText(resources.getString("PkgMgr.Button.RefreshRepo.Tooltip"));
        refresh_bt.setLayoutData((Object)new GridData(768));
        refresh_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                CommonTab.this.handleRefreshRepositoryButton();
                CommonTab.this.pkgViewer.refresh();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button upgrade_bt = new Button(composite, 8);
        upgrade_bt.setText(resources.getString("PkgMgr.Button.Upgrade"));
        upgrade_bt.setToolTipText(resources.getString("PkgMgr.Button.Upgrade.Tooltip"));
        upgrade_bt.setLayoutData((Object)new GridData(768));
        upgrade_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                CommonTab.this.handleUpgradeButton();
                CommonTab.this.pkgViewer.refresh();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button install_bt = new Button(composite, 8);
        install_bt.setText(resources.getString("PkgMgr.Button.Install"));
        install_bt.setToolTipText(resources.getString("PkgMgr.Button.Install.Tooltip"));
        install_bt.setLayoutData((Object)new GridData(768));
        install_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                CommonTab.this.handleInstallPackageButton();
                CommonTab.this.pkgViewer.refresh();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button installLocal_bt = new Button(composite, 8);
        installLocal_bt.setText(resources.getString("PkgMgr.Button.InstallLocal"));
        installLocal_bt.setToolTipText(resources.getString("PkgMgr.Button.InstallLocal.Tooltip"));
        installLocal_bt.setLayoutData((Object)new GridData(768));
        installLocal_bt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog fd = new FileDialog(CommonTab.this.shell, 4098);
                fd.setText(resources.getString("FileDlg.Title"));
                String[] filterExt = new String[]{resources.getString("FileDlg.Filter.Ext")};
                fd.setFilterExtensions(filterExt);
                String firstFilePath = fd.open();
                if (firstFilePath == null) {
                    return;
                }
                String[] fileNames = fd.getFileNames();
                ArrayList<String> selectedFiles = new ArrayList<String>();
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    IPath path = new Path(firstFilePath).removeLastSegments(1).append(fileName);
                    selectedFiles.add(path.toString());
                    ++n2;
                }
                CommonTab.this.handleInstallLocalPackageButton(selectedFiles);
                CommonTab.this.pkgViewer.refresh();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button removeBt = new Button(composite, 8);
        removeBt.setText(resources.getString("PkgMgr.Button.Uninstall"));
        removeBt.setToolTipText(resources.getString("PkgMgr.Button.Uninstall.Tooltip"));
        removeBt.setLayoutData((Object)new GridData(768));
        removeBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                CommonTab.this.handleRemovePackageButton();
                CommonTab.this.pkgViewer.refresh();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createPackageFilter(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Label filterTextLabel = new Label(composite, 0);
        filterTextLabel.setText(resources.getString("PkgMgr.Label.Filter"));
        this.categoryCombo = new Combo(composite, 8);
        String[] items = new String[]{"All", "Installed", "Upgradable"};
        this.categoryCombo.setItems(items);
        this.categoryCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommonTab.this.pkgViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.categoryCombo.select(0);
        this.filterText = new Text(composite, 2180);
        GridData gridData = new GridData(768);
        this.filterText.setLayoutData((Object)gridData);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonTab.this.pkgViewer.refresh();
            }
        });
    }

    private void createPackageTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        this.pkgViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2848);
        this.createPackageTableColumns(composite);
        Table packageTable = this.pkgViewer.getTable();
        packageTable.setHeaderVisible(true);
        packageTable.setLinesVisible(true);
        this.pkgViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.pkgViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                PkgStatus pkg = (PkgStatus)element;
                return pkg.isChecked();
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.pkgViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                PkgStatus pkg = (PkgStatus)element;
                if (CommonTab.this.categoryCombo != null) {
                    if (CommonTab.this.categoryCombo.getText().equals("Installed") && pkg.getInstalledVer().isEmpty()) {
                        return false;
                    }
                    if (CommonTab.this.categoryCombo.getText().equals("Upgradable")) {
                        IPkgVersionComparer comp = PkgVersionComparerFactory.getComparer(PlatformProjectUtil.getPkgType());
                        if (pkg.getInstalledVer().isEmpty() || pkg.getNewVer().isEmpty() || comp.compare(pkg.getInstalledVer(), pkg.getNewVer()) >= 0) {
                            return false;
                        }
                    }
                }
                String name = pkg.getPackage().getName();
                return CommonTab.this.filterText == null || name.contains(CommonTab.this.filterText.getText());
            }
        });
        this.pkgViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PkgStatus pkg;
                pkg.setChecked(!(pkg = (PkgStatus)event.getElement()).isChecked());
            }
        });
        this.pkgViewer.setInput(this.getPackageList());
    }

    private void createPackageTableColumns(Composite parent) {
        String[] titles = new String[]{"S", "Package Name", "Installed Version", "New Version", "Arch"};
        int[] bounds = new int[]{24, 250, 200, 200, 60};
        PackageTableSelectionAdapter adapter = new PackageTableSelectionAdapter((TableViewer)this.pkgViewer);
        TableViewerColumn colSelection = this.createTableViewerColumn((TableViewer)this.pkgViewer, adapter, titles[0], bounds[0], 0);
        colSelection.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }
        });
        TableViewerColumn colPackage = this.createTableViewerColumn((TableViewer)this.pkgViewer, adapter, titles[1], bounds[1], 0);
        colPackage.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PkgStatus pkg = (PkgStatus)element;
                if (pkg.isNewlyChanged()) {
                    return "*" + pkg.getPackage().getName();
                }
                return pkg.getPackage().getName();
            }
        });
        TableViewerColumn colInsVer = this.createTableViewerColumn((TableViewer)this.pkgViewer, adapter, titles[2], bounds[2], 0);
        colInsVer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PkgStatus pkg = (PkgStatus)element;
                String installedVer = pkg.getInstalledVer();
                return installedVer;
            }
        });
        TableViewerColumn colNewVer = this.createTableViewerColumn((TableViewer)this.pkgViewer, adapter, titles[3], bounds[3], 0);
        colNewVer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PkgStatus pkg = (PkgStatus)element;
                String newVer = pkg.getNewVer();
                return newVer;
            }
        });
        TableViewerColumn colArch = this.createTableViewerColumn((TableViewer)this.pkgViewer, adapter, titles[4], bounds[4], 0);
        colArch.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PkgStatus pkg = (PkgStatus)element;
                String arch = pkg.getPackage().getArch();
                return arch;
            }
        });
    }

    protected void applyRepoChanges() {
        this.updateRepository();
        this.isRepoChanged = false;
    }

    protected void handleRefreshRepositoryButton() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ICommandStatus status;
                    monitor.beginTask(resources.getString("PkgMgr.Message.Refreshing"), -1);
                    if (CommonTab.this.isRepoChanged) {
                        CommonTab.this.applyRepoChanges();
                    }
                    if ((status = CommonTab.this.commander.refreshRepoList()) == null || !status.isOk()) {
                        throw new InterruptedException();
                    }
                    CommonTab.this.updatePackageInfo(null);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.RefreshFailed")) + "(" + e.toString() + ")"));
        }
        catch (InterruptedException e) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.RefreshFailed")) + "(" + e.toString() + ")"));
        }
    }

    protected void handleInstallPackageButton() {
        final List<PkgStatus> selectedList = this.getSelectedPkgList(false);
        if (selectedList.isEmpty()) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Error.Noselected.Package")) + "\n" + resources.getString("PkgMgr.Info.Check.Pkg.NewVer")));
            return;
        }
        if (this.isRepoChanged) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Info.Refresh.First"));
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(resources.getString("PkgMgr.Message.Installing.Package"), -1);
                    ArrayList<String> lists = new ArrayList<String>();
                    for (PkgStatus pkg : selectedList) {
                        lists.add(pkg.getPackage().getName());
                    }
                    ICommandStatus status = CommonTab.this.commander.installRemotePkg(lists.toArray(new String[0]), monitor);
                    if (status == null || !status.isOk()) {
                        throw new InterruptedException();
                    }
                    CommonTab.this.updatePackageInfo(null);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.InstallFailed")) + "(" + e.toString() + ")"));
        }
        catch (InterruptedException e) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.InstallFailed")) + "(" + e.toString() + ")"));
        }
    }

    protected void handleInstallLocalPackageButton(final List<String> selectedFiles) {
        if (this.isRepoChanged) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Info.Refresh.First"));
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(resources.getString("PkgMgr.Message.Installing.LocalPackage"), -1);
                    ICommandStatus status = CommonTab.this.commander.installLocalPkg(selectedFiles.toArray(new String[0]), monitor);
                    if (status == null || !status.isOk()) {
                        throw new InterruptedException();
                    }
                    CommonTab.this.updatePackageInfo(selectedFiles);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.InstallFailed")) + "(" + e.toString() + ")"));
        }
        catch (InterruptedException e) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.InstallFailed")) + "(" + e.toString() + ")"));
        }
    }

    protected void handleRemovePackageButton() {
        final List<PkgStatus> selectedList = this.getSelectedPkgList(true);
        if (selectedList.isEmpty()) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Error.Noselected.Package")) + "\n" + resources.getString("PkgMgr.Info.Check.Pkg.Installed")));
            return;
        }
        if (this.isRepoChanged) {
            DialogUtil.openMessageDialog((String)resources.getString("PkgMgr.Info.Refresh.First"));
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(resources.getString("PkgMgr.Message.Uninstalling.Package"), -1);
                    ArrayList<String> lists = new ArrayList<String>();
                    for (PkgStatus pkg : selectedList) {
                        lists.add(pkg.getPackage().getName());
                    }
                    ICommandStatus status = CommonTab.this.commander.uninstallPkg(lists.toArray(new String[0]), monitor);
                    if (status == null || !status.isOk()) {
                        throw new InterruptedException();
                    }
                    CommonTab.this.updatePackageInfo(null);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.UninstallFailed")) + "(" + e.toString() + ")"));
        }
        catch (InterruptedException e) {
            DialogUtil.openErrorDialog((String)(String.valueOf(resources.getString("PkgMgr.Msg.Error.UninstallFailed")) + "(" + e.toString() + ")"));
        }
    }

    protected void updatePackageInfo(List<String> localPackageFileList) {
        String pkgName;
        String currPkgName;
        boolean found;
        List<PkgStatus> fullList = this.commander.getAllPkgList();
        ArrayList<PkgStatus> removeList = new ArrayList<PkgStatus>();
        for (PkgStatus pkg : this.getPackageList()) {
            found = false;
            for (PkgStatus currPkg : fullList) {
                currPkgName = currPkg.getPackage().getName();
                if (!currPkgName.equals(pkgName = pkg.getPackage().getName())) continue;
                if (!pkg.getInstalledVer().equals(currPkg.getInstalledVer())) {
                    pkg.setNewlyChanged(true);
                }
                if (!pkg.getNewVer().equals(currPkg.getNewVer())) {
                    pkg.setNewVer(currPkg.getNewVer());
                    pkg.setNewlyChanged(true);
                }
                pkg.setInstalledVer(currPkg.getInstalledVer());
                found = true;
                break;
            }
            if (!found) {
                removeList.add(pkg);
            }
            pkg.setChecked(false);
        }
        for (PkgStatus pkg : removeList) {
            this.getPackageList().remove(pkg);
        }
        for (PkgStatus currPkg : fullList) {
            found = false;
            for (PkgStatus pkg : this.getPackageList()) {
                currPkgName = currPkg.getPackage().getName();
                if (!currPkgName.equals(pkgName = pkg.getPackage().getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.getPackageList().add(currPkg);
            currPkg.setNewlyChanged(true);
        }
        if (localPackageFileList != null) {
            ArrayList<String> localPackageNameList = new ArrayList<String>();
            for (String filePath : localPackageFileList) {
                localPackageNameList.add(this.hostCommander.getNameFromFile(filePath));
            }
            for (PkgStatus pkg : this.getPackageList()) {
                String pkgName2 = pkg.getPackage().getName();
                if (!localPackageNameList.contains(pkgName2)) continue;
                pkg.setNewlyChanged(true);
            }
        }
    }

    public void closeTab() {
        if (this.isRepoChanged) {
            this.applyRepoChanges();
        }
    }

    private static interface IActionForEntry {
        public boolean doCheckEnable();

        public void doAction();
    }
}

