/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.ui;

import java.util.ResourceBundle;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CMainTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.nativeplatform.launcher.ui.PlatformMainAttachTab;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.sdblib.service.FileEntry;

public class PlatformCommonTab
extends CMainTab {
    protected final String BUNDLE_NAME = String.valueOf(PlatformMainAttachTab.class.getPackage().getName()) + ".LaunchTabUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected Text fBinPathText;
    protected Button fReinstallOp;

    protected String handleBrowseButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        if (this.fBinPathText != null) {
            fileDialog.setFileName(this.fBinPathText.getText());
        } else if (this.fCoreText != null) {
            fileDialog.setFileName(this.fCoreText.getText());
        }
        return fileDialog.open();
    }

    protected void createOptionGroupComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1816));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.fReinstallOp = new Button(composite, 32);
        this.fReinstallOp.setText(this.resources.getString("Button.Reinstall.Op"));
        this.fReinstallOp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformCommonTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected FileEntry handleRemoteBrowseButtonSelected(String defaultPath) {
        Shell shell = this.getAvailableShell();
        FileEntry path = null;
        path = defaultPath == null || defaultPath.isEmpty() ? PlatformLaunchUtil.selectRemoteFile((Shell)shell, (String)this.resources.getString("Remote.Dialog.Title")) : PlatformLaunchUtil.selectRemoteFile((Shell)shell, (String)this.resources.getString("Remote.Dialog.Title"), (String)defaultPath);
        return path;
    }

    protected Shell getAvailableShell() {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = PlatformLaunchUtil.getAvaiableShell();
        }
        return shell;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
        configuration.setAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 0);
        configuration.setAttribute("org.tizen.platform.launch.REINSTALL_OP_ATTR", true);
        ICElement cElement = null;
        cElement = this.getContext((ILaunchConfiguration)configuration, this.getPlatform((ILaunchConfiguration)configuration));
        if (cElement != null) {
            this.initializeCProject(cElement, configuration);
        }
    }

    protected void updateReinstallOpFromConfig(ILaunchConfiguration config) {
        boolean option = true;
        try {
            option = config.getAttribute("org.tizen.platform.launch.REINSTALL_OP_ATTR", true);
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log((Throwable)ce);
        }
        this.fReinstallOp.setSelection(option);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log((Throwable)ce);
        }
        this.fProjText.setText(projectName);
    }

    protected void updateProgramFromConfig(ILaunchConfiguration config) {
        if (this.fBinPathText != null) {
            String programName = "";
            try {
                programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
            }
            catch (CoreException ce) {
                LaunchUIPlugin.log((Throwable)ce);
            }
            this.fBinPathText.setText(programName);
        }
    }
}

