/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizards;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.MultipleInputDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.EnvironmentVariable;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class EnvironmentDialog
extends Dialog {
    private int x = 0;
    private int y = 0;
    private final int width = 600;
    private final int height = 400;
    protected ILaunchConfiguration launchConfig;
    protected Map envMap;
    protected Map defaultEnvMap;
    protected Button envAddButton;
    protected Button envEditButton;
    protected Button envRemoveButton;
    protected Button appendEnvironment;
    protected Button replaceEnvironment;
    protected Button envSelectButton;
    protected TableViewer environmentTable;
    protected String[] envTableColumnHeaders = new String[]{LaunchConfigurationsMessages.EnvironmentTab_Variable_1, LaunchConfigurationsMessages.EnvironmentTab_Value_2};
    protected static final String NAME_LABEL = LaunchConfigurationsMessages.EnvironmentTab_8;
    protected static final String VALUE_LABEL = LaunchConfigurationsMessages.EnvironmentTab_9;
    protected static final String TITLE = "Environment variable Configuration";
    protected static final String P_VARIABLE = "variable";
    protected static final String P_VALUE = "value";

    protected EnvironmentDialog(Shell parentShell, Map defaultEnvMap) {
        super(parentShell);
        Rectangle bounds = parentShell.getBounds();
        this.x = bounds.x + (bounds.width - 600) / 2;
        this.y = bounds.y + (bounds.height - 400) / 2;
        this.defaultEnvMap = defaultEnvMap;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
        newShell.setLocation(this.x, this.y);
        newShell.setSize(600, 400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createDescComposite(composite);
        this.createEnvironmentTable(composite);
        this.createTableButtons(composite);
        this.updateEnvironment();
        return composite;
    }

    protected void updateEnvironment() {
        this.environmentTable.setInput((Object)this.defaultEnvMap);
    }

    protected void createEnvironmentTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.environmentTable = new TableViewer(composite, 68354);
        Table table = this.environmentTable.getTable();
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.environmentTable.setContentProvider((IContentProvider)new EnvironmentVariableContentProvider());
        this.environmentTable.setLabelProvider((IBaseLabelProvider)new EnvironmentVariableLabelProvider());
        this.environmentTable.setColumnProperties(new String[]{P_VARIABLE, P_VALUE});
        this.environmentTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EnvironmentDialog.this.handleTableSelectionChanged(event);
            }
        });
        this.environmentTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!EnvironmentDialog.this.environmentTable.getSelection().isEmpty()) {
                    EnvironmentDialog.this.handleEnvEditButtonSelected();
                }
            }
        });
        final TableColumn tc1 = new TableColumn(table, 0, 0);
        tc1.setText(this.envTableColumnHeaders[0]);
        final TableColumn tc2 = new TableColumn(table, 0, 1);
        tc2.setText(this.envTableColumnHeaders[1]);
        final Table tref = table;
        final Composite comp = composite;
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = comp.getClientArea();
                Point size = tref.computeSize(-1, -1);
                ScrollBar vBar = tref.getVerticalBar();
                int width = area.width - tref.computeTrim((int)0, (int)0, (int)0, (int)0).width - 2;
                if (size.y > area.height + tref.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tref.getSize();
                if (oldSize.x > area.width) {
                    tc1.setWidth(width / 2 - 1);
                    tc2.setWidth(width - tc1.getWidth());
                    tref.setSize(area.width, area.height);
                } else {
                    tref.setSize(area.width, area.height);
                    tc1.setWidth(width / 2 - 1);
                    tc2.setWidth(width - tc1.getWidth());
                }
            }
        });
    }

    protected void createTableButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(2);
        composite.setLayoutData((Object)gd);
        GridData btgd = new GridData(768);
        this.envAddButton = new Button(composite, 8);
        this.envAddButton.setLayoutData((Object)btgd);
        this.envAddButton.setText(LaunchConfigurationsMessages.EnvironmentTab_New_4);
        this.envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentDialog.this.handleEnvAddButtonSelected();
            }
        });
        this.envSelectButton = new Button(composite, 8);
        this.envSelectButton.setLayoutData((Object)btgd);
        this.envSelectButton.setText(LaunchConfigurationsMessages.EnvironmentTab_18);
        this.envSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentDialog.this.handleEnvSelectButtonSelected();
            }
        });
        this.envEditButton = new Button(composite, 8);
        this.envEditButton.setLayoutData((Object)btgd);
        this.envEditButton.setText(LaunchConfigurationsMessages.EnvironmentTab_Edit_5);
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentDialog.this.handleEnvEditButtonSelected();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envRemoveButton = new Button(composite, 8);
        this.envRemoveButton.setLayoutData((Object)btgd);
        this.envRemoveButton.setText(LaunchConfigurationsMessages.EnvironmentTab_Remove_6);
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentDialog.this.handleEnvRemoveButtonSelected();
            }
        });
        this.envRemoveButton.setEnabled(false);
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.envEditButton.setEnabled(size == 1);
        this.envRemoveButton.setEnabled(size > 0);
    }

    protected void handleEnvAddButtonSelected() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_22);
        dialog.addTextField(NAME_LABEL, null, false);
        dialog.addVariablesField(VALUE_LABEL, null, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        String value = dialog.getStringValue(VALUE_LABEL);
        if (name != null && value != null && name.length() > 0 && value.length() > 0) {
            this.addVariable(new EnvironmentVariable(name.trim(), value.trim()));
            this.updateAppendReplace();
        }
    }

    private void handleEnvSelectButtonSelected() {
        Map envVariables = this.getNativeEnvironment();
        TableItem[] items = this.environmentTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable var = (EnvironmentVariable)items[i].getData();
            envVariables.remove(var.getName());
            ++i;
        }
        NativeEnvironmentSelectionDialog dialog = new NativeEnvironmentSelectionDialog(this.getShell(), envVariables);
        dialog.setTitle(LaunchConfigurationsMessages.EnvironmentTab_20);
        int button = dialog.open();
        if (button == 0) {
            Object[] selected = dialog.getResult();
            int i2 = 0;
            while (i2 < selected.length) {
                this.environmentTable.add(selected[i2]);
                ++i2;
            }
        }
        this.updateAppendReplace();
    }

    private void handleEnvRemoveButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        this.environmentTable.getControl().setRedraw(false);
        for (EnvironmentVariable var : sel) {
            this.environmentTable.remove((Object)var);
        }
        this.environmentTable.getControl().setRedraw(true);
        this.updateAppendReplace();
    }

    protected void updateAppendReplace() {
    }

    private void handleEnvEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.environmentTable.getSelection();
        EnvironmentVariable var = (EnvironmentVariable)sel.getFirstElement();
        if (var == null) {
            return;
        }
        String originalName = var.getName();
        String value = var.getValue();
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_11);
        dialog.addTextField(NAME_LABEL, originalName, false);
        dialog.addVariablesField(VALUE_LABEL, value, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        value = dialog.getStringValue(VALUE_LABEL);
        if (!originalName.equals(name)) {
            if (this.addVariable(new EnvironmentVariable(name, value))) {
                this.environmentTable.remove((Object)var);
            }
        } else {
            var.setValue(value);
            this.environmentTable.update((Object)var, null);
        }
    }

    protected boolean addVariable(EnvironmentVariable variable) {
        String name = variable.getName();
        TableItem[] items = this.environmentTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable existingVariable = (EnvironmentVariable)items[i].getData();
            if (existingVariable.getName().equals(name)) {
                boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)LaunchConfigurationsMessages.EnvironmentTab_12, (String)MessageFormat.format(LaunchConfigurationsMessages.EnvironmentTab_13, name));
                if (!overWrite) {
                    return false;
                }
                this.environmentTable.remove((Object)existingVariable);
                break;
            }
            ++i;
        }
        this.environmentTable.add((Object)variable);
        return true;
    }

    private void createDescComposite(Composite parent) {
        Label l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(LaunchConfigurationsMessages.EnvironmentTab_Environment_variables_to_set__3);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = false;
        l.setLayoutData((Object)gd);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void okPressed() {
        TableItem[] items = this.environmentTable.getTable().getItems();
        this.envMap = new HashMap(items.length);
        int i = 0;
        while (i < items.length) {
            EnvironmentVariable var = (EnvironmentVariable)items[i].getData();
            this.envMap.put(var.getName(), var.getValue());
            ++i;
        }
        super.okPressed();
    }

    public Map getEnvs() {
        return this.envMap;
    }

    private Map getNativeEnvironment() {
        Map stringVars = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        HashMap<String, EnvironmentVariable> vars = new HashMap<String, EnvironmentVariable>();
        for (String key : stringVars.keySet()) {
            String value = (String)stringVars.get(key);
            vars.put(key, new EnvironmentVariable(key, value));
        }
        return vars;
    }

    private static class EnvironmentVariableContentProvider
    implements IStructuredContentProvider {
        private EnvironmentVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = new EnvironmentVariable[]{};
            Map m = (Map)inputElement;
            if (m != null && !m.isEmpty()) {
                elements = new EnvironmentVariable[m.size()];
                String[] varNames = new String[m.size()];
                m.keySet().toArray(varNames);
                int i = 0;
                while (i < m.size()) {
                    elements[i] = new EnvironmentVariable(varNames[i], (String)m.get(varNames[i]));
                    ++i;
                }
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            if (viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)viewer;
                if (tableViewer.getTable().isDisposed()) {
                    return;
                }
                tableViewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer iviewer, Object e1, Object e2) {
                        if (e1 == null) {
                            return -1;
                        }
                        if (e2 == null) {
                            return 1;
                        }
                        return ((EnvironmentVariable)e1).getName().compareToIgnoreCase(((EnvironmentVariable)e2).getName());
                    }
                });
            }
        }
    }

    private static class EnvironmentVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private EnvironmentVariableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getName();
                        break;
                    }
                    case 1: {
                        result = var.getValue();
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return DebugPluginImages.getImage((String)"IMG_OBJS_ENV_VAR");
            }
            return null;
        }
    }

    private static class NativeEnvironmentSelectionDialog
    extends AbstractDebugCheckboxSelectionDialog {
        private Object fInput;

        public NativeEnvironmentSelectionDialog(Shell parentShell, Object input) {
            super(parentShell);
            this.fInput = input;
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.setShowSelectAllButtons(true);
        }

        protected String getDialogSettingsId() {
            return "org.eclipse.debug.ui.ENVIRONMENT_TAB.NATIVE_ENVIROMENT_DIALOG";
        }

        protected String getHelpContextId() {
            return "org.eclipse.debug.ui.select_native_environment_dialog";
        }

        protected Object getViewerInput() {
            return this.fInput;
        }

        protected String getViewerLabel() {
            return LaunchConfigurationsMessages.EnvironmentTab_19;
        }

        protected IBaseLabelProvider getLabelProvider() {
            return new ILabelProvider(){

                public Image getImage(Object element) {
                    return DebugPluginImages.getImage((String)"IMG_OBJS_ENVIRONMENT");
                }

                public String getText(Object element) {
                    EnvironmentVariable var = (EnvironmentVariable)element;
                    return MessageFormat.format(LaunchConfigurationsMessages.EnvironmentTab_7, var.getName(), var.getValue());
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
        }

        protected IContentProvider getContentProvider() {
            return new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    EnvironmentVariable[] elements = null;
                    if (inputElement instanceof HashMap) {
                        Comparator comparator = new Comparator(){

                            public int compare(Object o1, Object o2) {
                                String s1 = (String)o1;
                                String s2 = (String)o2;
                                return s1.compareTo(s2);
                            }
                        };
                        TreeMap envVars = new TreeMap(comparator);
                        envVars.putAll((Map)inputElement);
                        elements = new EnvironmentVariable[envVars.size()];
                        int index = 0;
                        for (Object key : envVars.keySet()) {
                            elements[index] = (EnvironmentVariable)envVars.get(key);
                            ++index;
                        }
                    }
                    return elements;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
        }
    }
}

