/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.tizen.nativeplatform.launcher.factory.PkgFilterFactory;
import org.tizen.nativeplatform.launcher.rpm.IPkgFilter;
import org.tizen.nativeplatform.launcher.rpm.RpmPackageLauncher;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchSettingPkgPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformCommonLaunchWizard;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.nativeplatform.util.PlatformProjectUtil;

public class PlatformInstallAsWizard
extends PlatformCommonLaunchWizard {
    private IPkgFilter pkgFilter;
    private PkgCommandTarget target;
    private static final String SETTING_PKG_PAGE = "setting_pkg";

    public PlatformInstallAsWizard() {
    }

    public PlatformInstallAsWizard(Shell shell, ILaunchConfiguration launchConfig, IProject project, IConfiguration config, PkgCommandTarget target, String mode, boolean isEFL) {
        super(shell, launchConfig, project, config, target, mode);
        this.setWindowTitle("Install Packages Configuration");
        this.target = target;
        this.pkgFilter = PkgFilterFactory.getFilter(PlatformProjectUtil.getPkgType());
    }

    @Override
    public boolean performFinish() {
        PlatformLaunchSettingPkgPage settingPkgPage = (PlatformLaunchSettingPkgPage)this.getContainer().getCurrentPage();
        if (settingPkgPage.getName().equals(SETTING_PKG_PAGE)) {
            PlatformLaunchSettingPkgPage pkgPage = settingPkgPage;
            pkgPage.savePkgInstallInfo();
            final List<IPackage> checkedDevicePkgs = pkgPage.getCheckedDevicePackage();
            final List<IPackage> checkedRootstrapPkgs = pkgPage.getCheckedRootstrapPackage();
            IWizardContainer container = this.getContainer();
            try {
                try {
                    container.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("", 1);
                            PlatformInstallAsWizard.this.deviceLog = "";
                            PlatformInstallAsWizard.this.rootstrapLog = "";
                            PlatformInstallAsWizard.this.devicePackages.clear();
                            PlatformInstallAsWizard.this.rootstrapPackages.clear();
                            if (checkedDevicePkgs != null && !checkedDevicePkgs.isEmpty()) {
                                PlatformInstallAsWizard.this.devicePackages.addAll(PlatformInstallAsWizard.this.pkgFilter.filter(CmdTargetTypes.DEVICE, checkedDevicePkgs));
                            }
                            if (checkedRootstrapPkgs != null && !checkedRootstrapPkgs.isEmpty()) {
                                PlatformInstallAsWizard.this.rootstrapPackages.addAll(PlatformInstallAsWizard.this.pkgFilter.filter(CmdTargetTypes.ROOTSTRAP, checkedRootstrapPkgs));
                            }
                            PlatformInstallAsWizard.this.reinstallOp = true;
                            RpmPackageLauncher pkgLauncher = new RpmPackageLauncher(PlatformInstallAsWizard.this.project, PlatformInstallAsWizard.this.target, PlatformInstallAsWizard.this.devicePackages, PlatformInstallAsWizard.this.rootstrapPackages, PlatformInstallAsWizard.this.reinstallOp);
                            try {
                                try {
                                    pkgLauncher.launchPkgs(PlatformInstallAsWizard.this.shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                catch (InterruptedException e) {
                                    new InterruptedException(e.getMessage());
                                    monitor.done();
                                    PlatformInstallAsWizard.this.rootstrapLog = pkgLauncher.getRootstrapLog();
                                    PlatformInstallAsWizard.this.deviceLog = pkgLauncher.getDeviceLog();
                                }
                            }
                            finally {
                                monitor.done();
                                PlatformInstallAsWizard.this.rootstrapLog = pkgLauncher.getRootstrapLog();
                                PlatformInstallAsWizard.this.deviceLog = pkgLauncher.getDeviceLog();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.openErrorDialog(e.toString());
                    IPkgCommander ipkgCommander = this.target.getCommander(CmdTargetTypes.DEVICE);
                    ipkgCommander.getOutputReceiver().getMsgConsoleStream().print("**** Install Finished ****");
                }
            }
            finally {
                IPkgCommander ipkgCommander = this.target.getCommander(CmdTargetTypes.DEVICE);
                ipkgCommander.getOutputReceiver().getMsgConsoleStream().print("**** Install Finished ****");
            }
        }
        return true;
    }

    @Override
    public void addPages() {
        PlatformLaunchSettingPkgPage page1 = new PlatformLaunchSettingPkgPage(this, this.shell, SETTING_PKG_PAGE, this.project, this.config, this.target);
        page1.setOnlyInstallPackage();
        page1.disableRootstrapGroup();
        this.addPage((IWizardPage)page1);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener((IPageChangedListener)this);
        dialog.addPageChangingListener((IPageChangingListener)this);
    }

    private void setSmackRule() {
        String[] programPaths = PlatformLaunchUtil.getProgramPath((IProject)this.project);
        if (programPaths == null || programPaths.length <= 0) {
            return;
        }
        IPkgCommander commander = this.target.getDeviceCommander();
        StringBuffer pathlist = new StringBuffer();
        String[] stringArray = programPaths;
        int n = programPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            pathlist.append(path);
            pathlist.append(" ");
            ++n2;
        }
        String list = pathlist.toString().trim();
        Map smackInfo = PlatformLaunchUtil.getSmackInfo((IPkgCommander)commander, (String)list);
        if (smackInfo == null) {
            return;
        }
        for (String filepath : smackInfo.keySet()) {
            String[] labels = (String[])smackInfo.get(filepath);
            String a_label = labels[0];
            if (a_label != null && !a_label.isEmpty()) {
                commander.executeBinaryBySudo(this.getSmackRuleCommand(a_label));
            }
            commander.setSmackExecute(filepath, "\"\"");
        }
    }

    private String getSmackRuleCommand(String value) {
        value = value.replaceAll("\"", "");
        String cmd = String.format("echo \"sdbd::home %s rwx\" | smackload", value);
        return cmd;
    }
}

