/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor;

import com.cthing.cmakeed.ui.CMakeEditorPlugin;
import com.cthing.cmakeed.ui.Messages;
import com.cthing.cmakeed.ui.editor.CMakeDocumentSetupParticipant;
import com.cthing.cmakeed.ui.editor.CMakeEditorConfiguration;
import com.cthing.cmakeed.ui.editor.ColorMgr;
import com.cthing.cmakeed.ui.prefs.Preferences;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CMakeEditor
extends AbstractDecoratedTextEditor
implements IPropertyChangeListener {
    private StyledText text;
    private ColorMgr colorMgr;
    private VerifyListener tabReplacer = new /* Unavailable Anonymous Inner Class!! */;

    public CMakeEditor() {
        TextFileDocumentProvider provider = new TextFileDocumentProvider();
        provider = new ForwardingDocumentProvider("__cmake_partitioning", (IDocumentSetupParticipant)new CMakeDocumentSetupParticipant(), (IDocumentProvider)provider);
        this.setDocumentProvider((IDocumentProvider)provider);
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.text = this.getSourceViewer().getTextWidget();
        this.updateTabReplacer();
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(Messages.getResourceBundle(), "ContentProposal.", (ITextEditor)this);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    public Object getAdapter(Class key) {
        if (key.equals(ISourceViewer.class)) {
            return this.getSourceViewer();
        }
        if (key.equals(StyledText.class)) {
            return this.text;
        }
        return super.getAdapter(key);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        if (this.colorMgr == null) {
            this.colorMgr = new ColorMgr();
        }
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new CMakeEditorConfiguration(this.colorMgr));
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        CMakeEditorPlugin.getDefault().getCMakePartitionScanner().removeUserVariableRule();
    }

    public void doSave(IProgressMonitor prog) {
        IDocumentExtension3 extension3;
        IDocumentPartitioner partitioner;
        super.doSave(prog);
        CMakeEditorPlugin.getDefault().getCMakePartitionScanner().setDefaultScannerRules();
        IDocument document = this.getSourceViewer().getDocument();
        if (document instanceof IDocumentExtension3 && (partitioner = (extension3 = (IDocumentExtension3)document).getDocumentPartitioner("__cmake_partitioning")) != null) {
            partitioner.disconnect();
            partitioner.connect(document);
            SourceViewer sourceViewer = (SourceViewer)this.getSourceViewer();
            int line = sourceViewer.getTopIndex();
            ITextSelection sel = (ITextSelection)sourceViewer.getSelection();
            sourceViewer.unconfigure();
            CMakeEditorConfiguration config = new CMakeEditorConfiguration(this.colorMgr);
            sourceViewer.configure((SourceViewerConfiguration)config);
            sourceViewer.refresh();
            sourceViewer.setTopIndex(line);
            sourceViewer.setSelectedRange(sel.getOffset(), sel.getLength());
        }
        CMakeEditorPlugin.getDefault().getCMakePartitionScanner().removeUserVariableRule();
    }

    public void dispose() {
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
        this.colorMgr.dispose();
        super.dispose();
    }

    private void updateTabReplacer() {
        IPreferenceStore prefStore = CMakeEditorPlugin.getDefault().getPreferenceStore();
        if (prefStore.getBoolean("spacesForTabsPref")) {
            this.text.addVerifyListener(this.tabReplacer);
        } else {
            this.text.removeVerifyListener(this.tabReplacer);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event == null || event.getProperty().equals("spacesForTabsPref")) {
            this.updateTabReplacer();
        }
        if (event == null || Preferences.isTextPreference((String)event.getProperty())) {
            SourceViewer sourceViewer = (SourceViewer)this.getSourceViewer();
            int line = sourceViewer.getTopIndex();
            sourceViewer.unconfigure();
            CMakeEditorConfiguration config = new CMakeEditorConfiguration(this.colorMgr);
            sourceViewer.configure((SourceViewerConfiguration)config);
            sourceViewer.refresh();
            sourceViewer.setTopIndex(line);
        }
    }

    public SourceViewer getCMakeEditorSourceViewer() {
        return (SourceViewer)this.getSourceViewer();
    }

    static /* synthetic */ StyledText access$0(CMakeEditor cMakeEditor) {
        return cMakeEditor.text;
    }
}

