/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor;

import com.cthing.cmakeed.core.commands.CMakeCommand;
import com.cthing.cmakeed.core.commands.CMakeCommands;
import com.cthing.cmakeed.core.properties.CMakeProperties;
import com.cthing.cmakeed.core.properties.CMakeProperty;
import com.cthing.cmakeed.core.reservedwords.CMakeReservedWord;
import com.cthing.cmakeed.core.reservedwords.CMakeReservedWords;
import com.cthing.cmakeed.core.variables.CMakeVariable;
import com.cthing.cmakeed.core.variables.CMakeVariables;
import com.cthing.cmakeed.ui.CMakeEditorPlugin;
import com.cthing.cmakeed.ui.editor.CMakePartitionScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.ICharacterScanner;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EditorUtils {
    public static final char START_ARGS = '(';
    public static final char END_ARGS = ')';
    public static final char SPACE = ' ';
    public static final char DOLLAR = '$';
    public static final char OPEN_BRACKET = '{';
    public static final char CLOSE_BRACKET = '}';

    private EditorUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean inArguments(IDocument doc, int offset) {
        if (offset >= doc.getLength()) {
            return false;
        }
        try {
            if (doc.getChar(offset) == ')') {
                return true;
            }
            int off = offset;
            while (true) {
                if (off < 0) {
                    return false;
                }
                char ch = doc.getChar(off);
                if (ch == '(') {
                    return true;
                }
                if (ch == ')') {
                    return false;
                }
                --off;
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
        }
        return false;
    }

    public static boolean isNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '/' || c == '_' || c == '.' || c == '+' || c == '-';
    }

    public static boolean startOfWord(IDocument doc, int offset) {
        try {
            char ch = doc.getChar(offset - 1);
            return !EditorUtils.isNameChar((char)ch);
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
            return false;
        }
    }

    public static boolean startOfVariableReference(IDocument doc, int offset) {
        try {
            char dollar = doc.getChar(offset - 1);
            char bracket = doc.getChar(offset);
            return dollar == '$' && bracket == '{';
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean firstArgument(IDocument doc, int offset) {
        try {
            int index = 1;
            char currentChar = doc.getChar(offset - index);
            if (offset == 0) {
                return false;
            }
            while (true) {
                if (currentChar != ' ') {
                    return currentChar == '(';
                }
                currentChar = doc.getChar(offset - ++index);
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
            return false;
        }
    }

    public static CMakeCommand getCommand(ITextViewer viewer, int offset) {
        return EditorUtils.getCommand((IDocument)viewer.getDocument(), (int)offset);
    }

    public static CMakeCommand getCommand(IDocument doc, int offset) {
        return CMakeCommands.getCommand((String)EditorUtils.getCommandName((IDocument)doc, (int)offset));
    }

    public static CMakeProperty getProperty(IDocument doc, int offset) {
        return CMakeProperties.getCommand((String)EditorUtils.getPropertyName((IDocument)doc, (int)offset));
    }

    public static String getPropertyName(ITextViewer viewer, int offset) {
        return EditorUtils.getPropertyName((IDocument)viewer.getDocument(), (int)offset);
    }

    public static String getPropertyName(IDocument doc, int offset) {
        String cmd = null;
        try {
            String contentType = doc.getContentType(offset);
            if (CMakePartitionScanner.isProperty((String)contentType)) {
                ITypedRegion region = doc.getPartition(offset);
                cmd = doc.get(region.getOffset(), region.getLength());
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
        }
        return cmd;
    }

    public static CMakeVariable getVariable(IDocument doc, int offset) {
        return CMakeVariables.getCommand((String)EditorUtils.getVariableName((IDocument)doc, (int)offset));
    }

    public static String getVariableName(ITextViewer viewer, int offset) {
        return EditorUtils.getVariableName((IDocument)viewer.getDocument(), (int)offset);
    }

    public static String getVariableName(IDocument doc, int offset) {
        String cmd = null;
        try {
            String contentType = doc.getContentType(offset);
            if (CMakePartitionScanner.isVariable((String)contentType)) {
                ITypedRegion region = doc.getPartition(offset);
                cmd = doc.get(region.getOffset(), region.getLength());
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
        }
        return cmd;
    }

    public static CMakeReservedWord getReservedWord(IDocument doc, int offset) {
        return CMakeReservedWords.getCommand((String)EditorUtils.getReservedWordName((IDocument)doc, (int)offset));
    }

    public static String getReservedWordName(ITextViewer viewer, int offset) {
        return EditorUtils.getReservedWordName((IDocument)viewer.getDocument(), (int)offset);
    }

    public static String getReservedWordName(IDocument doc, int offset) {
        String cmd = null;
        try {
            String contentType = doc.getContentType(offset);
            if (CMakePartitionScanner.isReservedWord((String)contentType)) {
                ITypedRegion region = doc.getPartition(offset);
                cmd = doc.get(region.getOffset(), region.getLength());
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
        }
        return cmd;
    }

    public static String getCommandName(ITextViewer viewer, int offset) {
        return EditorUtils.getCommandName((IDocument)viewer.getDocument(), (int)offset);
    }

    public static String getCommandName(IDocument doc, int offset) {
        String cmd = null;
        try {
            String contentType = doc.getContentType(offset);
            if (CMakePartitionScanner.isAnyCommand((String)contentType)) {
                ITypedRegion region = doc.getPartition(offset);
                cmd = doc.get(region.getOffset(), region.getLength());
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
        }
        return cmd;
    }

    public static CMakeCommand findContainingCommand(IDocument doc, int offset) {
        try {
            int pos = offset;
            while (pos >= 0) {
                String contentType = doc.getContentType(pos);
                if (!CMakePartitionScanner.isComment((String)contentType) && !CMakePartitionScanner.isArgsClose((String)contentType)) {
                    CMakeCommand cmd = EditorUtils.getCommand((IDocument)doc, (int)pos);
                    if (cmd != null) {
                        return cmd;
                    }
                    ITypedRegion region = doc.getPartition(pos);
                    pos = region.getOffset() - 1;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
        }
        return null;
    }

    public static CMakeProperty findContainingProperty(IDocument doc, int offset) {
        try {
            int pos = offset;
            while (pos >= 0) {
                String contentType = doc.getContentType(pos);
                if (!CMakePartitionScanner.isComment((String)contentType) && !CMakePartitionScanner.isArgsClose((String)contentType)) {
                    CMakeProperty cmd = EditorUtils.getProperty((IDocument)doc, (int)pos);
                    if (cmd != null) {
                        return cmd;
                    }
                    ITypedRegion region = doc.getPartition(pos);
                    pos = region.getOffset() - 1;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
        }
        return null;
    }

    public static CMakeVariable findContainingVariable(IDocument doc, int offset) {
        try {
            int pos = offset;
            while (pos >= 0) {
                String contentType = doc.getContentType(pos);
                if (!CMakePartitionScanner.isComment((String)contentType) && !CMakePartitionScanner.isArgsClose((String)contentType)) {
                    CMakeVariable cmd = EditorUtils.getVariable((IDocument)doc, (int)pos);
                    if (cmd != null) {
                        return cmd;
                    }
                    ITypedRegion region = doc.getPartition(pos);
                    pos = region.getOffset() - 1;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
        }
        return null;
    }

    public static CMakeReservedWord findContainingReservedWord(IDocument doc, int offset) {
        try {
            int pos = offset;
            while (pos >= 0) {
                String contentType = doc.getContentType(pos);
                if (!CMakePartitionScanner.isComment((String)contentType) && !CMakePartitionScanner.isArgsClose((String)contentType)) {
                    CMakeReservedWord cmd = EditorUtils.getReservedWord((IDocument)doc, (int)pos);
                    if (cmd != null) {
                        return cmd;
                    }
                    ITypedRegion region = doc.getPartition(pos);
                    pos = region.getOffset() - 1;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError(EditorUtils.class, (Throwable)e);
        }
        return null;
    }

    public static void unread(ICharacterScanner scanner, StringBuilder buf) {
        int len = buf.length();
        while (len-- > 0) {
            scanner.unread();
        }
    }
}

