/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor.rules;

import com.cthing.cmakeed.core.commands.CMakeCommand;
import com.cthing.cmakeed.core.commands.CMakeCommands;
import com.cthing.cmakeed.ui.CMakeEditorPlugin;
import com.cthing.cmakeed.ui.editor.CMakeNameDetector;
import com.cthing.cmakeed.ui.editor.CMakePartitionScanner;
import com.cthing.cmakeed.ui.editor.EditorUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class CMakeCommandRule
implements IRule,
IPredicateRule {
    private IToken commandToken;
    private boolean findDeprecated;
    private IWordDetector detector = new CMakeNameDetector();
    private StringBuilder buffer = new StringBuilder();
    private int lastOffsetUsedStart = 0;
    private int lastOffsetUsedEnd = 1;

    public CMakeCommandRule(IToken commandToken, boolean findDeprecated) {
        this.commandToken = commandToken;
        this.findDeprecated = findDeprecated;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        CMakePartitionScanner cscan = (CMakePartitionScanner)scanner;
        IDocument doc = cscan.getDocument();
        int offset = cscan.getOffset();
        if (offset > this.lastOffsetUsedStart && offset < this.lastOffsetUsedEnd) {
            return Token.UNDEFINED;
        }
        String prefix = "";
        try {
            char c = doc.getChar(offset);
            if (this.detector.isWordPart(c)) {
                prefix = this.getPrefix(doc, offset);
            }
        }
        catch (BadLocationException c) {
            // empty catch block
        }
        this.buffer.setLength(0);
        int ch = scanner.read();
        while (ch != -1 && this.detector.isWordPart((char)ch)) {
            this.buffer.append((char)ch);
            ch = scanner.read();
        }
        scanner.unread();
        CMakeCommand cmd = CMakeCommands.getCommand((String)(String.valueOf(prefix) + this.buffer.toString()));
        if (cmd != null && cmd.isDeprecated() == this.findDeprecated && scanner instanceof CMakePartitionScanner && !EditorUtils.inArguments((IDocument)doc, (int)(offset = cscan.getTokenOffset()))) {
            this.lastOffsetUsedEnd = -1;
            this.lastOffsetUsedStart = -2;
            int index = 0;
            while (index < this.buffer.length()) {
                this.buffer.setCharAt(index, '\u0000');
                ++index;
            }
            return this.commandToken;
        }
        this.lastOffsetUsedEnd = cscan.getOffset();
        EditorUtils.unread((ICharacterScanner)scanner, (StringBuilder)this.buffer);
        this.lastOffsetUsedStart = cscan.getOffset();
        return Token.UNDEFINED;
    }

    private String getPrefix(IDocument doc, int offset) {
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                if (!this.detector.isWordPart(c)) {
                    return doc.get(n + 1, offset - n - 1);
                }
                if (n == 0) {
                    return doc.get(n, offset - n);
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            CMakeEditorPlugin.logError((Object)this, (Throwable)e);
        }
        return "";
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken getSuccessToken() {
        return this.commandToken;
    }
}

