/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.prefs;

import com.cthing.cmakeed.ui.CMakeEditorPlugin;
import com.cthing.cmakeed.ui.Messages;
import com.cthing.cmakeed.ui.prefs.Preferences;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Map<String, RGB> colorMap = new HashMap();
    private Map<String, Integer> styleMap = new HashMap();
    private Button upperCaseCommandsB;
    private Button spacesForTabsB;
    private ListViewer textAttrViewer;
    private ColorSelector colorB;
    private Button boldB;
    private Button italicB;
    private Button underlineB;
    private Button strikeB;

    public PrefPage() {
        this.setPreferenceStore(CMakeEditorPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite topComp = new Composite(parent, 0);
        topComp.setLayout((Layout)new GridLayout(1, false));
        Control control = this.createHeader(topComp);
        control.setLayoutData((Object)new GridData());
        Composite upperCaseCommandsComp = new Composite(topComp, 0);
        upperCaseCommandsComp.setLayoutData((Object)new GridData());
        upperCaseCommandsComp.setLayout((Layout)new GridLayout(2, false));
        this.upperCaseCommandsB = new Button(upperCaseCommandsComp, 32);
        this.upperCaseCommandsB.setLayoutData((Object)new GridData());
        Label upperCaseCommandsL = new Label(upperCaseCommandsComp, 0);
        upperCaseCommandsL.setLayoutData((Object)new GridData());
        upperCaseCommandsL.setText(Messages.getString((String)"PreferencePage.UpperCaseCommands"));
        Composite spacesComp = new Composite(topComp, 0);
        spacesComp.setLayoutData((Object)new GridData());
        spacesComp.setLayout((Layout)new GridLayout(2, false));
        this.spacesForTabsB = new Button(spacesComp, 32);
        this.spacesForTabsB.setLayoutData((Object)new GridData());
        Label spacesForTabsL = new Label(spacesComp, 0);
        spacesForTabsL.setLayoutData((Object)new GridData());
        spacesForTabsL.setText(Messages.getString((String)"PreferencePage.SpacesForTabs"));
        Composite textComp = new Composite(topComp, 0);
        textComp.setLayoutData((Object)new GridData());
        textComp.setLayout((Layout)new GridLayout(2, false));
        Label attrL = new Label(textComp, 0);
        GridData attrData = new GridData();
        attrData.horizontalSpan = 2;
        attrL.setLayoutData((Object)attrData);
        attrL.setText(Messages.getString((String)"PreferencePage.Attributes"));
        this.textAttrViewer = new ListViewer(textComp, 2564);
        this.textAttrViewer.getList().setLayoutData((Object)new GridData(1, 1, false, false));
        this.textAttrViewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.textAttrViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.textAttrViewer.setSorter((ViewerSorter)new /* Unavailable Anonymous Inner Class!! */);
        this.textAttrViewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite styleComp = new Composite(textComp, 0);
        styleComp.setLayoutData((Object)new GridData(0, 1, false, false));
        styleComp.setLayout((Layout)new GridLayout(2, false));
        Label colorL = new Label(styleComp, 0);
        colorL.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        colorL.setText(Messages.getString((String)"PreferencePage.Color"));
        this.colorB = new ColorSelector(styleComp);
        this.colorB.getButton().setLayoutData((Object)new GridData());
        this.colorB.addListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.boldB = new Button(styleComp, 32);
        this.boldB.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.boldB.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Label boldL = new Label(styleComp, 0);
        boldL.setLayoutData((Object)new GridData());
        boldL.setText(Messages.getString((String)"PreferencePage.Bold"));
        this.italicB = new Button(styleComp, 32);
        this.italicB.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.italicB.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Label italicL = new Label(styleComp, 0);
        italicL.setLayoutData((Object)new GridData());
        italicL.setText(Messages.getString((String)"PreferencePage.Italic"));
        this.underlineB = new Button(styleComp, 32);
        this.underlineB.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.underlineB.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Label underlineL = new Label(styleComp, 0);
        underlineL.setLayoutData((Object)new GridData());
        underlineL.setText(Messages.getString((String)"PreferencePage.Underline"));
        this.strikeB = new Button(styleComp, 32);
        this.strikeB.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.strikeB.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Label strikeL = new Label(styleComp, 0);
        strikeL.setLayoutData((Object)new GridData());
        strikeL.setText(Messages.getString((String)"PreferencePage.Strike"));
        this.init(CMakeEditorPlugin.getDefault().getWorkbench());
        return topComp;
    }

    private Control createHeader(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(Messages.getString((String)"PreferencePage.AdditionalPrefs"));
        String target = "org.eclipse.ui.preferencePages.GeneralTextEditor";
        link.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        String linktooltip = Messages.getString((String)"PreferencePage.AdditionalTip");
        link.setToolTipText(linktooltip);
        return link;
    }

    public void init(IWorkbench workbench) {
        if (this.textAttrViewer != null) {
            this.textAttrViewer.setInput((Object)Preferences.TEXT_KEYS);
            this.textAttrViewer.getList().select(0);
            this.textAttrViewer.getList().showSelection();
            IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
            this.spacesForTabsB.setSelection(store.getBoolean("spacesForTabsPref"));
            this.upperCaseCommandsB.setSelection(store.getBoolean("upperCaseCommands"));
            this.readTextPrefs();
            this.writeTextUI();
        }
    }

    private String getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.textAttrViewer.getSelection();
        return (String)selection.getFirstElement();
    }

    private void readTextPrefs() {
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        String[] stringArray = Preferences.TEXT_KEYS;
        int n = Preferences.TEXT_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String baseKey = stringArray[n2];
            this.colorMap.put(baseKey, PreferenceConverter.getColor((IPreferenceStore)store, (String)Preferences.getColorKey((Object)baseKey)));
            this.styleMap.put(baseKey, store.getInt(Preferences.getStyleKey((Object)baseKey)));
            ++n2;
        }
    }

    private void writeTextPrefs() {
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        String[] stringArray = Preferences.TEXT_KEYS;
        int n = Preferences.TEXT_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String baseKey = stringArray[n2];
            PreferenceConverter.setValue((IPreferenceStore)store, (String)Preferences.getColorKey((Object)baseKey), (RGB)((RGB)this.colorMap.get(baseKey)));
            store.setValue(Preferences.getStyleKey((Object)baseKey), ((Integer)this.styleMap.get(baseKey)).intValue());
            this.colorMap.put(baseKey, PreferenceConverter.getColor((IPreferenceStore)store, (String)Preferences.getColorKey((Object)baseKey)));
            this.styleMap.put(baseKey, store.getInt(Preferences.getStyleKey((Object)baseKey)));
            ++n2;
        }
    }

    private void writeTextUI() {
        String baseKey = this.getSelection();
        this.colorB.setColorValue((RGB)this.colorMap.get(baseKey));
        int style = (Integer)this.styleMap.get(baseKey);
        this.boldB.setSelection((style & 1) != 0);
        this.italicB.setSelection((style & 2) != 0);
        this.underlineB.setSelection((style & 0x40000000) != 0);
        this.strikeB.setSelection((style & 0x20000000) != 0);
    }

    private void readTextUI() {
        String baseKey = this.getSelection();
        RGB color = this.colorB.getColorValue();
        this.colorMap.put(baseKey, color);
        int bold = this.boldB.getSelection() ? 1 : 0;
        int italic = this.italicB.getSelection() ? 2 : 0;
        int underline = this.underlineB.getSelection() ? 0x40000000 : 0;
        int strike = this.strikeB.getSelection() ? 0x20000000 : 0;
        int style = bold | italic | underline | strike;
        this.styleMap.put(baseKey, style);
    }

    protected void performDefaults() {
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        String[] stringArray = Preferences.TEXT_KEYS;
        int n = Preferences.TEXT_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String baseKey = stringArray[n2];
            this.colorMap.put(baseKey, PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)Preferences.getColorKey((Object)baseKey)));
            this.styleMap.put(baseKey, store.getDefaultInt(Preferences.getStyleKey((Object)baseKey)));
            ++n2;
        }
        this.writeTextUI();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        store.setValue("spacesForTabsPref", this.spacesForTabsB.getSelection());
        store.setValue("upperCaseCommands", this.upperCaseCommandsB.getSelection());
        this.writeTextPrefs();
        return super.performOk();
    }

    static /* synthetic */ void access$0(PrefPage prefPage) {
        prefPage.writeTextUI();
    }

    static /* synthetic */ void access$1(PrefPage prefPage) {
        prefPage.readTextUI();
    }
}

