/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.nativeplatform.rootstrap.util.GBSConfFile;

public class GBSConfParser {
    public static final Logger logger = LoggerFactory.getLogger(GBSConfParser.class);
    private static final String BUNDLE_NAME = String.valueOf(GBSConfParser.class.getPackage().getName()) + ".DeviceRepoLoaderUIMessages";
    private static ResourceBundle resources = ResourceBundle.getBundle(BUNDLE_NAME);
    private static byte enableSectionFlag = 0;
    private static byte generalSectionFlag = 1;
    private static byte obsSectionFlag = (byte)2;
    private static byte profileSectionFlag = (byte)4;
    private static byte repoSectionFlag = (byte)8;

    public static GBSConfFile parse(File gbsConfFile, IProgressMonitor monitor) {
        GBSConfFile confFile = GBSConfParser.readGBSConfFile(gbsConfFile);
        if (confFile != null) {
            for (GBSConfFile.ProfileSection profileSection : confFile.profileSections) {
                String[] repos;
                String value = profileSection.getConfiguration("repos");
                if (value == null) continue;
                String[] stringArray = repos = value.split(",");
                int n = repos.length;
                int n2 = 0;
                while (n2 < n) {
                    String repoName = stringArray[n2];
                    GBSConfFile.RepositorySection section = GBSConfParser.findRepoSection(confFile, repoName.trim());
                    if (section != null) {
                        profileSection.addRepoSection(section);
                    }
                    ++n2;
                }
            }
            String profile = confFile.generalSection.getConfiguration("profile");
            GBSConfFile.ProfileSection section = GBSConfParser.findProfileSection(confFile, profile.trim());
            if (section != null) {
                confFile.generalSection.setProfileSection(section);
            }
        }
        return confFile;
    }

    private static GBSConfFile.RepositorySection findRepoSection(GBSConfFile confFile, String name) {
        for (GBSConfFile.RepositorySection section : confFile.repoSections) {
            if (!section.getName().equals(name)) continue;
            return section;
        }
        return null;
    }

    private static GBSConfFile.ProfileSection findProfileSection(GBSConfFile confFile, String name) {
        for (GBSConfFile.ProfileSection section : confFile.profileSections) {
            if (!section.getName().equals(name)) continue;
            return section;
        }
        return null;
    }

    private static boolean isGeneralSectionEnabled() {
        return (enableSectionFlag & generalSectionFlag) > 0;
    }

    private static boolean isObsSectionEnabled() {
        return (enableSectionFlag & obsSectionFlag) > 0;
    }

    private static boolean isProfileSectionEnabled() {
        return (enableSectionFlag & profileSectionFlag) > 0;
    }

    private static boolean isRepoSectionEnabled() {
        return (enableSectionFlag & repoSectionFlag) > 0;
    }

    private static GBSConfFile readGBSConfFile(File file) {
        GBSConfFile confFile;
        block17: {
            confFile = null;
            if (file != null) {
                confFile = new GBSConfFile();
                InputStreamReader isr = null;
                BufferedReader reader = null;
                FileInputStream fs = null;
                if (confFile != null) {
                    try {
                        fs = new FileInputStream(file);
                        isr = new InputStreamReader((InputStream)fs, "UTF-8");
                        reader = new BufferedReader(isr);
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).startsWith("[general]")) {
                                enableSectionFlag = generalSectionFlag;
                                confFile.createNewGeneralSection();
                                confFile.setGeneralSectionName(line);
                                continue;
                            }
                            if (line.startsWith("[obs.")) {
                                enableSectionFlag = obsSectionFlag;
                                confFile.createNewOBSSection();
                                confFile.setOBSSectionName(line);
                                continue;
                            }
                            if (line.startsWith("[profile.")) {
                                enableSectionFlag = profileSectionFlag;
                                confFile.createNewProfileSection();
                                confFile.setProfileSectionName(line);
                                continue;
                            }
                            if (line.startsWith("[repo.")) {
                                enableSectionFlag = repoSectionFlag;
                                confFile.createNewRepoSection();
                                confFile.setRepoSectionName(line);
                                continue;
                            }
                            int idx = line.indexOf(61);
                            if (idx <= 0) continue;
                            String key = line.substring(0, idx).trim();
                            String value = line.substring(idx + 1).trim();
                            if (key.startsWith("#")) continue;
                            if (GBSConfParser.isGeneralSectionEnabled()) {
                                confFile.addGeneralConfiguration(key, value);
                                continue;
                            }
                            if (GBSConfParser.isObsSectionEnabled()) {
                                confFile.addOBSConfiguration(key, value);
                                continue;
                            }
                            if (GBSConfParser.isProfileSectionEnabled()) {
                                confFile.addProfileConfiguration(key, value);
                                continue;
                            }
                            if (!GBSConfParser.isRepoSectionEnabled()) continue;
                            confFile.addRepoConfiguration(key, value);
                        }
                        if (line == null) {
                            logger.debug("There is no read line string");
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        IOUtil.tryClose((Object[])new Object[]{fs, reader, isr});
                        break block17;
                    }
                    catch (IOException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            IOUtil.tryClose((Object[])new Object[]{fs, reader, isr});
                            throw throwable;
                        }
                        IOUtil.tryClose((Object[])new Object[]{fs, reader, isr});
                        break block17;
                    }
                    IOUtil.tryClose((Object[])new Object[]{fs, reader, isr});
                }
            }
        }
        return confFile;
    }
}

