/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.repo.commander.RepoManager;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapWizardData;

public class RootstrapSettingPage1
extends WizardPage {
    protected final String BUNDLE_NAME = String.valueOf(RootstrapSettingPage1.class.getPackage().getName()) + ".RootstrapWizardUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected IProject project;
    protected IConfiguration config;
    protected Shell shell;
    protected Text localRepoPath;
    protected Text confFilePath;
    protected List<Text> urlTextList;
    protected Combo preDefinedSnapshotCombo;
    protected Button remoteRepoButton;
    protected Button localRepoButton;
    protected Button localRepoPathButton;
    protected Button confFilePathButton;
    protected Composite snapshotComp;
    protected String[] predefinedSnapshots = null;
    protected boolean supportLocalRepo = false;
    protected int snapshotMaxSize = 2;
    protected final Logger logger = LoggerFactory.getLogger(RootstrapSettingPage1.class);

    public RootstrapSettingPage1(String pageName, Shell shell, IProject project, IConfiguration config) {
        super(pageName);
        this.shell = shell;
        this.project = project;
        this.config = config;
        this.setTitle(this.resources.getString("RootstrapPage1.Title"));
        this.setDescription(this.resources.getString("RootstrapPage.Remote.Desc"));
        this.setErrorMessage(null);
        this.initPredefinedSnapshots();
        this.urlTextList = new ArrayList<Text>();
        this.supportLocalRepo = RootstrapWizardData.isSupportLocalRepo();
    }

    public RootstrapSettingPage1(String pageName, Shell shell) {
        super(pageName);
        this.shell = shell;
    }

    protected void initPredefinedSnapshots() {
        this.predefinedSnapshots = RootstrapWizardData.getSnapshotMap().keySet().toArray(new String[0]);
        Arrays.sort(this.predefinedSnapshots);
        for (List<String> value : RootstrapWizardData.getSnapshotMap().values()) {
            int size = value.size();
            if (this.snapshotMaxSize >= size) continue;
            this.snapshotMaxSize = size;
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 0;
        composite.setLayoutData((Object)gridData);
        if (this.supportLocalRepo) {
            this.remoteRepoButton = new Button(composite, 16);
            this.remoteRepoButton.setText(this.resources.getString("RootstrapPage.RemoteRepo"));
            this.remoteRepoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    RootstrapSettingPage1.this.setMessage(RootstrapSettingPage1.this.resources.getString("RootstrapPage.Remote.Desc"));
                    RootstrapSettingPage1.this.enableRemoteRepoGroup(true);
                    RootstrapSettingPage1.this.enableLocalRepoGroup(false);
                    RootstrapWizardData.setRemoteRepoEnabled(true);
                    RootstrapSettingPage1.this.updatePageCompleted();
                }
            });
            this.createRemoteRepoControl(composite);
            new Label(composite, 0);
            this.localRepoButton = new Button(composite, 16);
            this.localRepoButton.setText(this.resources.getString("RootstrapPage.LocalRepo"));
            this.localRepoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    RootstrapSettingPage1.this.setMessage(RootstrapSettingPage1.this.resources.getString("RootstrapPage.Local.Desc"));
                    RootstrapSettingPage1.this.enableRemoteRepoGroup(false);
                    RootstrapSettingPage1.this.enableLocalRepoGroup(true);
                    RootstrapWizardData.setRemoteRepoEnabled(false);
                    RootstrapSettingPage1.this.updatePageCompleted();
                }
            });
            this.createLocalRepoControl(composite);
            this.enableLocalRepoGroup(false);
        } else {
            this.createRemoteRepoControl(composite);
        }
        this.setControl((Control)composite);
        if (this.remoteRepoButton != null) {
            this.remoteRepoButton.setSelection(true);
        }
        this.enableRemoteRepoGroup(true);
        this.updatePredefinedSnapshot();
    }

    private void enableRemoteRepoGroup(boolean enable) {
        this.preDefinedSnapshotCombo.setEnabled(enable);
        for (Text textControl : this.urlTextList) {
            textControl.setEnabled(enable);
        }
    }

    private void enableLocalRepoGroup(boolean enable) {
        this.localRepoPath.setEnabled(enable);
        this.confFilePath.setEnabled(enable);
        this.localRepoPathButton.setEnabled(enable);
        this.confFilePathButton.setEnabled(enable);
    }

    public void createRemoteRepoControl(Composite parent) {
        Group inputFileGroup = new Group(parent, 0);
        inputFileGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 0;
        inputFileGroup.setLayoutData((Object)gridData);
        this.createPredefinedSnapshotContorl((Composite)inputFileGroup);
        this.createSnapshotsControl((Composite)inputFileGroup);
    }

    public void updatePageCompleted() {
        if (this.supportLocalRepo) {
            if (this.remoteRepoButton.getSelection()) {
                if (RootstrapWizardData.getSnapshots().size() > 0) {
                    this.setPageComplete(true);
                    return;
                }
            } else if (this.localRepoButton.getSelection() && !this.localRepoPath.getText().isEmpty() && !this.confFilePath.getText().isEmpty()) {
                this.setPageComplete(true);
                return;
            }
        } else if (RootstrapWizardData.getSnapshots().size() > 0) {
            this.setPageComplete(true);
            return;
        }
        this.setPageComplete(false);
    }

    public void updatePredefinedSnapshot() {
        String selectedSnapshot = this.preDefinedSnapshotCombo.getText().trim();
        List<String> snapshots = RootstrapWizardData.getSnapshotMap().get(selectedSnapshot);
        int i = 0;
        while (i < this.urlTextList.size()) {
            if (i > snapshots.size() - 1) {
                this.urlTextList.get(i).setText("");
            } else {
                this.urlTextList.get(i).setText(snapshots.get(i));
            }
            ++i;
        }
    }

    protected void selectDefaultProfile() {
        int selection = 0;
        String defaultProfile = RootstrapWizardData.getDefaulatProfile();
        if (defaultProfile != null) {
            int i = 0;
            while (i < this.predefinedSnapshots.length) {
                if (defaultProfile.equals(this.predefinedSnapshots[i])) {
                    selection = i;
                    break;
                }
                ++i;
            }
        }
        this.preDefinedSnapshotCombo.select(selection);
    }

    public void createPredefinedSnapshotContorl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 0;
        composite.setLayoutData((Object)gridData);
        Label lSnapshot = new Label(composite, 0);
        lSnapshot.setText(this.resources.getString("RemoteRepo.Predefined"));
        this.preDefinedSnapshotCombo = new Combo(composite, 8);
        GridData data = new GridData(768);
        this.preDefinedSnapshotCombo.setLayoutData((Object)data);
        this.preDefinedSnapshotCombo.setItems(this.predefinedSnapshots);
        this.selectDefaultProfile();
        this.preDefinedSnapshotCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RootstrapSettingPage1.this.updatePredefinedSnapshot();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void createSnapshotsControl(Composite parent) {
        this.snapshotComp = new Composite(parent, 0);
        this.snapshotComp.setLayoutData((Object)new GridData(1808));
        this.snapshotComp.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 0;
        this.snapshotComp.setLayoutData((Object)gridData);
        if (this.snapshotMaxSize < 2) {
            this.snapshotMaxSize = 2;
        }
        this.createTextControls();
    }

    protected void createTextControls() {
        GridData data = new GridData(768);
        int i = 0;
        while (i < this.snapshotMaxSize) {
            Label label = new Label(this.snapshotComp, 0);
            label.setText(this.resources.getString("RemoteRepo.Snapshot"));
            Text url = new Text(this.snapshotComp, 2052);
            url.setLayoutData((Object)data);
            url.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    Text source = (Text)event.getSource();
                    int i = 0;
                    while (i < RootstrapSettingPage1.this.urlTextList.size()) {
                        Text target = RootstrapSettingPage1.this.urlTextList.get(i);
                        if (source.equals(target)) {
                            RootstrapWizardData.setSnapshot(source.getText().trim(), i);
                            break;
                        }
                        ++i;
                    }
                    RootstrapSettingPage1.this.updatePageCompleted();
                }
            });
            this.urlTextList.add(url);
            ++i;
        }
    }

    protected void clearTextControls() {
        Control[] controlArray = this.snapshotComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.urlTextList.clear();
    }

    public void createLocalRepoControl(Composite parent) {
        Group inputFileGroup = new Group(parent, 0);
        GridData data = new GridData(768);
        inputFileGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        inputFileGroup.setLayout((Layout)layout);
        this.createLocalRepoGroup((Composite)inputFileGroup);
    }

    private void createLocalRepoGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label lRepoPath = new Label(composite, 0);
        lRepoPath.setText(this.resources.getString("LocalRepo.RepoPath"));
        this.localRepoPath = new Text(composite, 2060);
        GridData data = new GridData(768);
        this.localRepoPath.setLayoutData((Object)data);
        this.localRepoPathButton = new Button(composite, 8);
        this.localRepoPathButton.setText(this.resources.getString("LocalRepo.Button.Browse"));
        this.localRepoPathButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(RootstrapSettingPage1.this.shell);
                dialog.setText("Choose repository path");
                String repoPath = dialog.open();
                if (repoPath != null) {
                    Path path = new Path(repoPath);
                    if (RepoManager.getValidator((IPath)path).validate()) {
                        List archs = RepoManager.getValidator((IPath)path).availableArchs();
                        if (archs == null) {
                            DialogUtil.openErrorDialog((String)RootstrapSettingPage1.this.resources.getString("LocalRepo.Error.Arch"));
                        } else {
                            RootstrapSettingPage1.this.localRepoPath.setText(repoPath);
                            RootstrapWizardData.setLocalrepoPath(repoPath);
                        }
                    } else {
                        DialogUtil.openErrorDialog((String)RootstrapSettingPage1.this.resources.getString("LocalRepo.Error.RepoFormat"));
                    }
                    RootstrapSettingPage1.this.updatePageCompleted();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        new Label(composite, 0);
        Label lRepoDesc = new Label(composite, 0);
        lRepoDesc.setText(this.resources.getString("RootstrapPage.LocalRepo.Desc"));
        new Label(composite, 0);
        Label lConfFilePath = new Label(composite, 0);
        lConfFilePath.setText(this.resources.getString("LocalRepo.ConfFilePath"));
        this.confFilePath = new Text(composite, 2060);
        this.confFilePath.setLayoutData((Object)data);
        this.confFilePathButton = new Button(composite, 8);
        this.confFilePathButton.setText(this.resources.getString("LocalRepo.Button.Browse"));
        this.confFilePathButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog fd = new FileDialog(RootstrapSettingPage1.this.shell, 4096);
                fd.setText(RootstrapSettingPage1.this.resources.getString("LocalRepo.ConfFileDlg.Title"));
                String[] filterExt = new String[]{RootstrapSettingPage1.this.resources.getString("LocalRepo.ConfFileDlg.Filter.Ext")};
                fd.setFilterExtensions(filterExt);
                String filePath = fd.open();
                if (filePath != null) {
                    Path buildConfFile = new Path(filePath);
                    RootstrapSettingPage1.this.confFilePath.setText(buildConfFile.toOSString());
                }
                RootstrapSettingPage1.this.updatePageCompleted();
                RootstrapWizardData.setConfFilePath(filePath);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        new Label(composite, 0);
        Label lConfFileDesc = new Label(composite, 0);
        lConfFileDesc.setText(this.resources.getString("RootstrapPage.BuildConf.Desc"));
    }
}

