/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativeplatform.IRootstrapManagerProxy;
import org.tizen.nativeplatform.model.Architecture;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.rootstrap.CommonRootstrapManager;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.rootstrap.util.SnapshotParser;
import org.tizen.sbilib.ide.PluginManager;

public class RootstrapManagerProxy
implements IRootstrapManagerProxy {
    public void addRootstrap(PlatformRootstrap rootstrap) {
        RootstrapInstances.getRootstrapManager().addRootstrap(rootstrap);
        PluginManager pm = PluginManager.getInstance();
        pm.reInit();
    }

    public List<PlatformRootstrap> getRootstraps(int listType) {
        return CommonRootstrapManager.getRootstraps(listType);
    }

    public List<PlatformRootstrap> getRootstraps() {
        return RootstrapInstances.getRootstrapManager().getRootstraps();
    }

    public PlatformRootstrap getRootstrap(String id) {
        return CommonRootstrapManager.getRootstrap(id);
    }

    public boolean existsRootstrap(String id) {
        return CommonRootstrapManager.existsRootstrap(id);
    }

    public void updateRootstrap(PlatformRootstrap rootstrap) {
        RootstrapInstances.getRootstrapManager().updateRootstrap(rootstrap);
    }

    public boolean checkInitialized(String rootId) {
        return CommonRootstrapManager.checkInitialized(rootId);
    }

    public PlatformRootstrap getSelectedRootstrap() {
        return CommonRootstrapManager.getSelectedRootstrap();
    }

    public void removeLatestTempDirForRootstrap() {
        RootstrapInstances.getRootstrapManager().removeLatestTempDirForRootstrap();
    }

    public PlatformRootstrap generate(String name, String arch, String version, List<Repository> reposURLs, boolean immediateGen, IPath confFile, IProgressMonitor monitor) throws InterruptedException {
        UserLogger.start((String)"gen.rootstrap");
        PlatformRootstrap rootstrap = RootstrapInstances.getRootstrapManager().generateRootstrap(name, arch, version, reposURLs, immediateGen, confFile, monitor);
        UserLogger.end((String)"gen.rootstrap");
        return rootstrap;
    }

    public boolean checkInitialized(PlatformRootstrap rootstrap) {
        return RootstrapInstances.getRootstrapManager().checkInitialized(rootstrap);
    }

    public List<String> getRpmFiles(PlatformRootstrap rootstrap) {
        return RootstrapInstances.getRootstrapManager().getRpmFiles(rootstrap);
    }

    public List<String> getXmlFiles(PlatformRootstrap rootstrap) {
        return RootstrapInstances.getRootstrapManager().getXmlFiles(rootstrap);
    }

    public String getRootstrapLocalPath(PlatformRootstrap rootstrap) {
        return RootstrapInstances.getRootstrapManager().getRootstrapLocalPath(rootstrap);
    }

    public void winCacheModificationTime(PlatformRootstrap rootstrap) {
        RootstrapInstances.getRootstrapManager().winCacheModificationTime(rootstrap);
    }

    public void winSyncronizeIfChanges(PlatformRootstrap rootstrap, IProgressMonitor monitor) {
        RootstrapInstances.getRootstrapManager().winSyncronizeIfChanges(rootstrap, monitor);
    }

    public void winSyncronize(PlatformRootstrap rootstrap, IProgressMonitor monitor) {
        RootstrapInstances.getRootstrapManager().winSyncronize(rootstrap, monitor);
    }

    public boolean generateRootstrap(PlatformRootstrap rootstrap, IProgressMonitor monitor) throws InterruptedException {
        return RootstrapInstances.getRootstrapManager().generateRootstrap(rootstrap, monitor);
    }

    public List<Architecture> parseSnapshotURL(String url, IProgressMonitor monitor) {
        ArrayList<Architecture> infos = new ArrayList<Architecture>();
        infos.addAll(SnapshotParser.parsePkgUrl(url, monitor));
        return infos;
    }

    public List<Architecture> parseRepositoryURL(String url, IProgressMonitor monitor) {
        ArrayList<Architecture> infos = new ArrayList<Architecture>();
        infos.addAll(SnapshotParser.parsePkgUrl2(url, monitor));
        return infos;
    }
}

