/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.util.PlatformFileUtil;

public class CachePackageChecksum {
    private static Map<String, Map<String, String>> checksums = new HashMap<String, Map<String, String>>();

    public static void put(String key, Map<String, String> value) {
        checksums.put(key, value);
    }

    public static Map<String, String> get(String key) {
        return checksums.get(key);
    }

    public static boolean containKey(String key) {
        return checksums.containsKey(key);
    }

    public static synchronized boolean cachePkgChecksum(IProject project, String pkgFileList) throws InterruptedException {
        if (pkgFileList == null || pkgFileList.isEmpty()) {
            return false;
        }
        String command = PlatformInstances.getScriptProvider().genCacheChecksumScript(project, pkgFileList);
        if (command == null) {
            return false;
        }
        int beforeSize = checksums.size();
        String output = HostCommandLauncher.executeOutput(command);
        PlatformInstances.getScriptProvider().cleanUpScript(command);
        String key = "";
        String[] stringArray = output.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            String[] strs = str.split("  ");
            if (strs.length == 2) {
                if (strs[0].equals("key:")) {
                    key = strs[1];
                    key = key.replace("\r", "");
                    CachePackageChecksum.put(key, new HashMap<String, String>());
                } else {
                    String s = strs[1].startsWith(".") ? strs[1].substring(1) : strs[1];
                    s = s.replace("\r", "");
                    Map<String, String> value = CachePackageChecksum.get(key);
                    if (value == null) {
                        CachePackageChecksum.put(key, new HashMap<String, String>());
                        value = CachePackageChecksum.get(key);
                    }
                    value.put(s, strs[0]);
                }
            }
            ++n2;
        }
        int afterSize = checksums.size();
        return beforeSize != afterSize;
    }

    public static boolean cachePkgChecksum(IProject project, List<IPackage> pkgFiles) throws InterruptedException {
        StringBuffer sbPaths = new StringBuffer();
        for (IPackage pkg : pkgFiles) {
            sbPaths.append(pkg.getPath());
            sbPaths.append(" ");
        }
        String pkgFileList = sbPaths.toString().trim();
        return CachePackageChecksum.cachePkgChecksum(project, pkgFileList);
    }

    public static Map<String, String> getPkgChecksum(IProject project, String pkgPaths) throws InterruptedException {
        StringBuffer sbNeedCachingPkgs = new StringBuffer();
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = pkgPaths.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (!PlatformFileUtil.existsFile(path)) {
                return null;
            }
            String pkgName = new Path(path).lastSegment();
            String key = CachePackageChecksum.getCacheKey(path);
            if (!key.startsWith(String.valueOf(pkgName) + "_")) {
                return null;
            }
            if (CachePackageChecksum.containKey(key)) {
                result.putAll(CachePackageChecksum.get(key));
            } else {
                sbNeedCachingPkgs.append(path);
                sbNeedCachingPkgs.append(" ");
            }
            ++n2;
        }
        if (sbNeedCachingPkgs.length() != 0) {
            String pkgList = sbNeedCachingPkgs.toString().trim();
            if (!CachePackageChecksum.cachePkgChecksum(project, pkgList)) {
                return null;
            }
            return CachePackageChecksum.getPkgChecksum(project, pkgList);
        }
        return result;
    }

    public static String getCacheKey(String pkgPath) throws InterruptedException {
        if (!PlatformFileUtil.existsFile(pkgPath)) {
            return "";
        }
        String workingPath = new Path(pkgPath).removeLastSegments(1).toString();
        String pkgFile = new Path(pkgPath).lastSegment();
        String command = String.format("md5sum %s", pkgFile);
        String output = HostCommandLauncher.executeOutput(command, workingPath, true, null);
        String[] content = output.trim().split(" ");
        if (content.length >= 2) {
            output = String.format("%s_%s", content[content.length - 1], content[0]);
        }
        return output;
    }
}

