/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.build.gbs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.builder.build.IBuildResultProcessor;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.IPkgModelMaker;
import org.tizen.nativeplatform.util.CommonPackageUtil;
import org.tizen.nativeplatform.util.PackageStoreManager;

public class GBSBuildResultProcessor
implements IBuildResultProcessor {
    protected IProject project;
    protected IConfiguration config;
    protected List<String> rpmfiles = new ArrayList<String>();
    protected List<String> xmlfiles = new ArrayList<String>();
    protected IPkgModelMaker modelMaker = CommonPackageUtil.getModelMaker();

    public GBSBuildResultProcessor() {
    }

    public GBSBuildResultProcessor(IConfiguration config) {
        this.project = (IProject)config.getOwner();
        this.config = config;
    }

    public void setConfiguration(IConfiguration config) {
        this.project = (IProject)config.getOwner();
        this.config = config;
    }

    public boolean process(String[] buildArguments) {
        if (buildArguments != null && buildArguments.length > 0 && buildArguments[0].equals("clean")) {
            PackageStoreManager.removeStore((IProject)this.project, (IConfiguration)this.config);
            return true;
        }
        UserLogger.start((String)"syncronize", (String)"sync.output");
        boolean result = this._process(buildArguments);
        UserLogger.end((String)"syncronize", (String)"sync.output");
        return result;
    }

    private boolean _process(String[] buildArguments) {
        String targetId = PlatformConfigurationManager.getBuildTargetName((IConfiguration)this.config);
        String rootId = SmartBuildInterface.getInstance().getRootstrapIDFromTargetID(targetId);
        PlatformRootstrap rootstrap = RootstrapProxy.getProxy().getRootstrap(rootId);
        if (rootstrap == null) {
            return false;
        }
        List rpms = RootstrapProxy.getProxy().getRpmFiles(rootstrap);
        if (rpms.isEmpty()) {
            return false;
        }
        this.rpmfiles.clear();
        this.xmlfiles.clear();
        IProject project = (IProject)this.config.getOwner();
        IPath configPath = project.getLocation().append(this.config.getName());
        for (String rpm : rpms) {
            try {
                String filename = FileUtil.getFileNameFromPath((String)rpm);
                String targetPath = configPath.append(filename).toOSString();
                FileUtil.copyTo((String)rpm, (String)targetPath);
                this.rpmfiles.add(targetPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List xmls = RootstrapProxy.getProxy().getXmlFiles(rootstrap);
        for (String xml : xmls) {
            try {
                String fileName = FileUtil.getFileNameFromPath((String)xml);
                String targetPath = configPath.append(fileName).toOSString();
                FileUtil.copyTo((String)xml, (String)targetPath);
                this.xmlfiles.add(targetPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List pkgs = this.modelMaker.makeModels(this.rpmfiles);
        PackageStoreManager.put((IProject)project, (IConfiguration)this.config, (List)pkgs);
        return true;
    }

    public String[] getRpmFiles() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.rpmfiles);
        return result.toArray(new String[0]);
    }

    public String[] getXmlFiles() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.xmlfiles);
        return result.toArray(new String[0]);
    }

    public String[] getOutputFiles() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.rpmfiles);
        result.addAll(this.xmlfiles);
        return result.toArray(new String[0]);
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

