/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.project.wizard.preference;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.util.DialogUtil;

public class SiteConfigurationDialog
extends Dialog {
    private Text siteConfigNameText;
    private Text gitBaseURIText;
    private Combo gitListTypeCombo;
    private Text gitListLocationText;
    private Button fileBrowseBt;
    private String siteConfigName = "";
    private String gitBaseURI = "";
    private String gitListType = "";
    private String gitListLocation = "";
    private int x = 0;
    private int y = 0;
    private final int width = 500;
    private Shell shell;
    private final String BUNDLE_NAME = String.valueOf(SiteConfigurationDialog.class.getPackage().getName()) + ".GitConfUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    protected SiteConfigurationDialog(Shell parentShell) {
        super(parentShell);
        this.siteConfigName = "";
        this.gitBaseURI = "";
        this.gitListType = "";
        this.gitListLocation = "";
        this.shell = parentShell;
    }

    protected SiteConfigurationDialog(Shell parentShell, String gitConfigName1, String gitBaseURI1, String gitListType1, String gitListLocation1) {
        super(parentShell);
        this.siteConfigName = gitConfigName1;
        this.gitBaseURI = gitBaseURI1;
        this.gitListType = gitListType1;
        this.gitListLocation = gitListLocation1;
        this.shell = parentShell;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.siteConfigName.isEmpty()) {
            newShell.setText(this.resources.getString("GitConfDlg.Title.Add"));
        } else {
            newShell.setText(this.resources.getString("GitConfDlg.Title.Edit"));
        }
        Rectangle bounds = newShell.getBounds();
        this.x = bounds.x + (bounds.width - 500) / 2;
        newShell.setLocation(this.x, this.y);
        newShell.setMinimumSize(500, 0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createSiteConfigNameComposite(composite);
        this.createGitConfigGroupComposite(composite);
        return null;
    }

    private void createSiteConfigNameComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label configNameLabel = new Label(composite, 0);
        GridData gridData = new GridData(256);
        gridData.widthHint = 50;
        configNameLabel.setLayoutData((Object)gridData);
        configNameLabel.setAlignment(131072);
        configNameLabel.setText(this.resources.getString("SiteConfDlg.Label.ConfigName"));
        this.siteConfigNameText = new Text(composite, 2180);
        gridData = new GridData(768);
        gridData.minimumWidth = 200;
        this.siteConfigNameText.setLayoutData((Object)gridData);
        this.siteConfigNameText.setText(this.siteConfigName);
    }

    private void createGitConfigGroupComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(this.resources.getString("SiteConfDlg.Group.Git"));
        GridData gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        this.createGitBaseURIComposite((Composite)group);
        this.createGitListComposite((Composite)group);
    }

    private void createGitBaseURIComposite(Composite composite) {
        Label gitBaseURILebel = new Label(composite, 0);
        GridData gridData = new GridData(256);
        gridData.widthHint = 100;
        gitBaseURILebel.setLayoutData((Object)gridData);
        gitBaseURILebel.setAlignment(131072);
        gitBaseURILebel.setText(this.resources.getString("SiteConfDlg.Label.GitBaseURI"));
        this.gitBaseURIText = new Text(composite, 2180);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.gitBaseURIText.setLayoutData((Object)gridData);
        this.gitBaseURIText.setText(this.gitBaseURI);
        new Label(composite, 0);
        Label gitBaseURIExLabel = new Label(composite, 0);
        gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gitBaseURIExLabel.setLayoutData((Object)gridData);
        gitBaseURIExLabel.setText(this.resources.getString("SiteConfDlg.Label.GitBaseURI.Ex"));
    }

    private void createGitListComposite(Composite composite) {
        Label gitListTypeLebel = new Label(composite, 0);
        GridData gridData = new GridData(256);
        gridData.widthHint = 100;
        gitListTypeLebel.setLayoutData((Object)gridData);
        gitListTypeLebel.setAlignment(131072);
        gitListTypeLebel.setText(this.resources.getString("SiteConfDlg.Label.GitListType"));
        this.gitListTypeCombo = new Combo(composite, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.gitListTypeCombo.setLayoutData((Object)gridData);
        String[] newItems = new String[]{"LOCAL", "GITWEB"};
        this.gitListTypeCombo.setItems(newItems);
        this.gitListTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SiteConfigurationDialog.this.gitListTypeCombo.getText().equals("LOCAL")) {
                    SiteConfigurationDialog.this.fileBrowseBt.setEnabled(true);
                } else {
                    SiteConfigurationDialog.this.fileBrowseBt.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.gitListType.isEmpty() || this.gitListType.equals("LOCAL")) {
            this.gitListTypeCombo.select(0);
        } else {
            this.gitListTypeCombo.select(1);
        }
        Label gitListLocationLabel = new Label(composite, 0);
        gridData = new GridData(256);
        gridData.widthHint = 100;
        gitListLocationLabel.setLayoutData((Object)gridData);
        gitListLocationLabel.setAlignment(131072);
        gitListLocationLabel.setText(this.resources.getString("SiteConfDlg.Label.GitListLocation"));
        this.createGitListLocationComposite(composite);
    }

    private void createGitListLocationComposite(Composite composite) {
        this.gitListLocationText = new Text(composite, 2180);
        GridData gridData = new GridData(768);
        this.gitListLocationText.setLayoutData((Object)gridData);
        this.gitListLocationText.setText(this.gitListLocation);
        this.fileBrowseBt = new Button(composite, 8);
        this.fileBrowseBt.setText(this.resources.getString("SiteConfDlg.Button.Browse"));
        this.fileBrowseBt.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog fd = new FileDialog(SiteConfigurationDialog.this.shell, 4096);
                fd.setText(SiteConfigurationDialog.this.resources.getString("FileDlg.Title"));
                String listPath = SiteConfigurationDialog.this.gitListLocationText.getText();
                if (!listPath.isEmpty()) {
                    Path p = new Path(listPath);
                    listPath = p.removeLastSegments(1).toString();
                }
                fd.setFilterPath(listPath);
                String selectedFileList = fd.open();
                if (selectedFileList != null) {
                    SiteConfigurationDialog.this.gitListLocationText.setText(selectedFileList.trim());
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    protected void okPressed() {
        this.siteConfigName = this.siteConfigNameText.getText().trim();
        this.gitBaseURI = this.gitBaseURIText.getText().trim();
        this.gitListType = this.gitListTypeCombo.getText();
        this.gitListLocation = this.gitListLocationText.getText().trim();
        if (this.siteConfigName.isEmpty()) {
            DialogUtil.openErrorDialog((String)this.resources.getString("GitConfDlg.Error.NoName"));
            return;
        }
        if (this.gitBaseURI.isEmpty()) {
            DialogUtil.openErrorDialog((String)this.resources.getString("GitConfDlg.Error.NoBaseURI"));
            return;
        }
        if (this.gitListLocation.isEmpty()) {
            DialogUtil.openErrorDialog((String)this.resources.getString("GitConfDlg.Error.NoLocation"));
            return;
        }
        super.okPressed();
    }

    public String getSiteConfigName() {
        return this.siteConfigName;
    }

    public String getGitBaseURI() {
        return this.gitBaseURI;
    }

    public String getGitListType() {
        return this.gitListType;
    }

    public String getGitListLocation() {
        return this.gitListLocation;
    }
}

