/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.project.wizard.ui;

import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.CDTCommonProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.project.wizard.ui.PlatformMainWizardPage;

public class PlatformProjectWizard
extends CDTCommonProjectWizard {
    public PlatformProjectWizard() {
        super("Tizen Platform Project", "Create a Tizen Platform Project project of selected type");
    }

    public String[] getNatures() {
        return new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature"};
    }

    protected IProject continueCreation(IProject prj) {
        if (this.continueCreationMonitor == null) {
            this.continueCreationMonitor = new NullProgressMonitor();
        }
        try {
            try {
                this.continueCreationMonitor.beginTask("Add C/C++ Project Nature", 1);
                CProjectNature.addCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
                CCProjectNature.addCCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
            }
            catch (CoreException e) {
                e.printStackTrace();
                this.continueCreationMonitor.done();
            }
        }
        finally {
            this.continueCreationMonitor.done();
        }
        return prj;
    }

    public void addPages() {
        this.fMainPage = new PlatformMainWizardPage(CUIPlugin.getResourceString((String)"CProjectWizard"));
        this.fMainPage.setTitle("Tizen Platform Project");
        this.fMainPage.setDescription("Create a Tizen Platform Project project of selected type");
        this.addPage((IWizardPage)this.fMainPage);
    }

    public String[] getContentTypeIDs() {
        return new String[]{"org.eclipse.cdt.core.cxxSource", "org.eclipse.cdt.core.cxxHeader"};
    }

    public IProject getProject(boolean defaults, boolean onFinish) {
        IProject prj = super.getProject(defaults, onFinish);
        PlatformConfigurationManager.setProjectVersion((IProject)prj, (String)"1.0.0", (boolean)true);
        return prj;
    }
}

