/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.build.gbs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.builder.build.IBuildCommandProvider;
import org.tizen.nativeplatform.builder.build.gbs.GBSUtil;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.preferences.PreferencesManager;

public class GBSBuildCommandProvider
implements IBuildCommandProvider {
    protected IConfiguration config;
    protected IProject project;

    public GBSBuildCommandProvider() {
    }

    public GBSBuildCommandProvider(IConfiguration config) {
        this.project = (IProject)config.getOwner();
        this.config = config;
    }

    public void setConfiguration(IConfiguration config) {
        this.project = (IProject)config.getOwner();
        this.config = config;
    }

    public String getCommandName() {
        return "gbs";
    }

    public String getBuildCommand() {
        return "/usr/bin/gbs";
    }

    public String[] getBuildArguments() {
        IEnvironmentVariable[] vars;
        String targetId = PlatformConfigurationManager.getBuildTargetName((IConfiguration)this.config);
        String rootId = SmartBuildInterface.getInstance().getRootstrapIDFromTargetID(targetId);
        PlatformRootstrap rt = RootstrapProxy.getProxy().getRootstrap(rootId);
        ArrayList<String> args = new ArrayList<String>();
        if (rt == null) {
            return args.toArray(new String[0]);
        }
        args.add("build");
        args.add("--arch");
        args.add(rt.getArchitecture());
        for (String snapshot : rt.getJustRepoURLs()) {
            args.add("--repository");
            args.add(snapshot);
        }
        args.add(String.format("%s=%s", "--buildroot", rt.getPath().toString()));
        for (String op : PlatformConfigurationManager.getGBSOptions((IConfiguration)this.config)) {
            args.add(op);
        }
        if (rt.getConfFile() != null && !rt.getConfFile().toString().isEmpty()) {
            args.add(String.format("%s=%s", "--dist", rt.getConfFile().toString()));
        }
        args.add("--define");
        ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)this.config);
        IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable[] iEnvironmentVariableArray = vars = mngr.getVariables(cfgDes, true);
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            if (var.getName().equals("BUILD_TYPE")) {
                args.add(String.format("\"BUILD_TYPE %s\"", var.getValue()));
                break;
            }
            ++n2;
        }
        return args.toArray(new String[0]);
    }

    public String getCleanCommand() {
        return "/bin/rm";
    }

    public String[] getCleanArguments() {
        IProject project = (IProject)this.config.getOwner();
        IPath configPath = project.getLocation().append(this.config.getName());
        ArrayList<String> args = new ArrayList<String>();
        args.add("-rf");
        args.add(configPath.toOSString());
        return args.toArray(new String[0]);
    }

    public Process getBuildProcess(CommandLauncher launcher, IProgressMonitor monitor) throws CoreException {
        Path workingPath = new Path(this.project.getLocation().toOSString());
        String[] new_envs = this.getEnvironment();
        String command = this.getBuildCommand();
        String[] arguments = this.getBuildArguments();
        if (command == null || command.isEmpty()) {
            Status status = new Status(4, "org.tizen.nativeplatform", "Failed to build the project", null);
            throw new CoreException((IStatus)status);
        }
        Process proc = launcher.execute((IPath)new Path(command), arguments, new_envs, (IPath)workingPath, monitor);
        return proc;
    }

    public Process getCleanProcess(CommandLauncher launcher, IProgressMonitor monitor) throws CoreException {
        Path workingPath = new Path(this.project.getLocation().toOSString());
        String[] new_envs = this.getEnvironment();
        String command = this.getCleanCommand();
        String[] arguments = this.getCleanArguments();
        if (command == null || command.isEmpty()) {
            Status status = new Status(4, "org.tizen.nativeplatform", "Failed to clean the project", null);
            throw new CoreException((IStatus)status);
        }
        Process proc = launcher.execute((IPath)new Path(command), arguments, new_envs, (IPath)workingPath, monitor);
        return proc;
    }

    private String[] getEnvironment() {
        String[] proxyInfo;
        ArrayList<String> newEnvArray = new ArrayList<String>();
        ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)this.config);
        IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable[] vars = mngr.getVariables(cfgDes, true);
        HashMap<String, String> envMap = new HashMap<String, String>();
        IEnvironmentVariable[] iEnvironmentVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            envMap.put(var.getName(), var.getValue());
            ++n2;
        }
        if (PreferencesManager.isProxyUsed() && (proxyInfo = PreferencesManager.getProxyParsedURL()) != null) {
            String protocol = proxyInfo[0];
            String host = proxyInfo[1];
            String port = proxyInfo[2];
            String envKey = String.format("%s_proxy", protocol);
            String envValue = String.format("%s://%s:%s", protocol, host, port);
            envMap.put(envKey, envValue);
        }
        for (Map.Entry entry : envMap.entrySet()) {
            newEnvArray.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return newEnvArray.toArray(new String[0]);
    }

    public void preBuildStep(PlatformRootstrap rootstrap, IProgressMonitor monitor) throws CoreException {
        IFolder f = this.project.getFolder(this.config.getName());
        if (f.exists()) {
            f.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        GBSUtil.gbsBuildInit((IProject)this.project);
    }

    public void postBuildStep(PlatformRootstrap rootstrap, IProgressMonitor monitor) {
        CCorePlugin.getIndexManager().reindex(CoreModel.getDefault().create(this.project));
    }

    public boolean checkTool() {
        return GBSUtil.checkTool();
    }

    public String getGBSDefaultCommand() {
        String command = this.getBuildCommand();
        if (command == null || command.isEmpty()) {
            Status status = new Status(4, "org.tizen.nativeplatform", "Failed to build the project", null);
            try {
                throw new CoreException((IStatus)status);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        String[] arguments = this.getBuildArguments();
        String[] commandArgs = new String[arguments.length + 1];
        commandArgs[0] = command;
        int i = 1;
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            command = String.valueOf(command) + " " + a;
            commandArgs[i++] = a;
            ++n2;
        }
        return command;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

